/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import lombok.Generated;
import org.bukkit.Material;

public enum SkillType {
    ARMOR("Armor", 0.3333333333333333),
    SWORDS("Swords", 1.0),
    AXES("Axes", 1.0),
    BOWS("Bows", 1.0),
    CROSSBOWS("Crossbows", 1.0),
    TRIDENTS("Tridents", 1.0),
    HOES("Hoes", 1.0);

    private final String displayName;
    private final double xpMultiplier;

    private SkillType(String displayName, double xpMultiplier) {
        this.displayName = displayName;
        this.xpMultiplier = xpMultiplier;
    }

    public static SkillType fromMaterial(Material material) {
        if (material == null) {
            return null;
        }
        String name = material.name();
        if (name.endsWith("_SWORD")) {
            return SWORDS;
        }
        if (name.endsWith("_AXE")) {
            return AXES;
        }
        if (name.endsWith("_HOE")) {
            return HOES;
        }
        if (material == Material.BOW) {
            return BOWS;
        }
        if (material == Material.CROSSBOW) {
            return CROSSBOWS;
        }
        if (material == Material.TRIDENT) {
            return TRIDENTS;
        }
        return null;
    }

    public static SkillType fromMaterialIncludingArmor(Material material) {
        if (material == null) {
            return null;
        }
        SkillType weaponType = SkillType.fromMaterial(material);
        if (weaponType != null) {
            return weaponType;
        }
        String name = material.name();
        if (name.endsWith("_HELMET") || name.endsWith("_CHESTPLATE") || name.endsWith("_LEGGINGS") || name.endsWith("_BOOTS")) {
            return ARMOR;
        }
        if (material == Material.ELYTRA) {
            return ARMOR;
        }
        if (material == Material.TURTLE_HELMET) {
            return ARMOR;
        }
        return null;
    }

    public static SkillType[] getWeaponSkills() {
        return new SkillType[]{SWORDS, AXES, BOWS, CROSSBOWS, TRIDENTS, HOES};
    }

    public boolean isWeaponSkill() {
        return this != ARMOR;
    }

    public String getColumnName() {
        return "SkillXP_" + this.name();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public double getXpMultiplier() {
        return this.xpMultiplier;
    }
}

