/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.skills;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.SkillsConfig;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillSystemMigration {
    private static final String MIGRATION_FLAG_FILE = "skill_system_migrated.flag";
    private static final Set<UUID> warnedPlayers = new HashSet<UUID>();
    private static boolean migrationComplete = false;

    private SkillSystemMigration() {
    }

    public static void initialize() {
        if (!SkillsConfig.isSkillSystemEnabled()) {
            return;
        }
        File flagFile = SkillSystemMigration.getMigrationFlagFile();
        if (flagFile.exists()) {
            migrationComplete = true;
            Logger.info((String)"[Skills] Skill system migration already complete.");
        } else {
            migrationComplete = false;
            SkillSystemMigration.createMigrationFlag();
            Logger.warn((String)"[Skills] =================================================");
            Logger.warn((String)"[Skills] SKILL SYSTEM ACTIVATED FOR THE FIRST TIME");
            Logger.warn((String)"[Skills] All players will start fresh with new skill data.");
            Logger.warn((String)"[Skills] Old guild/prestige data is preserved but unused.");
            Logger.warn((String)"[Skills] =================================================");
        }
    }

    private static File getMigrationFlagFile() {
        return new File(MetadataHandler.PLUGIN.getDataFolder(), MIGRATION_FLAG_FILE);
    }

    private static void createMigrationFlag() {
        File flagFile = SkillSystemMigration.getMigrationFlagFile();
        try {
            if (!flagFile.getParentFile().exists()) {
                flagFile.getParentFile().mkdirs();
            }
            if (flagFile.createNewFile()) {
                Logger.info((String)"[Skills] Created migration flag file.");
            }
        }
        catch (IOException e) {
            Logger.warn((String)("[Skills] Could not create migration flag file: " + e.getMessage()));
        }
    }

    public static boolean shouldWarnPlayer(Player player) {
        if (migrationComplete) {
            return false;
        }
        return !warnedPlayers.contains(player.getUniqueId());
    }

    public static void markPlayerWarned(Player player) {
        warnedPlayers.add(player.getUniqueId());
    }

    public static void sendMigrationWarning(Player player) {
        player.sendMessage(ChatColorConverter.convert((String)""));
        player.sendMessage(ChatColorConverter.convert((String)"&8&m------------------------------------------------"));
        player.sendMessage(ChatColorConverter.convert((String)"&5&lSKILL SYSTEM ACTIVATED"));
        player.sendMessage(ChatColorConverter.convert((String)"&7EliteMobs now uses a new skill leveling system!"));
        player.sendMessage(ChatColorConverter.convert((String)""));
        player.sendMessage(ChatColorConverter.convert((String)"&eYou now level individual skills by killing mobs:"));
        player.sendMessage(ChatColorConverter.convert((String)"&7- Swords, Axes, Bows, Crossbows, Tridents, Hoes"));
        player.sendMessage(ChatColorConverter.convert((String)"&7- Armor levels on every kill at 1/3 XP rate"));
        player.sendMessage(ChatColorConverter.convert((String)""));
        player.sendMessage(ChatColorConverter.convert((String)"&cAll players start fresh with Level 1 in all skills."));
        player.sendMessage(ChatColorConverter.convert((String)"&7Type &e/em &7and click &5Skills &7to view your progress!"));
        player.sendMessage(ChatColorConverter.convert((String)"&8&m------------------------------------------------"));
        player.sendMessage(ChatColorConverter.convert((String)""));
    }

    public static void shutdown() {
        warnedPlayers.clear();
    }

    public static class MigrationEvents
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPlayerJoin(PlayerJoinEvent event) {
            if (!SkillsConfig.isSkillSystemEnabled()) {
                return;
            }
            final Player player = event.getPlayer();
            new BukkitRunnable(this){

                public void run() {
                    if (!player.isOnline()) {
                        return;
                    }
                    if (SkillSystemMigration.shouldWarnPlayer(player)) {
                        SkillSystemMigration.sendMigrationWarning(player);
                        SkillSystemMigration.markPlayerWarned(player);
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 40L);
        }
    }
}

