/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.config.menus.premade.DynamicQuestMenuConfig;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.DynamicKillObjective;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import com.magmaguy.elitemobs.quests.rewards.QuestReward;
import com.magmaguy.elitemobs.skills.CombatLevelCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DynamicQuest
extends Quest {
    private static final HashMap<Integer, List<QuestObjectives>> threeRandomDynamicObjectives = new HashMap();
    private static BukkitTask randomizerTask;

    public DynamicQuest(Player player, int questLevel, QuestObjectives questObjectives) {
        super(player, questObjectives, questLevel);
        this.questName = DynamicQuestMenuConfig.getQuestName().replace("$amount", "" + questObjectives.getObjectives().get(0).getTargetAmount()).replace("$name", ChatColor.stripColor((String)EliteMobProperties.getPluginData(((DynamicKillObjective)questObjectives.getObjectives().get(0)).getEntityType()).getName(questLevel * 10)));
        questObjectives.setQuest(this);
    }

    public static void startRandomizingQuests() {
        randomizerTask = new BukkitRunnable(){

            public void run() {
                for (int activeLevel = 1; activeLevel < 21; ++activeLevel) {
                    ArrayList<QuestObjectives> questObjectives = new ArrayList<QuestObjectives>();
                    for (int questNumber = 0; questNumber < 3; ++questNumber) {
                        questObjectives.add(new QuestObjectives(activeLevel));
                    }
                    threeRandomDynamicObjectives.put(activeLevel, questObjectives);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1200L);
    }

    public static void shutdown() {
        threeRandomDynamicObjectives.clear();
        if (randomizerTask != null) {
            randomizerTask.cancel();
        }
    }

    public static List<DynamicQuest> generateQuests(Player player) {
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(player.getUniqueId());
        int questLevel = Math.min(20, Math.max(1, combatLevel / 5));
        if (questLevel == 0) {
            player.sendMessage(QuestsConfig.getLowRankDynamicQuestWarning());
            return new ArrayList<DynamicQuest>();
        }
        ArrayList<DynamicQuest> dynamicQuests = new ArrayList<DynamicQuest>();
        for (QuestObjectives questObjectives : threeRandomDynamicObjectives.get(questLevel)) {
            QuestReward questReward = new QuestReward(questLevel, questObjectives, player);
            questObjectives.setQuestReward(questReward);
            dynamicQuests.add(new DynamicQuest(player, questLevel, questObjectives));
        }
        return dynamicQuests;
    }

    public static List<DynamicQuest> getQuests(Player player) {
        ArrayList<DynamicQuest> dynamicQuests = new ArrayList<DynamicQuest>();
        if (PlayerData.getQuests(player.getUniqueId()) != null) {
            for (Quest quest : PlayerData.getQuests(player.getUniqueId())) {
                if (!(quest instanceof DynamicQuest)) continue;
                DynamicQuest dynamicQuest = (DynamicQuest)quest;
                dynamicQuests.add(dynamicQuest);
            }
        }
        for (DynamicQuest generatedQuest : DynamicQuest.generateQuests(player)) {
            boolean exists = false;
            for (DynamicQuest dynamicQuest : dynamicQuests) {
                if (!dynamicQuest.getQuestObjectives().getUuid().equals(generatedQuest.getQuestObjectives().getUuid())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            dynamicQuests.add(generatedQuest);
        }
        return dynamicQuests;
    }
}

