/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.QuestAcceptEvent;
import com.magmaguy.elitemobs.api.QuestRewardEvent;
import com.magmaguy.elitemobs.config.customquests.CustomQuestsConfig;
import com.magmaguy.elitemobs.config.customquests.CustomQuestsConfigFields;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.QuestObjectives;
import com.magmaguy.elitemobs.quests.playercooldowns.PlayerQuestCooldowns;
import com.magmaguy.elitemobs.quests.rewards.QuestReward;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class CustomQuest
extends Quest {
    private final String configurationFilename;
    private transient CustomQuestsConfigFields customQuestsConfigFields;

    public CustomQuest(Player player, CustomQuestsConfigFields customQuestsConfigFields) {
        super(player, new QuestObjectives(new QuestReward(customQuestsConfigFields, player)), customQuestsConfigFields.getQuestLevel());
        this.customQuestsConfigFields = customQuestsConfigFields;
        this.configurationFilename = customQuestsConfigFields.getFilename();
        this.questObjectives.setQuest(this);
        this.questName = customQuestsConfigFields.getQuestName();
        this.questTaker = customQuestsConfigFields.getTurnInNPC();
    }

    public static CustomQuest getQuest(String questFilename, Player player) {
        if (CustomQuestsConfig.getCustomQuests().get(questFilename) == null) {
            return null;
        }
        Quest quest = null;
        for (Quest iteratedQuest : PlayerData.getQuests(player.getUniqueId())) {
            if (!(iteratedQuest instanceof CustomQuest) || !((CustomQuest)iteratedQuest).getConfigurationFilename().equals(questFilename)) continue;
            quest = iteratedQuest;
            break;
        }
        if (quest != null) {
            return (CustomQuest)quest;
        }
        return new CustomQuest(player, CustomQuestsConfig.getCustomQuests().get(questFilename));
    }

    public static Quest startQuest(String questID, Player player) {
        Quest quest = null;
        for (Quest iteratedQuest : (List)pendingPlayerQuests.get(player.getUniqueId())) {
            if (!iteratedQuest.getQuestID().equals(UUID.fromString(questID))) continue;
            quest = iteratedQuest;
            break;
        }
        if (quest == null) {
            player.sendMessage(ChatColorConverter.convert((String)("&8[EliteMobs] &cInvalid quest ID for ID " + questID)));
            return null;
        }
        QuestAcceptEvent questAcceptEvent = new QuestAcceptEvent(player, quest);
        new EventCaller(questAcceptEvent);
        if (questAcceptEvent.isCancelled()) {
            return null;
        }
        return quest;
    }

    public CustomQuestsConfigFields getCustomQuestsConfigFields() {
        if (this.customQuestsConfigFields == null) {
            this.customQuestsConfigFields = CustomQuestsConfig.getCustomQuests().get(this.configurationFilename);
        }
        if (this.customQuestsConfigFields == null) {
            Logger.warn((String)("Detected that Custom Quest " + this.configurationFilename + " got removed even though player " + Bukkit.getPlayer((UUID)this.getPlayerUUID()).getName() + " is still trying to complete it. This player's quest will now be wiped."));
            PlayerData.removeQuest(this.getPlayerUUID(), this);
            return null;
        }
        return this.customQuestsConfigFields;
    }

    public void applyTemporaryPermissions(Player player) {
        if (!this.getCustomQuestsConfigFields().getTemporaryPermissions().isEmpty()) {
            PermissionAttachment permissionAttachment = player.addAttachment((Plugin)MetadataHandler.PLUGIN);
            for (String permission : this.getCustomQuestsConfigFields().getTemporaryPermissions()) {
                permissionAttachment.setPermission(permission, true);
            }
        }
    }

    public void applyEndPermissions(Player player) {
        if (!this.getCustomQuestsConfigFields().getTemporaryPermissions().isEmpty()) {
            PermissionAttachment permissionAttachment = player.addAttachment((Plugin)MetadataHandler.PLUGIN);
            for (String permission : this.getCustomQuestsConfigFields().getTemporaryPermissions()) {
                permissionAttachment.unsetPermission(permission);
            }
        }
        if (!this.getCustomQuestsConfigFields().getQuestLockoutPermission().isEmpty()) {
            PlayerQuestCooldowns.addCooldown(player, this.getCustomQuestsConfigFields().getQuestLockoutPermission(), this.getCustomQuestsConfigFields().getQuestLockoutMinutes());
        }
    }

    public boolean hasPermissionForQuest(Player player) {
        if (PlayerQuestCooldowns.bypassesQuestRestrictions(player)) {
            return true;
        }
        if (this.customQuestsConfigFields.getQuestAcceptPermissions() != null && !this.customQuestsConfigFields.getQuestAcceptPermissions().isEmpty()) {
            for (String permission : this.customQuestsConfigFields.getQuestAcceptPermissions()) {
                if (player.hasMetadata(permission)) continue;
                return false;
            }
        }
        if (!this.customQuestsConfigFields.getQuestAcceptPermission().isEmpty() && !player.hasMetadata(this.customQuestsConfigFields.getQuestAcceptPermission())) {
            return false;
        }
        return this.customQuestsConfigFields.getQuestLockoutPermission().isEmpty() || !player.hasMetadata(this.customQuestsConfigFields.getQuestLockoutPermission());
    }

    @Generated
    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public static class CustomQuestEvents
    implements Listener {
        @EventHandler
        public void onQuestReward(QuestRewardEvent event) {
            Quest quest = event.getQuest();
            if (quest instanceof CustomQuest) {
                CustomQuest customQuest = (CustomQuest)quest;
                CustomQuestsConfigFields customQuestsConfigFields = customQuest.getCustomQuestsConfigFields();
                customQuest.applyEndPermissions(event.getPlayer());
                if (customQuest.getCustomQuestsConfigFields().getQuestCompleteDialog() != null && !customQuest.getCustomQuestsConfigFields().getQuestCompleteDialog().isEmpty()) {
                    for (String dialog : customQuest.getCustomQuestsConfigFields().getQuestCompleteDialog()) {
                        event.getPlayer().sendMessage(dialog);
                    }
                }
                for (String command : customQuestsConfigFields.getQuestCompleteCommands()) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("$player", event.getPlayer().getName()).replace("$getX", "" + event.getPlayer().getLocation().getX()).replace("$getY", "" + event.getPlayer().getLocation().getY()).replace("$getZ", "" + event.getPlayer().getLocation().getZ()));
                }
            }
        }
    }
}

