/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts.caching;

import com.magmaguy.elitemobs.powers.scripts.caching.ScriptRelativeVectorBlueprint;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptFloat;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptInteger;
import com.magmaguy.elitemobs.utils.MapListInterpreter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Particle;

public class ScriptParticlesBlueprint {
    private final List<ScriptParticleBlueprint> particleBlueprints = new ArrayList<ScriptParticleBlueprint>();

    public ScriptParticlesBlueprint(List<Map<?, ?>> entries, String scriptName, String filename) {
        for (Map<?, ?> entry : entries) {
            this.particleBlueprints.add(new ScriptParticleBlueprint(this, entry, scriptName, filename));
        }
    }

    public ScriptParticlesBlueprint() {
    }

    @Generated
    public List<ScriptParticleBlueprint> getParticleBlueprints() {
        return this.particleBlueprints;
    }

    public class ScriptParticleBlueprint {
        private final String scriptName;
        private final String filename;
        private ScriptFloat x = new ScriptFloat(0.01f);
        private ScriptFloat y = new ScriptFloat(0.01f);
        private ScriptFloat z = new ScriptFloat(0.01f);
        private ScriptInteger amount = new ScriptInteger(1);
        private ScriptInteger red = new ScriptInteger(255);
        private ScriptInteger green = new ScriptInteger(255);
        private ScriptInteger blue = new ScriptInteger(255);
        private ScriptInteger toRed = new ScriptInteger(255);
        private ScriptInteger toGreen = new ScriptInteger(255);
        private ScriptInteger toBlue = new ScriptInteger(255);
        private Particle particle = Particle.FLAME;
        private ScriptFloat speed = new ScriptFloat(0.01f);
        private Boolean moveToTarget = null;
        private ScriptRelativeVectorBlueprint relativeVectorBlueprint = null;

        public ScriptParticleBlueprint(ScriptParticlesBlueprint this$0, Map<?, ?> entry, String scriptName, String filename) {
            this.filename = filename;
            this.scriptName = scriptName;
            this.processMapList(entry);
        }

        private void processMapList(Map<?, ?> entry) {
            for (Map.Entry<?, ?> entrySet : entry.entrySet()) {
                String key = (String)entrySet.getKey();
                this.processKeyAndValue(key, entrySet.getValue());
            }
        }

        private void processKeyAndValue(String key, Object value) {
            switch (key.toLowerCase(Locale.ROOT)) {
                case "x": {
                    this.x = MapListInterpreter.parseScriptFloat(key, value, this.scriptName);
                    break;
                }
                case "y": {
                    this.y = MapListInterpreter.parseScriptFloat(key, value, this.scriptName);
                    break;
                }
                case "z": {
                    this.z = MapListInterpreter.parseScriptFloat(key, value, this.scriptName);
                    break;
                }
                case "amount": {
                    this.amount = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "particle": {
                    this.particle = MapListInterpreter.parseEnum(key, value, Particle.class, this.scriptName);
                    break;
                }
                case "speed": {
                    this.speed = MapListInterpreter.parseScriptFloat(key, value, this.scriptName);
                    break;
                }
                case "red": {
                    this.red = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "green": {
                    this.green = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "blue": {
                    this.blue = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "tored": {
                    this.toRed = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "togreen": {
                    this.toGreen = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "toblue": {
                    this.toBlue = MapListInterpreter.parseScriptInteger(key, value, this.scriptName);
                    break;
                }
                case "movetotarget": {
                    this.moveToTarget = MapListInterpreter.parseBoolean(key, value, this.scriptName);
                    break;
                }
                case "relativevector": {
                    this.relativeVectorBlueprint = new ScriptRelativeVectorBlueprint(this.scriptName, this.filename, (Map)value);
                    break;
                }
                default: {
                    Logger.warn((String)("Key " + key + " in script " + this.scriptName + " in file " + this.filename + " for script particles is not a valid key!"));
                }
            }
        }

        @Generated
        public String getScriptName() {
            return this.scriptName;
        }

        @Generated
        public ScriptFloat getX() {
            return this.x;
        }

        @Generated
        public ScriptFloat getY() {
            return this.y;
        }

        @Generated
        public ScriptFloat getZ() {
            return this.z;
        }

        @Generated
        public ScriptInteger getAmount() {
            return this.amount;
        }

        @Generated
        public ScriptInteger getRed() {
            return this.red;
        }

        @Generated
        public ScriptInteger getGreen() {
            return this.green;
        }

        @Generated
        public ScriptInteger getBlue() {
            return this.blue;
        }

        @Generated
        public ScriptInteger getToRed() {
            return this.toRed;
        }

        @Generated
        public ScriptInteger getToGreen() {
            return this.toGreen;
        }

        @Generated
        public ScriptInteger getToBlue() {
            return this.toBlue;
        }

        @Generated
        public Particle getParticle() {
            return this.particle;
        }

        @Generated
        public ScriptFloat getSpeed() {
            return this.speed;
        }

        @Generated
        public Boolean getMoveToTarget() {
            return this.moveToTarget;
        }

        @Generated
        public ScriptRelativeVectorBlueprint getRelativeVectorBlueprint() {
            return this.relativeVectorBlueprint;
        }
    }
}

