/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.api.EliteMobSpawnEvent;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptActions;
import com.magmaguy.elitemobs.powers.scripts.ScriptConditions;
import com.magmaguy.elitemobs.powers.scripts.ScriptCooldowns;
import com.magmaguy.elitemobs.powers.scripts.ScriptEvents;
import com.magmaguy.elitemobs.powers.scripts.ScriptZone;
import com.magmaguy.elitemobs.powers.scripts.caching.EliteScriptBlueprint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class EliteScript
extends ElitePower
implements Cloneable {
    protected ScriptActions scriptActions;
    private ScriptEvents scriptEvents;
    private ScriptZone scriptZone;
    private ScriptCooldowns scriptCooldowns;
    private ScriptConditions scriptConditions;
    protected Map<String, EliteScript> eliteScriptMap;
    private boolean halt = false;

    public EliteScript(EliteScriptBlueprint scriptBlueprint, Map<String, EliteScript> eliteScriptMap, EliteEntity eliteEntity) {
        super(scriptBlueprint.getCustomConfigFields());
        if (this.halt) {
            return;
        }
        this.eliteScriptMap = eliteScriptMap;
        this.scriptEvents = new ScriptEvents(scriptBlueprint.getScriptEventsBlueprint());
        this.scriptConditions = new ScriptConditions(scriptBlueprint.getScriptConditionsBlueprint(), this, false);
        this.scriptZone = new ScriptZone(scriptBlueprint.getScriptZoneBlueprint(), this);
        this.initializeCustomEvents(eliteEntity);
        this.scriptActions = new ScriptActions(scriptBlueprint.getScriptActionsBlueprint(), eliteScriptMap, this);
        this.scriptCooldowns = new ScriptCooldowns(scriptBlueprint.getScriptCooldownsBlueprint(), this);
        eliteScriptMap.put(scriptBlueprint.getScriptName(), this);
    }

    public static List<EliteScript> generateBossScripts(List<EliteScriptBlueprint> blueprints, EliteEntity eliteEntity) {
        HashMap powerMap = new HashMap();
        return blueprints.stream().map(eliteScriptBlueprint -> new EliteScript((EliteScriptBlueprint)eliteScriptBlueprint, powerMap, eliteEntity)).collect(Collectors.toList());
    }

    public void check(Event event, EliteEntity eliteEntity, Player player) {
        if (this.getPowerCooldownTime() > 0 && this.getGlobalCooldownTime() > 0 && this.scriptCooldowns != null && super.isInCooldown(eliteEntity)) {
            return;
        }
        if (!this.scriptEvents.isTargetEvent(event.getClass())) {
            return;
        }
        if (this.scriptConditions != null && !this.scriptConditions.meetsPreActionConditions(eliteEntity, (LivingEntity)player)) {
            return;
        }
        this.scriptActions.runScripts(eliteEntity, (LivingEntity)player, event);
        this.doCooldownTicks(eliteEntity);
    }

    public void check(Event event, EliteEntity eliteEntity, LivingEntity damager) {
        if (this.getPowerCooldownTime() > 0 && this.getGlobalCooldownTime() > 0 && this.scriptCooldowns != null && super.isInCooldown(eliteEntity)) {
            return;
        }
        if (!this.scriptEvents.isTargetEvent(event.getClass())) {
            return;
        }
        if (this.scriptConditions != null && !this.scriptConditions.meetsPreActionConditions(eliteEntity, damager)) {
            return;
        }
        this.scriptActions.runScripts(eliteEntity, damager, event);
        this.doCooldownTicks(eliteEntity);
    }

    public void check(EliteEntity eliteEntity, LivingEntity directTarget, ScriptActionData previousScriptActionData) {
        if (this.scriptConditions != null && !this.scriptConditions.meetsPreActionConditions(eliteEntity, directTarget)) {
            return;
        }
        this.scriptActions.runScripts(previousScriptActionData);
        this.doCooldownTicks(eliteEntity);
    }

    public void check(Location landingLocation, ScriptActionData previousScriptActionData) {
        if (this.scriptConditions != null && !this.scriptConditions.meetsPreActionConditions(previousScriptActionData.getEliteEntity(), null)) {
            return;
        }
        this.scriptActions.runScripts(previousScriptActionData, landingLocation);
        this.doCooldownTicks(previousScriptActionData.getEliteEntity());
    }

    public void initializeCustomEvents(EliteEntity eliteEntity) {
        if (this.scriptEvents.getScriptEventsBlueprint().isZoneListener()) {
            this.scriptZone.setZoneListener(true);
            this.scriptZone.startZoneListener(eliteEntity);
        }
    }

    @Generated
    public ScriptZone getScriptZone() {
        return this.scriptZone;
    }

    @Generated
    public Map<String, EliteScript> getEliteScriptMap() {
        return this.eliteScriptMap;
    }

    @Generated
    public void setHalt(boolean halt) {
        this.halt = halt;
    }

    public static class EliteScriptEvents
    implements Listener {
        @EventHandler
        public void onSpawn(EliteMobSpawnEvent event) {
            EliteEntity eliteEntity = event.getEliteMobEntity();
            if (eliteEntity instanceof CustomBossEntity) {
                CustomBossEntity customBossEntity = (CustomBossEntity)eliteEntity;
                customBossEntity.getElitePowers().forEach(elitePower -> {
                    if (elitePower instanceof EliteScript) {
                        EliteScript eliteScript = (EliteScript)elitePower;
                        eliteScript.initializeCustomEvents(event.getEliteMobEntity());
                    }
                });
            }
        }
    }
}

