/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.config.powers.premade.ZombieParentsConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import com.magmaguy.magmacore.util.Logger;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ZombieParents
extends MajorPower
implements Listener {
    public ZombieParents() {
        super(PowersConfig.getPower("zombie_parents.yml"));
    }

    private static void startDialog(final CustomBossEntity reinforcementMom, final CustomBossEntity reinforcementDad, final EliteEntity bossEntity) {
        new BukkitRunnable(){

            public void run() {
                if (!bossEntity.isValid()) {
                    ZombieParents.doDeathMessages(reinforcementDad, reinforcementMom);
                    this.cancel();
                } else {
                    ZombieParents.doDialog(reinforcementDad, reinforcementMom, bossEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 20L, 160L);
    }

    private static void doDeathMessages(CustomBossEntity reinforcementDad, CustomBossEntity reinforcementMom) {
        if (reinforcementDad.isValid()) {
            ZombieParents.nameClearer(reinforcementDad);
            reinforcementDad.getLivingEntity().setCustomName(ZombieParentsConfig.getDeathMessage().get(ThreadLocalRandom.current().nextInt(ZombieParentsConfig.getDeathMessage().size())));
        }
        if (reinforcementMom.isValid()) {
            ZombieParents.nameClearer(reinforcementMom);
            reinforcementMom.getLivingEntity().setCustomName(ZombieParentsConfig.getDeathMessage().get(ThreadLocalRandom.current().nextInt(ZombieParentsConfig.getDeathMessage().size())));
        }
    }

    private static void doDialog(CustomBossEntity reinforcementDad, CustomBossEntity reinforcementMom, EliteEntity bossEntity) {
        if (ThreadLocalRandom.current().nextDouble() < 0.5) {
            ZombieParents.nameClearer(bossEntity);
            bossEntity.getLivingEntity().setCustomName(ZombieParentsConfig.getBossEntityDialog().get(ThreadLocalRandom.current().nextInt(ZombieParentsConfig.getBossEntityDialog().size())));
        }
        if (ThreadLocalRandom.current().nextDouble() < 0.5 && reinforcementDad.isValid()) {
            ZombieParents.nameClearer(reinforcementDad);
            reinforcementDad.getLivingEntity().setCustomName(ZombieParentsConfig.getZombieDad().get(ThreadLocalRandom.current().nextInt(ZombieParentsConfig.getZombieDad().size())));
        }
        if (ThreadLocalRandom.current().nextDouble() < 0.5 && reinforcementMom.isValid()) {
            ZombieParents.nameClearer(reinforcementMom);
            reinforcementMom.getLivingEntity().setCustomName(ZombieParentsConfig.getZombieMom().get(ThreadLocalRandom.current().nextInt(ZombieParentsConfig.getZombieMom().size())));
        }
    }

    private static void nameClearer(final EliteEntity eliteEntity) {
        new BukkitRunnable(){

            public void run() {
                if (eliteEntity.isValid()) {
                    eliteEntity.setName(eliteEntity.getName(), true);
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 60L);
    }

    @EventHandler
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        ZombieParents zombieParents = (ZombieParents)event.getEliteMobEntity().getPower(this);
        if (zombieParents == null) {
            return;
        }
        if (zombieParents.isFiring()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.01) {
            return;
        }
        zombieParents.setFiring(false);
        CustomBossEntity reinforcementMom = CustomBossEntity.createCustomBossEntity("zombie_parents_mom.yml");
        try {
            reinforcementMom.spawn(event.getEntity().getLocation(), event.getEliteMobEntity().getLevel(), false);
        }
        catch (Exception ex) {
            Logger.warn((String)"Failed to spawn Zombie Parents Mom reinforcement!");
            return;
        }
        CustomBossEntity reinforcementDad = CustomBossEntity.createCustomBossEntity("zombie_parents_dad.yml");
        try {
            reinforcementDad.spawn(event.getEntity().getLocation(), event.getEliteMobEntity().getLevel(), false);
        }
        catch (Exception ex) {
            Logger.warn((String)"Failed to spawn Zombie Parents Dad reinforcement!");
            return;
        }
        ZombieParents.startDialog(reinforcementMom, reinforcementDad, event.getEliteMobEntity());
    }
}

