/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.magmacore.util.Logger;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SummonTheReturned
extends BossPower
implements Listener {
    public SummonTheReturned() {
        super(PowersConfig.getPower("summon_the_returned.yml"));
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        SummonTheReturned summonTheReturned = (SummonTheReturned)event.getEliteMobEntity().getPower(this);
        if (summonTheReturned == null) {
            return;
        }
        if (!SummonTheReturned.eventIsValid(event, (ElitePower)summonTheReturned)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        summonTheReturned.doGlobalCooldown(400, event.getEliteMobEntity());
        this.doSummonParticles(event.getEliteMobEntity());
    }

    private void doSummonParticles(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.PORTAL, eliteEntity.getLivingEntity().getLocation().add(new Vector(0, 1, 0)), 50, 0.01, 0.01, 0.01, 1.0);
                if (this.counter < 60) {
                    return;
                }
                this.cancel();
                SummonTheReturned.this.doSummon(eliteEntity);
                eliteEntity.getLivingEntity().setAI(true);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doSummon(EliteEntity eliteEntity) {
        for (int i = 0; i < 10; ++i) {
            Location spawnLocation = eliteEntity.getLivingEntity().getLocation();
            CustomBossEntity.createCustomBossEntity("the_returned.yml").spawn(spawnLocation, eliteEntity.getLevel(), false);
            double x = ThreadLocalRandom.current().nextDouble() - 0.5;
            double z = ThreadLocalRandom.current().nextDouble() - 0.5;
            try {
                eliteEntity.getLivingEntity().setVelocity(new Vector(x, 0.5, z));
                continue;
            }
            catch (Exception ex) {
                Logger.warn((String)"Attempted to complete Summon the Returned power but a reinforcement mob wasn't detected! Did the boss move to an area that prevents spawning?");
            }
        }
    }
}

