/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ShieldWall
extends MinorPower {
    private final HashMap<Direction, List<ArmorStand>> armorStands = new HashMap();
    private final HashMap<Direction, Vector> armorStandOffBaseOffsets = new HashMap();
    private double northHealthPool;
    private double southHealthPool;
    private double eastHealthPool;
    private double westHealthPool;
    private boolean isActive = false;

    public ShieldWall() {
        super(PowersConfig.getPower("shield_wall.yml"));
        this.offsetInitializer();
    }

    public boolean preventDamage(Player player, EliteEntity eliteEntity, double damage) {
        if (!Objects.equals(player.getLocation().getWorld(), eliteEntity.getLocation().getWorld())) {
            return false;
        }
        Vector direction = player.getLocation().subtract(eliteEntity.getLocation()).toVector().normalize();
        Direction damageDirection = Math.abs(direction.getX()) > Math.abs(direction.getZ()) ? (direction.getX() > 0.0 ? Direction.EAST : Direction.WEST) : (direction.getZ() > 0.0 ? Direction.SOUTH : Direction.NORTH);
        switch (damageDirection.ordinal()) {
            case 0: {
                if (!(this.northHealthPool > 0.0)) break;
                this.northHealthPool -= damage;
                return true;
            }
            case 1: {
                if (!(this.southHealthPool > 0.0)) break;
                this.southHealthPool -= damage;
                return true;
            }
            case 2: {
                if (!(this.eastHealthPool > 0.0)) break;
                this.eastHealthPool -= damage;
                return true;
            }
            default: {
                if (!(this.westHealthPool > 0.0)) break;
                this.westHealthPool -= damage;
                return true;
            }
        }
        return false;
    }

    public void initialize(EliteEntity eliteEntity) {
        if (ThreadLocalRandom.current().nextDouble() >= 0.1) {
            return;
        }
        this.doCooldown(eliteEntity);
        int direction = ThreadLocalRandom.current().nextInt(1, 5);
        this.northHealthPool = eliteEntity.getLevel();
        this.southHealthPool = eliteEntity.getLevel();
        this.eastHealthPool = eliteEntity.getLevel();
        this.westHealthPool = eliteEntity.getLevel();
        switch (direction) {
            case 1: {
                this.northHealthPool = 0.0;
                break;
            }
            case 2: {
                this.eastHealthPool = 0.0;
                break;
            }
            case 3: {
                this.southHealthPool = 0.0;
                break;
            }
            case 4: {
                this.westHealthPool = 0.0;
            }
        }
        for (int i = 1; i < 5; ++i) {
            if (direction == i) continue;
            this.armorStands.put(this.directionConverter(i), this.armorStandCreator(this.directionConverter(i), eliteEntity));
        }
        this.armorStandTracker(eliteEntity);
        this.setActive(true);
    }

    private Direction directionConverter(int direction) {
        switch (direction) {
            case 1: {
                return Direction.NORTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.SOUTH;
            }
        }
        return Direction.WEST;
    }

    private void offsetInitializer() {
        block5: for (int i = 1; i < 5; ++i) {
            switch (i) {
                case 1: {
                    this.armorStandOffBaseOffsets.put(this.directionConverter(i), new Vector(0, 0, -1));
                    continue block5;
                }
                case 2: {
                    this.armorStandOffBaseOffsets.put(this.directionConverter(i), new Vector(1, 0, 0));
                    continue block5;
                }
                case 3: {
                    this.armorStandOffBaseOffsets.put(this.directionConverter(i), new Vector(0, 0, 1));
                    continue block5;
                }
                default: {
                    this.armorStandOffBaseOffsets.put(this.directionConverter(i), new Vector(-1, 0, 0));
                }
            }
        }
    }

    private Location getRealLocation(Direction direction, Location livingEntityLocation, int iteration) {
        Vector finalOffsetVector = direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH) ? this.armorStandOffBaseOffsets.get((Object)direction).clone().add(new Vector(iteration, 0, 0)) : this.armorStandOffBaseOffsets.get((Object)direction).clone().add(new Vector(0, 0, iteration));
        Location realLocation = livingEntityLocation.clone().add(finalOffsetVector);
        switch (direction.ordinal()) {
            case 0: {
                realLocation.setYaw(180.0f);
                break;
            }
            case 1: {
                realLocation.setYaw(0.0f);
                break;
            }
            case 2: {
                realLocation.setYaw(-90.0f);
                break;
            }
            default: {
                realLocation.setYaw(90.0f);
            }
        }
        realLocation.setPitch(0.0f);
        return realLocation;
    }

    private List<ArmorStand> armorStandCreator(Direction direction, EliteEntity eliteEntity) {
        ArrayList<ArmorStand> armorStands = new ArrayList<ArmorStand>();
        for (int i = -1; i < 2; ++i) {
            ArmorStand armorStand = VisualDisplay.generateTemporaryArmorStand(this.getRealLocation(direction, eliteEntity.getLivingEntity().getLocation(), i), "Barrier");
            armorStands.add(armorStand);
            armorStand.getEquipment().setItemInMainHand(new ItemStack(Material.SHIELD));
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.REMOVING_OR_CHANGING);
            armorStand.setRightArmPose(new EulerAngle(1.5707963267948966, 4.71238898038469, Math.PI));
        }
        return armorStands;
    }

    private void armorStandTracker(EliteEntity eliteEntity) {
        Bukkit.getScheduler().runTaskTimer((Plugin)MetadataHandler.PLUGIN, task -> {
            if (!eliteEntity.isValid() || this.northHealthPool == 0.0 && this.southHealthPool == 0.0 && this.eastHealthPool == 0.0 && this.westHealthPool == 0.0 || !this.isActive) {
                task.cancel();
                this.setActive(false);
                for (List<ArmorStand> armorStands : this.armorStands.values()) {
                    if (armorStands == null) continue;
                    for (ArmorStand armorStand : armorStands) {
                        if (armorStand == null || !armorStand.isValid()) continue;
                        EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                    }
                }
                return;
            }
            int visualShieldsLeft = 0;
            for (Direction direction : this.armorStands.keySet()) {
                for (int i = -1; i < 2; ++i) {
                    ArmorStand armorStand = this.armorStands.get((Object)direction).get(i + 1);
                    if (armorStand == null || !armorStand.isValid()) continue;
                    switch (direction.ordinal()) {
                        case 0: {
                            if (!(0.33 * (double)(i + 1) >= this.northHealthPool / (double)eliteEntity.getLevel())) break;
                            EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                            break;
                        }
                        case 1: {
                            if (!(0.33 * (double)(i + 1) >= this.southHealthPool / (double)eliteEntity.getLevel())) break;
                            EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                            break;
                        }
                        case 2: {
                            if (!(0.33 * (double)(i + 1) >= this.eastHealthPool / (double)eliteEntity.getLevel())) break;
                            EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                            break;
                        }
                        default: {
                            if (!(0.33 * (double)(i + 1) >= this.westHealthPool / (double)eliteEntity.getLevel())) break;
                            EntityTracker.unregister((Entity)armorStand, RemovalReason.EFFECT_TIMEOUT);
                        }
                    }
                    ++visualShieldsLeft;
                    armorStand.teleport(this.getRealLocation(direction, eliteEntity.getLivingEntity().getLocation(), i));
                }
            }
            if (visualShieldsLeft == 0) {
                task.cancel();
                this.setActive(false);
            }
        }, 1L, 1L);
    }

    @Generated
    public boolean isActive() {
        return this.isActive;
    }

    @Generated
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }

    public static class ShieldWallEvents
    implements Listener {
        @EventHandler
        public void onEliteHit(EliteMobDamagedByPlayerEvent event) {
            ElitePower elitePower = event.getEliteMobEntity().getPower(new ShieldWall());
            if (elitePower == null) {
                return;
            }
            ShieldWall shieldWall = (ShieldWall)elitePower;
            if (!shieldWall.isActive()) {
                if (!ShieldWall.eventIsValid(event, elitePower)) {
                    return;
                }
                shieldWall.initialize(event.getEliteMobEntity());
            } else if (shieldWall.preventDamage(event.getPlayer(), event.getEliteMobEntity(), event.getDamage())) {
                event.setCancelled(true);
            }
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onCombatLeaveEvent(EliteMobExitCombatEvent event) {
            ElitePower elitePower = event.getEliteMobEntity().getPower(new ShieldWall());
            if (elitePower == null) {
                return;
            }
            ShieldWall shieldWall = (ShieldWall)elitePower;
            if (shieldWall.isActive) {
                shieldWall.setActive(false);
            }
        }
    }
}

