/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.MinorPower;
import com.magmaguy.elitemobs.utils.NonSolidBlockTypes;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GroundPound
extends MinorPower
implements Listener {
    public GroundPound() {
        super(PowersConfig.getPower("ground_pound.yml"));
    }

    private static void cloudParticle(Location location) {
        location.getWorld().spawnParticle(Particle.CLOUD, location, 10, 0.01, 0.01, 0.01, 0.7);
    }

    private static void landCloudParticle(Location location) {
        location.getWorld().spawnParticle(Particle.CLOUD, location, 20, 0.1, 0.01, 0.1, 0.7);
    }

    @EventHandler
    public void onEliteDamaged(EliteMobDamagedByPlayerEvent event) {
        GroundPound groundPound = (GroundPound)event.getEliteMobEntity().getPower(this);
        if (groundPound == null) {
            return;
        }
        if (groundPound.isInGlobalCooldown()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.1) {
            return;
        }
        groundPound.doGlobalCooldown(200);
        this.doGroundPound(event.getEliteMobEntity());
    }

    public void doGroundPound(final EliteEntity eliteEntity) {
        new BukkitRunnable(this){

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                eliteEntity.getLivingEntity().setVelocity(new Vector(0.0, 1.5, 0.0));
                GroundPound.cloudParticle(eliteEntity.getLivingEntity().getLocation());
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 1L);
        new BukkitRunnable(this){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                if (!NonSolidBlockTypes.isPassthrough(eliteEntity.getLivingEntity().getLocation().clone().subtract(new Vector(0.0, 0.2, 0.0)).getBlock().getType())) {
                    eliteEntity.getLivingEntity().setVelocity(new Vector(0, -2, 0));
                    GroundPound.cloudParticle(eliteEntity.getLivingEntity().getLocation());
                    new BukkitRunnable(){
                        int counter = 0;

                        public void run() {
                            if (this.counter > 100 || !eliteEntity.isValid()) {
                                this.cancel();
                                return;
                            }
                            ++this.counter;
                            if (!eliteEntity.getLivingEntity().isOnGround()) {
                                return;
                            }
                            this.cancel();
                            GroundPound.landCloudParticle(eliteEntity.getLivingEntity().getLocation());
                            for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(10.0, 10.0, 10.0)) {
                                try {
                                    entity.setVelocity(entity.getLocation().clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().normalize().multiply(2).setY(1.5));
                                }
                                catch (Exception ex) {
                                    entity.setVelocity(new Vector(0.0, 1.5, 0.0));
                                }
                                if (!(entity instanceof LivingEntity)) continue;
                                ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 60, 2));
                            }
                        }
                    }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
                    this.cancel();
                    return;
                }
                if (this.counter > 100) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 20L, 1L);
    }
}

