/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.events.BossCustomAttackDamage;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Firestorm
extends BossPower
implements Listener {
    public Firestorm() {
        super(PowersConfig.getPower("firestorm.yml"));
    }

    private static void doFirestorm(final EliteEntity eliteEntity) {
        if (eliteEntity == null || !eliteEntity.isValid()) {
            return;
        }
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 200 || !eliteEntity.isValid()) {
                    if (eliteEntity.isValid()) {
                        eliteEntity.getLivingEntity().setAI(true);
                    }
                    this.cancel();
                    return;
                }
                if (this.counter % 5 == 0) {
                    Location randomLocation = eliteEntity.getLivingEntity().getLocation().add(new Vector(ThreadLocalRandom.current().nextInt(-20, 20), 0, ThreadLocalRandom.current().nextInt(-20, 20)));
                    Firestorm.doFlamePyrePhase1(randomLocation, eliteEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void doFlamePyrePhase1(final Location location, final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                Firestorm.spawnPhase1Particle(location, Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                Firestorm.doFlamePyrePhase2(location, eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void spawnPhase1Particle(Location location, Particle particle) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().spawnParticle(particle, new Location(location.getWorld(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5 + location.getX(), location.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 0.5 + location.getZ()), 0, 0.0, 1.0, 0.0, ThreadLocalRandom.current().nextDouble() * 2.0);
        }
    }

    private static void doFlamePyrePhase2(final Location location, final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                Firestorm.spawnPhase1Particle(location, Particle.FLAME);
                Firestorm.doDamage(location, eliteEntity, 0.5, 50.0, 0.5);
                Firestorm.spawnPhase2Particle(location, Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                Firestorm.doFlamePyrePhase3(location, eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void spawnPhase2Particle(Location location, Particle particle) {
        for (int i = 0; i < 10; ++i) {
            location.getWorld().spawnParticle(particle, new Location(location.getWorld(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 3.0 + location.getX(), location.getY(), (ThreadLocalRandom.current().nextDouble() - 0.5) * 3.0 + location.getZ()), 0, 0.0, 1.0, 0.0, ThreadLocalRandom.current().nextDouble() * 2.0);
        }
    }

    private static void doDamage(Location location, EliteEntity eliteEntity, double range1, double range2, double range3) {
        for (Entity entity : location.getWorld().getNearbyEntities(location, range1, range2, range3)) {
            if (!(entity instanceof LivingEntity)) continue;
            BossCustomAttackDamage.dealCustomDamage(eliteEntity.getLivingEntity(), (LivingEntity)entity, 1.0);
        }
    }

    private static void doFlamePyrePhase3(final Location location, final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                Firestorm.spawnPhase2Particle(location, Particle.FLAME);
                Firestorm.doDamage(location, eliteEntity, 3.0, 50.0, 3.0);
                Firestorm.spawnPhase3Particle(location, Particle.SMOKE);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
                Firestorm.doFlamePyrePhase4(location, eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void spawnPhase3Particle(Location location, Particle particle) {
        location.getWorld().spawnParticle(particle, location, 50, 0.01, 0.01, 0.01, 0.1);
    }

    private static void doFlamePyrePhase4(final Location location, final EliteEntity eliteEntity) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                Firestorm.spawnPhase3Particle(location, Particle.FLAME);
                Firestorm.doDamage(location, eliteEntity, 5.0, 50.0, 5.0);
                if (this.counter < 40) {
                    return;
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        Firestorm firestorm = (Firestorm)event.getEliteMobEntity().getPower(this);
        if (firestorm == null) {
            return;
        }
        if (!Firestorm.eventIsValid(event, (ElitePower)firestorm)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        firestorm.doGlobalCooldown(400, event.getEliteMobEntity());
        Firestorm.doFirestorm(event.getEliteMobEntity());
    }
}

