/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.magmaguy.elitemobs.commands.DungeonCommands;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.dungeons.CombatContent;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.playerdata.statusscreen.CoverPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.PlayerStatusScreen;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class TeleportsPage {
    protected static TextComponent[] teleportsPage() {
        TextComponent configTextComponent = new TextComponent();
        int textLineCounter = 0;
        for (String string : PlayerStatusMenuConfig.getTeleportTextLines()) {
            if (string == null || string.equals("null")) continue;
            TextComponent line = new TextComponent(string + "\n");
            if (PlayerStatusMenuConfig.getTeleportHoverLines()[textLineCounter] != null && !PlayerStatusMenuConfig.getTeleportHoverLines()[textLineCounter].isEmpty()) {
                PlayerStatusScreen.setHoverText(line, PlayerStatusMenuConfig.getTeleportHoverLines()[textLineCounter]);
            }
            if (PlayerStatusMenuConfig.getTeleportCommandLines()[textLineCounter] != null && !PlayerStatusMenuConfig.getTeleportCommandLines()[textLineCounter].isEmpty()) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, PlayerStatusMenuConfig.getTeleportCommandLines()[textLineCounter]));
            }
            configTextComponent.addExtra((BaseComponent)line);
            ++textLineCounter;
        }
        int counter = 0;
        ArrayList<TextComponent> textComponents = new ArrayList<TextComponent>();
        for (EMPackage emPackage : EMPackage.getEmPackages().values()) {
            if (!emPackage.isInstalled() || !(emPackage instanceof CombatContent) || emPackage.getContentPackagesConfigFields().isEnchantmentChallenge() || !emPackage.getContentPackagesConfigFields().isListedInTeleports()) continue;
            TextComponent message = new TextComponent(PlayerStatusScreen.convertLightColorsToBlack(emPackage.getContentPackagesConfigFields().getName() + "\n"));
            String hoverMessage = ChatColorConverter.convert((String)(PlayerStatusMenuConfig.getOnTeleportHover() + "\n" + emPackage.getContentPackagesConfigFields().getPlayerInfo().replace("$bossCount", "" + emPackage.getCustomBossEntityList().size()).replace("$lowestTier", "" + ((CombatContent)((Object)emPackage)).getLowestLevel()).replace("$highestTier", "" + ((CombatContent)((Object)emPackage)).getHighestLevel())));
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverMessage).create()));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/elitemobs dungeontp " + emPackage.getContentPackagesConfigFields().getFilename()));
            textComponents.add(message);
            ++counter;
        }
        if (counter == 0) {
            TextComponent[] textComponent = new TextComponent[]{configTextComponent};
            return textComponent;
        }
        double elementsPerPage = 5.0;
        TextComponent[] textComponent = new TextComponent[(int)Math.floor((double)counter + 2.0 / elementsPerPage) + 1];
        int internalCounter = 2;
        textComponent[0] = configTextComponent;
        for (TextComponent text : textComponents) {
            int currentPage = (int)Math.floor((double)internalCounter / elementsPerPage);
            if (textComponent[currentPage] == null) {
                textComponent[currentPage] = new TextComponent();
            }
            textComponent[currentPage].addExtra((BaseComponent)text);
            ++internalCounter;
        }
        return textComponent;
    }

    protected static void teleportsPage(Player targetPlayer, Player requestingPlayer) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)requestingPlayer, (int)54, (String)PlayerStatusMenuConfig.getTeleportChestMenuName());
        int counter = 0;
        TeleportsPageEvents.orderedDungeons.clear();
        for (EMPackage emPackage : EMPackage.getEmPackages().values()) {
            if (!emPackage.isInstalled() || !(emPackage instanceof CombatContent) || emPackage.getContentPackagesConfigFields().isEnchantmentChallenge() || !emPackage.getContentPackagesConfigFields().isListedInTeleports()) continue;
            TeleportsPageEvents.orderedDungeons.add(emPackage);
            inventory.setItem(counter, ItemStackGenerator.generateItemStack((Material)Material.PAPER, (String)emPackage.getContentPackagesConfigFields().getName(), Collections.singletonList(emPackage.getContentPackagesConfigFields().getPlayerInfo().replace("$bossCount", "" + emPackage.getCustomBossEntityList().size()).replace("$lowestTier", "" + ((CombatContent)((Object)emPackage)).getLowestLevel()).replace("$highestTier", "" + ((CombatContent)((Object)emPackage)).getHighestLevel()))));
            ++counter;
        }
        inventory.setItem(53, PlayerStatusMenuConfig.getBackItem());
        requestingPlayer.openInventory(inventory);
        TeleportsPageEvents.pageInventories.add(inventory);
    }

    public static class TeleportsPageEvents
    implements Listener {
        private static final Set<Inventory> pageInventories = new HashSet<Inventory>();
        private static final List<EMPackage> orderedDungeons = new ArrayList<EMPackage>();

        public static void shutdown() {
            pageInventories.clear();
            orderedDungeons.clear();
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            if (!pageInventories.contains(event.getInventory())) {
                return;
            }
            event.setCancelled(true);
            if (event.getSlot() < 0) {
                return;
            }
            if (orderedDungeons.size() - 1 >= event.getSlot()) {
                player.closeInventory();
                DungeonCommands.teleport(player, orderedDungeons.get(event.getSlot()).getContentPackagesConfigFields().getFilename());
                return;
            }
            if (event.getSlot() == 53) {
                player.closeInventory();
                CoverPage.coverPage(player);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            pageInventories.remove(event.getInventory());
        }
    }
}

