/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.statusscreen;

import com.magmaguy.elitemobs.commands.guild.AdventurersGuildCommand;
import com.magmaguy.elitemobs.config.SkillsConfig;
import com.magmaguy.elitemobs.config.menus.premade.PlayerStatusMenuConfig;
import com.magmaguy.elitemobs.playerdata.statusscreen.BossTrackingPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.CommandsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.GearPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.PlayerStatusScreen;
import com.magmaguy.elitemobs.playerdata.statusscreen.QuestsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.SkillsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.StatsPage;
import com.magmaguy.elitemobs.playerdata.statusscreen.TeleportsPage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CoverPage {
    private static final int SKILLS_SLOT = 22;

    protected static TextComponent coverPage(int statsPage, int gearPage, int teleportsPage, int commandsPage, int questsPage, int bossTrackingPage) {
        TextComponent textComponent = new TextComponent();
        for (int i = 0; i < 13; ++i) {
            if (PlayerStatusMenuConfig.getIndexTextLines()[i] == null) continue;
            TextComponent line = new TextComponent(PlayerStatusMenuConfig.getIndexTextLines()[i].replace("$statsPage", "" + statsPage).replace("$gearPage", "" + gearPage).replace("$teleportsPage", "" + teleportsPage).replace("$commandsPage", "" + commandsPage).replace("$questsPage", "" + questsPage).replace("$bossTrackingPage", "" + bossTrackingPage) + "\n");
            if (PlayerStatusMenuConfig.getIndexHoverLines()[i] == null) continue;
            if (!PlayerStatusMenuConfig.getIndexHoverLines()[i].isEmpty()) {
                PlayerStatusScreen.setHoverText(line, PlayerStatusMenuConfig.getIndexHoverLines()[i]);
            }
            if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$statsPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$statsPage", "" + statsPage)));
            } else if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$gearPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$gearPage", "" + gearPage)));
            } else if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$teleportsPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$teleportsPage", "" + teleportsPage)));
            } else if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$commandsPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$commandsPage", "" + commandsPage)));
            } else if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$questsPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$questsPage", "" + questsPage)));
            } else if (PlayerStatusMenuConfig.getIndexCommandLines()[i].contains("$bossTrackingPage")) {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, PlayerStatusMenuConfig.getIndexCommandLines()[i].replace("$bossTrackingPage", "" + bossTrackingPage)));
            } else {
                line.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, PlayerStatusMenuConfig.getIndexCommandLines()[i]));
            }
            textComponent.addExtra((BaseComponent)line);
        }
        return textComponent;
    }

    protected static void coverPage(Player requestingPlayer) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)requestingPlayer, (int)27, (String)PlayerStatusMenuConfig.getIndexChestMenuName());
        inventory.setItem(PlayerStatusMenuConfig.getIndexHeaderSlot(), PlayerStatusMenuConfig.getIndexHeaderItem());
        if (PlayerStatusMenuConfig.isDoStatsPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexStatsSlot(), PlayerStatusMenuConfig.getIndexStatsItem());
        }
        if (PlayerStatusMenuConfig.isDoGearPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexGearSlot(), PlayerStatusMenuConfig.getIndexGearItem());
        }
        if (PlayerStatusMenuConfig.isDoTeleportsPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexTeleportsSlot(), PlayerStatusMenuConfig.getIndexTeleportsItem());
        }
        if (PlayerStatusMenuConfig.isDoCommandsPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexCommandsSlot(), PlayerStatusMenuConfig.getIndexCommandsItem());
        }
        if (PlayerStatusMenuConfig.isDoQuestTrackingPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexQuestTrackingSlot(), PlayerStatusMenuConfig.getIndexQuestTrackingItem());
        }
        if (PlayerStatusMenuConfig.isDoBossTrackingPage()) {
            inventory.setItem(PlayerStatusMenuConfig.getIndexBossTrackingSlot(), PlayerStatusMenuConfig.getIndexBossTrackingItem());
        }
        if (SkillsConfig.isSkillSystemEnabled()) {
            inventory.setItem(22, CoverPage.createSkillsItem());
        }
        CoverPageEvents.pageInventories.add(inventory);
        requestingPlayer.openInventory(inventory);
    }

    private static ItemStack createSkillsItem() {
        ItemStack item = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a75\u00a7lSkills");
        meta.setLore(List.of("\u00a77View your skill levels", "\u00a77and XP progress.", "", "\u00a7eClick to view!"));
        item.setItemMeta(meta);
        return item;
    }

    public static class CoverPageEvents
    implements Listener {
        private static final Set<Inventory> pageInventories = new HashSet<Inventory>();

        public static void shutdown() {
            pageInventories.clear();
        }

        @EventHandler
        public void onInventoryInteract(InventoryClickEvent event) {
            Player player = ((Player)event.getWhoClicked()).getPlayer();
            if (!pageInventories.contains(event.getInventory())) {
                return;
            }
            event.setCancelled(true);
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexHeaderSlot()) {
                player.closeInventory();
                AdventurersGuildCommand.adventurersGuildCommand(player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexGearSlot() && PlayerStatusMenuConfig.isDoGearPage()) {
                player.closeInventory();
                GearPage.gearPage(player, player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexStatsSlot() && PlayerStatusMenuConfig.isDoStatsPage()) {
                player.closeInventory();
                StatsPage.statsPage(player, player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexCommandsSlot() && PlayerStatusMenuConfig.isDoCommandsPage()) {
                player.closeInventory();
                CommandsPage.commandsPage(player, player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexTeleportsSlot() && PlayerStatusMenuConfig.isDoTeleportsPage()) {
                player.closeInventory();
                TeleportsPage.teleportsPage(player, player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexQuestTrackingSlot() && PlayerStatusMenuConfig.isDoQuestTrackingPage()) {
                player.closeInventory();
                QuestsPage.questsPage(player, player);
                return;
            }
            if (event.getSlot() == PlayerStatusMenuConfig.getIndexBossTrackingSlot() && PlayerStatusMenuConfig.isDoBossTrackingPage()) {
                player.closeInventory();
                BossTrackingPage.bossTrackingPage(player, player);
                return;
            }
            if (event.getSlot() == 22 && SkillsConfig.isSkillSystemEnabled()) {
                player.closeInventory();
                SkillsPage.skillsPage(player, player);
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            pageInventories.remove(event.getInventory());
        }
    }
}

