/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.database;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.Logger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;

public class GenerateDatabase {
    private GenerateDatabase() {
    }

    public static void generate() throws Exception {
        Statement statement = PlayerData.getConnection().createStatement();
        String sql = "CREATE TABLE IF NOT EXISTS " + PlayerData.getPLAYER_DATA_TABLE_NAME() + " (PlayerUUID VARCHAR(36) PRIMARY KEY NOT NULL, DisplayName TEXT, Currency DOUBLE, QuestStatus BLOB, Score INT, Kills INT, HighestLevelKilled INT, Deaths INT, QuestsCompleted INT, PlayerQuestCooldowns BLOB, BackTeleportLocation TEXT, UseBookMenus TINYINT(1), DismissEMStatusScreenMessage TINYINT(1), DungeonBossLockouts BLOB, SkillXP_ARMOR BIGINT, SkillXP_SWORDS BIGINT, SkillXP_AXES BIGINT, SkillXP_BOWS BIGINT, SkillXP_CROSSBOWS BIGINT, SkillXP_TRIDENTS BIGINT, SkillXP_HOES BIGINT, SkillBonusSelections BLOB);";
        statement.executeUpdate(sql);
        statement.close();
        GenerateDatabase.addEntryIfEmpty("DisplayName", ColumnValues.TEXT);
        GenerateDatabase.addEntryIfEmpty("Currency", ColumnValues.REAL);
        GenerateDatabase.addEntryIfEmpty("QuestStatus", ColumnValues.BLOB);
        GenerateDatabase.addEntryIfEmpty("Score", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("Kills", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("HighestLevelKilled", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("Deaths", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("QuestsCompleted", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("PlayerQuestCooldowns", ColumnValues.BLOB);
        GenerateDatabase.addEntryIfEmpty("BackTeleportLocation", ColumnValues.TEXT);
        GenerateDatabase.addEntryIfEmpty("UseBookMenus", ColumnValues.BOOLEAN);
        GenerateDatabase.addEntryIfEmpty("DismissEMStatusScreenMessage", ColumnValues.BOOLEAN);
        GenerateDatabase.addEntryIfEmpty("DungeonBossLockouts", ColumnValues.BLOB);
        GenerateDatabase.addEntryIfEmpty("SkillXP_ARMOR", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_SWORDS", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_AXES", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_BOWS", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_CROSSBOWS", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_TRIDENTS", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillXP_HOES", ColumnValues.BIGINT);
        GenerateDatabase.addEntryIfEmpty("SkillBonusSelections", ColumnValues.BLOB);
    }

    private static void addEntryIfEmpty(String columnName, ColumnValues columnValues) {
        try {
            DatabaseMetaData metaData = PlayerData.getConnection().getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, PlayerData.getPLAYER_DATA_TABLE_NAME(), columnName);
            if (!resultSet.next()) {
                Logger.info((String)("Adding new database column " + columnName));
                GenerateDatabase.addColumn(columnName, columnValues);
            }
            resultSet.close();
        }
        catch (Exception ex) {
            Logger.warn((String)("Could not process column " + columnName));
            ex.printStackTrace();
        }
    }

    private static void addColumn(String columnName, ColumnValues type) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            String sql = "ALTER TABLE " + PlayerData.getPLAYER_DATA_TABLE_NAME() + " ADD " + columnName + " " + type.toString();
            statement.executeUpdate(sql);
            statement.close();
        }
        catch (Exception ex) {
            Logger.warn((String)("Failed to insert new column " + columnName));
            ex.printStackTrace();
        }
    }

    private static enum ColumnValues {
        BLOB,
        INT,
        BIGINT,
        TEXT,
        REAL,
        BOOLEAN;

    }
}

