/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.pathfinding;

import com.magmaguy.easyminecraftgoals.NMSManager;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointEndEvent;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointStartEvent;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.RegionalBossEntity;
import com.magmaguy.magmacore.util.AttributeManager;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Navigation
implements Listener {
    private static final HashMap<CustomBossEntity, BukkitTask> currentlyNavigating = new HashMap();

    public static void stopMoving(LivingEntity livingEntity) {
        NMSManager.getAdapter().doNotMove(livingEntity);
    }

    public static void addSoftLeashAI(RegionalBossEntity regionalBossEntity) {
        if (NMSManager.getAdapter() == null) {
            return;
        }
        if (regionalBossEntity.getUnsyncedLivingEntity() != null && regionalBossEntity.getUnsyncedLivingEntity().getType() == EntityType.ENDER_DRAGON) {
            return;
        }
        if (regionalBossEntity.getLivingEntity() instanceof Creature) {
            NMSManager.getAdapter().wanderBackToPoint(regionalBossEntity.getLivingEntity(), regionalBossEntity.getSpawnLocation(), regionalBossEntity.getLeashRadius() / 2.0, 100).setSpeed(1.2f).setStopReturnDistance(1).setGoalRefreshCooldownTicks(60).setHardObjective(false).setTeleportOnFail(true).setStartWithCooldown(true).register();
        }
    }

    public static void addHardLeashAI(RegionalBossEntity regionalBossEntity) {
        if (NMSManager.getAdapter() == null) {
            return;
        }
        if (regionalBossEntity.getUnsyncedLivingEntity() != null && regionalBossEntity.getUnsyncedLivingEntity().getType() == EntityType.ENDER_DRAGON) {
            return;
        }
        NMSManager.getAdapter().wanderBackToPoint(regionalBossEntity.getLivingEntity(), regionalBossEntity.getSpawnLocation(), regionalBossEntity.getLeashRadius(), 100).setSpeed(2.0f).setStopReturnDistance(0).setGoalRefreshCooldownTicks(60).setHardObjective(true).setTeleportOnFail(true).setStartWithCooldown(true).register();
    }

    public static void shutdown() {
        currentlyNavigating.values().forEach(BukkitTask::cancel);
        currentlyNavigating.clear();
    }

    public static void navigateTo(final CustomBossEntity customBossEntity, Double speed, final Location destination, final boolean force, int duration) {
        if (duration == 0) {
            duration = 100;
        }
        if (customBossEntity.getLivingEntity() == null) {
            return;
        }
        if (destination == null || destination.getWorld() == null) {
            return;
        }
        if (speed == null) {
            speed = AttributeManager.getAttributeBaseValue((LivingEntity)customBossEntity.getLivingEntity(), (String)"generic_movement_speed");
        }
        final Double finalSpeed = speed;
        if (currentlyNavigating.get(customBossEntity) != null) {
            currentlyNavigating.get(customBossEntity).cancel();
        }
        final int finalDuration = duration;
        currentlyNavigating.put(customBossEntity, new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (this.counter >= finalDuration || !customBossEntity.exists() || customBossEntity.getLivingEntity() == null || !customBossEntity.getLivingEntity().getWorld().equals((Object)destination.getWorld()) || customBossEntity.getLivingEntity() != null && customBossEntity.getLivingEntity().getLocation().distanceSquared(destination) < Math.pow(1.0, 2.0)) {
                    if (customBossEntity.exists() && this.counter >= finalDuration && force) {
                        customBossEntity.getLivingEntity().teleport(destination);
                    }
                    this.cancel();
                    currentlyNavigating.remove(customBossEntity);
                    return;
                }
                NMSManager.getAdapter().move(customBossEntity.getLivingEntity(), (double)finalSpeed.floatValue(), destination);
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L));
    }

    @EventHandler(ignoreCancelled=true)
    public void makeReturningBossesInvulnerable(WanderBackToPointStartEvent event) {
        if (!event.isHardObjective()) {
            return;
        }
        if (event.getLivingEntity() == null) {
            return;
        }
        if (event.getLivingEntity().getType() == EntityType.ENDER_DRAGON) {
            return;
        }
        EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)event.getLivingEntity());
        if (!(eliteEntity instanceof RegionalBossEntity)) {
            return;
        }
        RegionalBossEntity regionalBossEntity = (RegionalBossEntity)eliteEntity;
        event.getLivingEntity().setInvulnerable(true);
        AttributeManager.setAttribute((LivingEntity)event.getLivingEntity(), (String)"generic_follow_range", (double)(regionalBossEntity.getCustomBossesConfigFields().getLeashRadius() * 1.5));
    }

    @EventHandler(ignoreCancelled=true)
    public void makeReturnedBossesVulnerable(WanderBackToPointEndEvent event) {
        if (!event.isHardObjective()) {
            return;
        }
        if (event.getLivingEntity() == null) {
            return;
        }
        if (event.getLivingEntity().getType() == EntityType.ENDER_DRAGON) {
            return;
        }
        EliteEntity eliteEntity = EntityTracker.getEliteMobEntity((Entity)event.getLivingEntity());
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null) {
            return;
        }
        if (!(eliteEntity instanceof RegionalBossEntity)) {
            return;
        }
        RegionalBossEntity regionalBossEntity = (RegionalBossEntity)eliteEntity;
        event.getLivingEntity().setInvulnerable(false);
        if (regionalBossEntity.getCustomBossesConfigFields().getFollowDistance() != 0) {
            AttributeManager.setAttribute((LivingEntity)event.getLivingEntity(), (String)"generic_follow_range", (double)regionalBossEntity.getCustomBossesConfigFields().getFollowDistance().intValue());
        } else {
            AttributeManager.setAttribute((LivingEntity)event.getLivingEntity(), (String)"generic_follow_range", (double)AttributeManager.getAttributeDefaultValue((LivingEntity)regionalBossEntity.getLivingEntity(), (String)"generic_follow_range"));
        }
        regionalBossEntity.fullHeal();
    }
}

