/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.npcs.chatter;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.utils.VisualDisplay;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class NPCChatBubble {
    public NPCChatBubble(String message, final NPCEntity npcEntity, Player player) {
        if (!npcEntity.getNPCsConfigFields().isCanTalk()) {
            return;
        }
        if (message == null) {
            return;
        }
        if (npcEntity.getVillager().hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return;
        }
        if (npcEntity.getIsTalking()) {
            return;
        }
        npcEntity.startTalkingCooldown();
        int lineCounter = 0;
        for (String substring : message.split("\\\\n")) {
            Location newLocation = npcEntity.getVillager().getEyeLocation().clone().add(player.getLocation().clone().subtract(npcEntity.getVillager().getLocation()).toVector().normalize().multiply(0.5)).add(new Vector(0.0, -0.4 - 0.2 * (double)lineCounter, 0.0));
            final TextDisplay visualArmorStand = VisualDisplay.generateTemporaryTextDisplay(newLocation, substring);
            new BukkitRunnable(this){
                int counter = 0;

                public void run() {
                    if (this.counter > 100 || npcEntity.getVillager() == null || !npcEntity.getVillager().isValid() || !visualArmorStand.isValid()) {
                        visualArmorStand.remove();
                        this.cancel();
                        return;
                    }
                    visualArmorStand.teleport(visualArmorStand.getLocation().clone().add(new Vector(0.0, 0.005, 0.0)));
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
            ++lineCounter;
        }
    }

    public NPCChatBubble(List<String> message, NPCEntity npcEntity, Player player) {
        String selectedMessage = message.get(ThreadLocalRandom.current().nextInt(message.size()));
        new NPCChatBubble(selectedMessage, npcEntity, player);
    }
}

