/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobspawning;

import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.config.ValidWorldsConfig;
import com.magmaguy.elitemobs.config.mobproperties.MobPropertiesConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customenchantments.HunterEnchantment;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.elitemobs.mobspawning.SpawnRadiusDifficultyIncrementer;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardCompatibility;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardFlagChecker;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardSpawnEventBypasser;
import com.magmaguy.elitemobs.utils.PlayerScanner;
import com.magmaguy.magmacore.util.AttributeManager;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class NaturalMobSpawnEventHandler
implements Listener {
    public static int getNaturalMobLevel(Location spawnLocation, List<Player> nearbyPlayers) {
        int eliteMobLevel = 1;
        int playerCount = 0;
        for (Player player : nearbyPlayers) {
            int individualPlayerThreat = ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getNaturalMobSpawnLevel(true);
            ++playerCount;
            if (individualPlayerThreat <= eliteMobLevel) continue;
            eliteMobLevel = individualPlayerThreat;
        }
        eliteMobLevel = (int)((double)eliteMobLevel + (double)(playerCount * 2) * 1.0);
        if (MobCombatSettingsConfig.isIncreaseDifficultyWithSpawnDistance()) {
            int levelIncrement = SpawnRadiusDifficultyIncrementer.distanceFromSpawnLevelIncrease(spawnLocation);
            eliteMobLevel += levelIncrement;
        }
        if (playerCount == 0 || eliteMobLevel < 1) {
            return 0;
        }
        int wiggle = ThreadLocalRandom.current().nextInt(5) - 2;
        eliteMobLevel = Math.max(wiggle + eliteMobLevel, 1);
        return eliteMobLevel;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.DROWNED) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BREEDING)) {
            return;
        }
        if (event.getEntity().getType().equals((Object)EntityType.BEE)) {
            return;
        }
        if (event.getEntity().getType().equals((Object)EntityType.VEX)) {
            return;
        }
        if (MobPropertiesConfig.getMobProperties().get(event.getEntityType()) == null || !MobPropertiesConfig.getMobProperties().get(event.getEntityType()).isEnabled()) {
            return;
        }
        if (EliteMobs.worldGuardIsEnabled && !WorldGuardFlagChecker.checkFlag(event.getLocation(), WorldGuardCompatibility.getELITEMOBS_SPAWN_FLAG()).booleanValue()) {
            return;
        }
        if (WorldGuardSpawnEventBypasser.isForcedSpawn()) {
            return;
        }
        if (EntityTracker.isEliteMob((Entity)event.getEntity())) {
            return;
        }
        if (!MobCombatSettingsConfig.isDoNaturalMobSpawning()) {
            return;
        }
        if (!ValidWorldsConfig.getInstance().getFileConfiguration().getBoolean("Valid worlds." + event.getEntity().getWorld().getName())) {
            return;
        }
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER) && !MobCombatSettingsConfig.isDoSpawnersSpawnEliteMobs() || event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.NATURAL && DefaultConfig.isDoStrictSpawningRules()) {
            return;
        }
        if (event.getEntity().getCustomName() != null && DefaultConfig.isPreventEliteMobConversionOfNamedMobs()) {
            return;
        }
        if (!EliteMobProperties.isValidEliteMobType(event.getEntityType())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        double validChance = MobCombatSettingsConfig.getAggressiveMobConversionPercentage();
        List<Player> nearbyPlayers = PlayerScanner.getNearbyPlayers(livingEntity.getLocation());
        double huntingGearChanceAdder = HunterEnchantment.getHuntingGearBonus(nearbyPlayers);
        validChance += huntingGearChanceAdder;
        if (ThreadLocalRandom.current().nextDouble() >= validChance) {
            return;
        }
        int eliteMobLevel = NaturalMobSpawnEventHandler.getNaturalMobLevel(livingEntity.getLocation(), nearbyPlayers);
        if (EliteMobs.worldGuardIsEnabled) {
            Integer minLevel = WorldGuardFlagChecker.getRegionMinimumLevel(livingEntity.getLocation());
            Integer maxLevel = WorldGuardFlagChecker.getRegionMaximumLevel(livingEntity.getLocation());
            if (minLevel != null) {
                int n = eliteMobLevel = minLevel > eliteMobLevel ? minLevel : eliteMobLevel;
            }
            if (maxLevel != null) {
                int n = eliteMobLevel = maxLevel < eliteMobLevel ? maxLevel : eliteMobLevel;
            }
        }
        if (eliteMobLevel < 0) {
            return;
        }
        if (eliteMobLevel > MobCombatSettingsConfig.getNaturalEliteMobLevelCap()) {
            eliteMobLevel = MobCombatSettingsConfig.getNaturalEliteMobLevelCap();
        }
        EliteEntity eliteEntity = new EliteEntity(livingEntity, eliteMobLevel, event.getSpawnReason());
        if (DefaultConfig.isUseRandomizedScalingForElites()) {
            AttributeManager.setAttribute((LivingEntity)livingEntity, (String)"generic_scale", (double)ThreadLocalRandom.current().nextDouble(0.8, 1.2));
        }
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            eliteEntity.setEliteLoot(false);
        }
    }
}

