/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.UnbinderMenuConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.items.customenchantments.UnbindEnchantment;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.versionnotifier.VersionChecker;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class UnbindMenu
extends EliteMenu {
    private static final int eliteItemInputSlot = UnbinderMenuConfig.getEliteItemInputSlot();
    private static final int unbindScrollItemInputSlot = UnbinderMenuConfig.getEliteUnbindInputSlot();
    private static final int outputSlot = UnbinderMenuConfig.getOutputSlot();
    private static final int eliteItemInformationInputSlot = UnbinderMenuConfig.getEliteItemInputInformationSlot();
    private static final int unbindScrollInformationInputSlot = UnbinderMenuConfig.getEliteScrapInputInformationSlot();
    private static final int informationOutputSlot = UnbinderMenuConfig.getOutputInformationSlot();
    public static Set<Inventory> inventories = new HashSet<Inventory>();

    public static void shutdown() {
        inventories.clear();
    }

    private static void calculateOutput(Inventory UnbinderInventory) {
        if (UnbinderInventory.getItem(UnbinderMenuConfig.getEliteUnbindInputSlot()) == null || UnbinderInventory.getItem(UnbinderMenuConfig.getEliteItemInputSlot()) == null) {
            UnbinderInventory.setItem(UnbinderMenuConfig.getOutputSlot(), null);
            return;
        }
        ItemStack outputItem = UnbinderInventory.getItem(UnbinderMenuConfig.getEliteItemInputSlot()).clone();
        UnbinderInventory.setItem(outputSlot, UnbindEnchantment.unbindItem(outputItem));
    }

    public void constructUnbinderMenu(Player player) {
        Object menuName = UnbinderMenuConfig.getShopName();
        if (DefaultConfig.useResourcePackModels()) {
            menuName = String.valueOf(ChatColor.WHITE) + "\uf801\udb80\udc9b\uf805          " + (String)menuName;
        }
        Inventory UnbinderInventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        for (int i = 0; i < UnbinderInventory.getSize(); ++i) {
            if (i == UnbinderMenuConfig.getInfoSlot()) {
                ItemStack infoButton = UnbinderMenuConfig.getInfoButton();
                if (DefaultConfig.useResourcePackModels()) {
                    infoButton.setType(Material.PAPER);
                    ItemMeta itemMeta = infoButton.getItemMeta();
                    if (!VersionChecker.serverVersionOlderThan(21, 4)) {
                        itemMeta.setItemModel(NamespacedKey.fromString((String)"elitemobs:ui/goldenquestionmark"));
                    }
                    infoButton.setItemMeta(itemMeta);
                }
                UnbinderInventory.setItem(i, infoButton);
                continue;
            }
            if (i == UnbinderMenuConfig.getCancelSlot()) {
                UnbinderInventory.setItem(i, UnbinderMenuConfig.getCancelButton());
                continue;
            }
            if (i == eliteItemInformationInputSlot) {
                UnbinderInventory.setItem(i, UnbinderMenuConfig.getEliteItemInputInfoButton());
                continue;
            }
            if (i == unbindScrollInformationInputSlot) {
                UnbinderInventory.setItem(i, UnbinderMenuConfig.getEliteUnbindInputInfoButton());
                continue;
            }
            if (i == informationOutputSlot) {
                UnbinderInventory.setItem(i, UnbinderMenuConfig.getOutputInfoButton());
                continue;
            }
            if (i == UnbinderMenuConfig.getConfirmSlot()) {
                ItemStack clonedConfirmButton = UnbinderMenuConfig.getConfirmButton().clone();
                ArrayList<String> lore = new ArrayList<String>();
                for (String string : UnbinderMenuConfig.getConfirmButton().getItemMeta().getLore()) {
                    lore.add(string);
                }
                UnbinderMenuConfig.getConfirmButton().getItemMeta().setLore(lore);
                ItemMeta clonedMeta = clonedConfirmButton.getItemMeta();
                clonedMeta.setLore(lore);
                clonedConfirmButton.setItemMeta(clonedMeta);
                UnbinderInventory.setItem(i, clonedConfirmButton);
                continue;
            }
            if (i == UnbinderMenuConfig.getEliteItemInputSlot() || i == UnbinderMenuConfig.getEliteUnbindInputSlot() || i == UnbinderMenuConfig.getOutputSlot() || !DefaultConfig.isUseGlassToFillMenuEmptySpace()) continue;
            UnbinderInventory.setItem(i, ItemStackGenerator.generateItemStack((Material)Material.GLASS_PANE));
        }
        player.openInventory(UnbinderInventory);
        UnbindMenu.createEliteMenu(UnbinderInventory, inventories);
    }

    public static class UnbinderMenuEvents
    implements Listener {
        @EventHandler
        public void onInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, inventories)) {
                return;
            }
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            ItemStack currentItem = event.getCurrentItem();
            int clickedSlot = event.getSlot();
            Inventory unbinderInventory = event.getView().getTopInventory();
            Inventory playerInventory = event.getView().getBottomInventory();
            if (currentItem == null) {
                return;
            }
            if (EliteMenu.isBottomMenu(event)) {
                if (ItemTagger.hasEnchantment(currentItem.getItemMeta(), UnbindEnchantment.key) && SoulbindEnchantment.isValidSoulbindUser(currentItem.getItemMeta(), player)) {
                    if (unbinderInventory.getItem(unbindScrollItemInputSlot) == null) {
                        EliteMenu.moveOneItemUp(unbindScrollItemInputSlot, event);
                        UnbindMenu.calculateOutput(unbinderInventory);
                    }
                    return;
                }
                if (EliteItemManager.isEliteMobsItem(currentItem) && currentItem.getItemMeta() instanceof Damageable && unbinderInventory.getItem(eliteItemInputSlot) == null) {
                    unbinderInventory.setItem(eliteItemInputSlot, currentItem);
                    playerInventory.remove(currentItem);
                    UnbindMenu.calculateOutput(unbinderInventory);
                }
            } else if (EliteMenu.isTopMenu(event)) {
                if (currentItem == null) {
                    return;
                }
                if (event.getSlot() == unbindScrollItemInputSlot || event.getSlot() == eliteItemInputSlot) {
                    EliteMenu.moveItemDown(event.getView().getTopInventory(), clickedSlot, (HumanEntity)player);
                    UnbindMenu.calculateOutput(unbinderInventory);
                    return;
                }
                if (event.getSlot() == UnbinderMenuConfig.getCancelSlot()) {
                    player.closeInventory();
                    return;
                }
                if (event.getSlot() == UnbinderMenuConfig.getConfirmSlot() && unbinderInventory.getItem(outputSlot) != null) {
                    unbinderInventory.setItem(UnbinderMenuConfig.getEliteItemInputSlot(), null);
                    unbinderInventory.setItem(UnbinderMenuConfig.getEliteUnbindInputSlot(), null);
                    if (unbinderInventory.getItem(outputSlot) != null) {
                        HashMap map = player.getInventory().addItem(new ItemStack[]{unbinderInventory.getItem(outputSlot)});
                        if (!map.isEmpty()) {
                            map.forEach((key, itemStack) -> {
                                itemStack.setAmount(key.intValue());
                                player.getWorld().dropItem(player.getLocation(), itemStack);
                            });
                        }
                        unbinderInventory.remove(unbinderInventory.getItem(outputSlot));
                    }
                    unbinderInventory.setItem(outputSlot, null);
                }
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            if (inventories.contains(event.getInventory())) {
                inventories.remove(event.getInventory());
                EliteMenu.cancel(event.getPlayer(), event.getView().getTopInventory(), event.getView().getBottomInventory(), new ArrayList<Integer>(List.of(Integer.valueOf(eliteItemInputSlot), Integer.valueOf(unbindScrollItemInputSlot))));
            }
        }
    }
}

