/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.SkillBonusMenuConfig;
import com.magmaguy.elitemobs.config.skillbonuses.SkillBonusConfigFields;
import com.magmaguy.elitemobs.config.skillbonuses.SkillBonusesConfig;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.elitemobs.skills.bonuses.PlayerSkillSelection;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkillBonusMenu {
    public static void openWeaponSelectMenu(Player player) {
        Object menuName = SkillBonusMenuConfig.getWeaponSelectMenuName();
        if (DefaultConfig.useResourcePackModels()) {
            menuName = "\uf801\udb80\udd0b\uf805          " + (String)menuName;
        }
        menuName = ChatColorConverter.convert((String)menuName);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)menuName);
        inventory.setItem(SkillBonusMenuConfig.getSwordsSlot(), SkillBonusMenuConfig.getSwordsItem());
        inventory.setItem(SkillBonusMenuConfig.getAxesSlot(), SkillBonusMenuConfig.getAxesItem());
        inventory.setItem(SkillBonusMenuConfig.getBowsSlot(), SkillBonusMenuConfig.getBowsItem());
        inventory.setItem(SkillBonusMenuConfig.getCrossbowsSlot(), SkillBonusMenuConfig.getCrossbowsItem());
        inventory.setItem(SkillBonusMenuConfig.getTridentsSlot(), SkillBonusMenuConfig.getTridentsItem());
        inventory.setItem(SkillBonusMenuConfig.getHoesSlot(), SkillBonusMenuConfig.getHoesItem());
        inventory.setItem(SkillBonusMenuConfig.getArmorSlot(), SkillBonusMenuConfig.getArmorItem());
        player.openInventory(inventory);
        SkillBonusMenuEvents.weaponSelectMenus.add(inventory);
    }

    public static void openSkillSelectMenu(Player player, SkillType skillType) {
        Object menuName = SkillBonusMenuConfig.getSkillSelectMenuName().replace("%skill_type%", skillType.getDisplayName());
        if (DefaultConfig.useResourcePackModels()) {
            menuName = "\uf801\udb80\udd0b\uf805          " + (String)menuName;
        }
        menuName = ChatColorConverter.convert((String)menuName);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)menuName);
        long xp = PlayerData.getSkillXP(player.getUniqueId(), skillType);
        int skillLevel = SkillXPCalculator.levelFromTotalXP(xp);
        List<String> activeSkillIds = PlayerSkillSelection.getActiveSkills(player.getUniqueId(), skillType);
        List<SkillBonusConfigFields> skills = SkillBonusesConfig.getEnabledBySkillType(skillType);
        skills.sort(Comparator.comparingInt(SkillBonusConfigFields::getUnlockTier));
        int slot = 0;
        for (SkillBonusConfigFields skillConfig : skills) {
            if (slot >= 45) break;
            ItemStack skillItem = SkillBonusMenu.createSkillItem(skillConfig, skillLevel, activeSkillIds);
            inventory.setItem(slot, skillItem);
            ++slot;
        }
        inventory.setItem(SkillBonusMenuConfig.getBackSlot(), SkillBonusMenuConfig.getBackItem());
        inventory.setItem(SkillBonusMenuConfig.getInfoSlot(), SkillBonusMenu.createInfoItem(player, skillType, skillLevel, activeSkillIds));
        player.openInventory(inventory);
        SkillBonusMenuEvents.skillSelectMenus.put(inventory, new SkillMenuData(skillType, player.getUniqueId()));
    }

    private static ItemStack createSkillItem(SkillBonusConfigFields skillConfig, int playerLevel, List<String> activeSkillIds) {
        String name;
        boolean isActive = activeSkillIds.contains(skillConfig.getSkillId());
        boolean isUnlocked = playerLevel >= skillConfig.getRequiredLevel();
        Material material = skillConfig.getDisplayMaterial();
        ArrayList<Object> lore = new ArrayList<Object>();
        if (isActive) {
            name = SkillBonusMenuConfig.getActivePrefix() + skillConfig.getName();
        } else if (isUnlocked) {
            name = SkillBonusMenuConfig.getUnlockedPrefix() + skillConfig.getName();
        } else {
            name = SkillBonusMenuConfig.getLockedPrefix() + skillConfig.getName();
            material = Material.GRAY_DYE;
        }
        lore.addAll(skillConfig.getDescription());
        lore.add("");
        lore.add("&7Type: &f" + skillConfig.getBonusType().name());
        lore.add("&7Tier: &f" + skillConfig.getUnlockTier() + " (Level " + skillConfig.getRequiredLevel() + ")");
        if (isUnlocked) {
            double value = skillConfig.calculateValue(playerLevel);
            lore.add("&7Value at your level: &a" + String.format("%.1f", value));
        }
        lore.add("");
        if (isActive) {
            lore.add(SkillBonusMenuConfig.getClickToDeactivate());
        } else if (isUnlocked) {
            lore.add(SkillBonusMenuConfig.getClickToActivate());
        } else {
            lore.add(SkillBonusMenuConfig.getLockedLore().replace("%level%", String.valueOf(skillConfig.getRequiredLevel())));
        }
        ItemStack item = ItemStackGenerator.generateItemStack((Material)material, (String)name, lore);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<String> existingLore = meta.getLore();
            if (existingLore == null) {
                existingLore = new ArrayList<String>();
            }
            existingLore.add(ChatColorConverter.convert((String)("&8ID: " + skillConfig.getSkillId())));
            meta.setLore(existingLore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static ItemStack createInfoItem(Player player, SkillType skillType, int skillLevel, List<String> activeSkillIds) {
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("&7Skill Type: &f" + skillType.getDisplayName());
        lore.add("&7Your Level: &f" + skillLevel);
        lore.add("&7Active Skills: &f" + activeSkillIds.size() + "/3");
        lore.add("");
        if (!activeSkillIds.isEmpty()) {
            lore.add("&6Active Skills:");
            for (String skillId : activeSkillIds) {
                SkillBonusConfigFields config = SkillBonusesConfig.getBySkillId(skillId);
                if (config == null) continue;
                lore.add("&7- " + config.getName());
            }
        }
        lore.add("");
        lore.add("&7Skills unlock at levels:");
        lore.add("&a Tier 1: &fLevel 10");
        lore.add("&e Tier 2: &fLevel 25");
        lore.add("&6 Tier 3: &fLevel 50");
        lore.add("&c Tier 4: &fLevel 75");
        return ItemStackGenerator.generateItemStack((Material)Material.BOOK, (String)"&eSkill Info", lore);
    }

    public static class SkillBonusMenuEvents
    implements Listener {
        private static final Set<Inventory> weaponSelectMenus = new HashSet<Inventory>();
        private static final Map<Inventory, SkillMenuData> skillSelectMenus = new HashMap<Inventory, SkillMenuData>();

        public static void shutdown() {
            weaponSelectMenus.clear();
            skillSelectMenus.clear();
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryClick(InventoryClickEvent event) {
            HumanEntity humanEntity = event.getWhoClicked();
            if (!(humanEntity instanceof Player)) {
                return;
            }
            Player player = (Player)humanEntity;
            if (weaponSelectMenus.contains(event.getInventory())) {
                event.setCancelled(true);
                this.handleWeaponSelectClick(player, event);
                return;
            }
            if (skillSelectMenus.containsKey(event.getInventory())) {
                event.setCancelled(true);
                this.handleSkillSelectClick(player, event);
            }
        }

        private void handleWeaponSelectClick(Player player, InventoryClickEvent event) {
            int slot = event.getSlot();
            SkillType selectedType = null;
            if (slot == SkillBonusMenuConfig.getSwordsSlot()) {
                selectedType = SkillType.SWORDS;
            } else if (slot == SkillBonusMenuConfig.getAxesSlot()) {
                selectedType = SkillType.AXES;
            } else if (slot == SkillBonusMenuConfig.getBowsSlot()) {
                selectedType = SkillType.BOWS;
            } else if (slot == SkillBonusMenuConfig.getCrossbowsSlot()) {
                selectedType = SkillType.CROSSBOWS;
            } else if (slot == SkillBonusMenuConfig.getTridentsSlot()) {
                selectedType = SkillType.TRIDENTS;
            } else if (slot == SkillBonusMenuConfig.getHoesSlot()) {
                selectedType = SkillType.HOES;
            } else if (slot == SkillBonusMenuConfig.getArmorSlot()) {
                selectedType = SkillType.ARMOR;
            }
            if (selectedType != null) {
                SkillBonusMenu.openSkillSelectMenu(player, selectedType);
            }
        }

        private void handleSkillSelectClick(Player player, InventoryClickEvent event) {
            SkillType skillType;
            SkillMenuData menuData = skillSelectMenus.get(event.getInventory());
            if (menuData == null) {
                return;
            }
            int slot = event.getSlot();
            if (slot == SkillBonusMenuConfig.getBackSlot()) {
                SkillBonusMenu.openWeaponSelectMenu(player);
                return;
            }
            if (slot == SkillBonusMenuConfig.getInfoSlot()) {
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            String skillId = this.extractSkillId(clickedItem);
            if (skillId == null) {
                return;
            }
            SkillBonusConfigFields skillConfig = SkillBonusesConfig.getBySkillId(skillId);
            if (skillConfig == null) {
                return;
            }
            UUID playerUUID = player.getUniqueId();
            long xp = PlayerData.getSkillXP(playerUUID, skillType = menuData.getSkillType());
            int playerLevel = SkillXPCalculator.levelFromTotalXP(xp);
            if (playerLevel < skillConfig.getRequiredLevel()) {
                player.sendMessage(ChatColorConverter.convert((String)("&cThis skill requires level " + skillConfig.getRequiredLevel() + "!")));
                return;
            }
            List<String> activeSkills = PlayerSkillSelection.getActiveSkills(playerUUID, skillType);
            if (activeSkills.contains(skillId)) {
                PlayerSkillSelection.removeActiveSkill(playerUUID, skillType, skillId);
                player.sendMessage(ChatColorConverter.convert((String)("&eDeactivated skill: " + skillConfig.getName())));
                SkillBonus skill = SkillBonusRegistry.getSkillById(skillId);
                if (skill != null) {
                    skill.onDeactivate(player);
                }
            } else {
                if (activeSkills.size() >= 3) {
                    player.sendMessage(ChatColorConverter.convert((String)SkillBonusMenuConfig.getMaxActiveSkillsReached()));
                    return;
                }
                PlayerSkillSelection.addActiveSkill(playerUUID, skillType, skillId);
                player.sendMessage(ChatColorConverter.convert((String)("&aActivated skill: " + skillConfig.getName())));
                SkillBonus skill = SkillBonusRegistry.getSkillById(skillId);
                if (skill != null) {
                    skill.onActivate(player);
                }
            }
            SkillBonusMenu.openSkillSelectMenu(player, skillType);
        }

        private String extractSkillId(ItemStack item) {
            if (item == null || !item.hasItemMeta()) {
                return null;
            }
            ItemMeta meta = item.getItemMeta();
            if (meta == null || !meta.hasLore()) {
                return null;
            }
            List lore = meta.getLore();
            if (lore == null) {
                return null;
            }
            for (String line : lore) {
                String stripped = ChatColorConverter.convert((String)line);
                if (!stripped.startsWith("ID: ")) continue;
                return stripped.substring(4);
            }
            return null;
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            weaponSelectMenus.remove(event.getInventory());
            skillSelectMenus.remove(event.getInventory());
        }
    }

    private static class SkillMenuData {
        private final SkillType skillType;
        private final UUID playerUUID;

        public SkillMenuData(SkillType skillType, UUID playerUUID) {
            this.skillType = skillType;
            this.playerUUID = playerUUID;
        }

        @Generated
        public SkillType getSkillType() {
            return this.skillType;
        }

        @Generated
        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

