/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.SpecialItemSystemsConfig;
import com.magmaguy.elitemobs.config.menus.premade.ItemEnchantmentMenuConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.instanced.dungeons.EnchantmentDungeonInstance;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.ShareItem;
import com.magmaguy.elitemobs.items.upgradesystem.EliteEnchantmentItems;
import com.magmaguy.elitemobs.items.upgradesystem.UpgradeSystem;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.menus.SharedShopElements;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Round;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemEnchantmentMenu
extends EliteMenu {
    private static final String MENU_NAME = ItemEnchantmentMenuConfig.getMenuName();
    private static final int CANCEL_SLOT = ItemEnchantmentMenuConfig.getCancelSlot();
    private static final ItemStack cancelButton = ItemEnchantmentMenuConfig.getCancelButton();
    private static final int CONFIRM_SLOT = ItemEnchantmentMenuConfig.getConfirmSlot();
    private static final ItemStack confirmButton = ItemEnchantmentMenuConfig.getConfirmButton();
    private static final int INFO_SLOT = ItemEnchantmentMenuConfig.getInfoSlot();
    private static final ItemStack infoButton = ItemEnchantmentMenuConfig.getInfoButton();
    private static final int ITEM_SLOT = ItemEnchantmentMenuConfig.getItemSlot();
    private static final int ENCHANTED_BOOK_SLOT = ItemEnchantmentMenuConfig.getEnchantedBookSlot();
    private static final int ITEM_INFO_SLOT = ItemEnchantmentMenuConfig.getItemInfoSlot();
    private static final ItemStack itemInfoItemButton = ItemEnchantmentMenuConfig.getItemInfoButton();
    private static final int ENCHANTED_BOOK_INFO_SLOT = ItemEnchantmentMenuConfig.getEnchantedBookInfoSlot();
    private static final ItemStack enchantedBookInfoButton = ItemEnchantmentMenuConfig.getEnchantedBookInfoButton();
    private static final List<String> confirmButtonLore = confirmButton.getItemMeta().getLore();
    private static final int LUCKY_TICKET_SLOT = ItemEnchantmentMenuConfig.getLuckyTicketSlot();
    private static final int LUCKY_TICKET_INFO_SLOT = ItemEnchantmentMenuConfig.getLuckyTicketInfoSlot();
    private static final ItemStack luckyTicketInfoButton = ItemEnchantmentMenuConfig.getLuckyTicketInfoButton();
    private static final double LUCKY_TICKET_MULTIPLIER = SpecialItemSystemsConfig.getLuckyTicketMultiplier();
    private static final double CRITICAL_FAILURE_CHANCE = SpecialItemSystemsConfig.getCriticalFailureChance();
    private static final double CHALLENGE_CHANCE = SpecialItemSystemsConfig.getChallengeChance();

    public ItemEnchantmentMenu(Player player) {
        Object name = MENU_NAME;
        if (DefaultConfig.useResourcePackModels()) {
            name = String.valueOf(ChatColor.WHITE) + "\uf801\udb80\udc2a\uf805           " + MENU_NAME;
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)name);
        ItemEnchantMenuEvents.menus.add(inventory);
        inventory.setItem(INFO_SLOT, infoButton);
        inventory.setItem(ENCHANTED_BOOK_INFO_SLOT, enchantedBookInfoButton);
        inventory.setItem(ITEM_INFO_SLOT, itemInfoItemButton);
        inventory.setItem(CANCEL_SLOT, cancelButton);
        inventory.setItem(CONFIRM_SLOT, confirmButton);
        inventory.setItem(LUCKY_TICKET_INFO_SLOT, luckyTicketInfoButton);
        ItemEnchantmentMenu.updateConfirmButton(inventory);
        player.openInventory(inventory);
    }

    private static void updateConfirmButton(Inventory inventory) {
        ItemStack newButton = confirmButton.clone();
        ItemMeta itemMeta = newButton.getItemMeta();
        ArrayList<String> newLore = new ArrayList<String>();
        EnumMap<Chance, Double> chances = ItemEnchantmentMenu.getChanceBreakdown(inventory);
        for (String string : confirmButtonLore) {
            newLore.add(string.replace("$price", "" + ItemEnchantmentMenu.price(inventory)).replace("$currencyName", EconomySettingsConfig.getCurrencyName()).replace("$successChance", "" + Round.twoDecimalPlaces((double)(chances.get((Object)Chance.SUCCESS) * 100.0))).replace("$criticalFailureChance", "" + Round.twoDecimalPlaces((double)(chances.get((Object)Chance.CRITICAL_FAILURE) * 100.0))).replace("$challengeChance", "" + Round.twoDecimalPlaces((double)(chances.get((Object)Chance.CHALLENGE) * 100.0))).replace("$failureChance", "" + Round.twoDecimalPlaces((double)(chances.get((Object)Chance.FAILURE) * 100.0))));
        }
        itemMeta.setLore(newLore);
        newButton.setItemMeta(itemMeta);
        inventory.setItem(CONFIRM_SLOT, newButton);
    }

    private static EnumMap<Chance, Double> getChanceBreakdown(Inventory inventory) {
        EnumMap<Chance, Double> chances = new EnumMap<Chance, Double>(Chance.class);
        boolean luckyTicket = inventory.getItem(LUCKY_TICKET_SLOT) != null;
        double currentTotal = 1.0;
        double criticalFailure = CRITICAL_FAILURE_CHANCE;
        double success = ItemEnchantmentMenu.successChance(inventory);
        currentTotal -= success;
        chances.put(Chance.SUCCESS, success);
        if (success == 1.0) {
            chances.put(Chance.SUCCESS, 1.0);
            chances.put(Chance.CRITICAL_FAILURE, 0.0);
            chances.put(Chance.CHALLENGE, 0.0);
            chances.put(Chance.FAILURE, 0.0);
            return chances;
        }
        if (luckyTicket) {
            criticalFailure /= 2.0;
        }
        criticalFailure *= currentTotal;
        criticalFailure = Round.twoDecimalPlaces((double)criticalFailure);
        chances.put(Chance.CRITICAL_FAILURE, criticalFailure);
        double challenge = Round.twoDecimalPlaces((double)((currentTotal -= criticalFailure) * CHALLENGE_CHANCE));
        chances.put(Chance.CHALLENGE, challenge);
        chances.put(Chance.FAILURE, Round.twoDecimalPlaces((double)(currentTotal -= challenge)));
        return chances;
    }

    private static int price(Inventory inventory) {
        ItemStack itemStack = inventory.getItem(ITEM_SLOT);
        if (itemStack == null) {
            return 0;
        }
        return (int)Math.pow((double)ItemTagger.getEnchantmentCount(itemStack) + 1.0, 4.0);
    }

    private static double successChance(Inventory inventory) {
        ItemStack itemStack = inventory.getItem(ITEM_SLOT);
        if (itemStack == null) {
            return 0.0;
        }
        double chance = 100.0 / ((double)ItemTagger.getEnchantmentCount(itemStack) + 1.0) * 4.0;
        if (inventory.getItem(LUCKY_TICKET_SLOT) != null) {
            chance *= LUCKY_TICKET_MULTIPLIER;
        }
        return Round.twoDecimalPlaces((double)Math.min(1.0, chance / 100.0));
    }

    public static void broadcastEnchantmentMessage(ItemStack upgradedItem, Player upgradingPlayer, String message) {
        if (SpecialItemSystemsConfig.isAnnounceImportantEnchantments() && ItemTagger.getEnchantmentCount(upgradedItem) > 10) {
            if (!message.contains("$itemName")) {
                Bukkit.getOnlinePlayers().forEach(player -> player.spigot().sendMessage(ChatMessageType.CHAT, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)message.replace("$player", upgradingPlayer.getDisplayName())))));
            } else {
                TextComponent itemName = ShareItem.hoverableItemTextComponent(upgradedItem);
                String[] text = message.replace("$itemName", "itemName").split("itemName");
                BaseComponent[] baseComponent1 = TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)text[0].replace("$player", upgradingPlayer.getDisplayName())));
                BaseComponent[] baseComponent2 = TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)text[1].replace("$player", upgradingPlayer.getDisplayName())));
                ComponentBuilder componentBuilder = new ComponentBuilder();
                componentBuilder.append(baseComponent1);
                componentBuilder.append((BaseComponent)itemName);
                componentBuilder.append(baseComponent2);
                Bukkit.getOnlinePlayers().forEach(player -> player.spigot().sendMessage(ChatMessageType.CHAT, componentBuilder.create()));
            }
        }
    }

    public static class ItemEnchantMenuEvents
    implements Listener {
        private static final Set<Inventory> menus = new HashSet<Inventory>();

        public static void shutdown() {
            menus.clear();
        }

        @EventHandler(ignoreCancelled=true)
        public void onInventoryInteract(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, menus)) {
                return;
            }
            event.setCancelled(true);
            if (!SharedShopElements.itemNullPointerPrevention(event)) {
                return;
            }
            if (EliteMenu.isTopMenu(event)) {
                this.handleTopInventory(event);
            } else {
                this.handleBottomInventory(event);
            }
            if (event.getInventory().getItem(ENCHANTED_BOOK_SLOT) != null && event.getInventory().getItem(ITEM_SLOT) != null && !UpgradeSystem.isValidUpgrade(event.getView().getTopInventory().getItem(ITEM_SLOT), event.getView().getTopInventory().getItem(ENCHANTED_BOOK_SLOT))) {
                event.getWhoClicked().sendMessage(ItemEnchantmentMenuConfig.getEnchantmentLimitMessage());
                event.getWhoClicked().closeInventory();
            }
        }

        private void handleTopInventory(InventoryClickEvent event) {
            int clickedSlot = event.getSlot();
            if (clickedSlot == CANCEL_SLOT) {
                event.getWhoClicked().closeInventory();
            } else if (clickedSlot == CONFIRM_SLOT) {
                this.confirm(event);
            } else if (clickedSlot == ITEM_SLOT || clickedSlot == ENCHANTED_BOOK_SLOT || clickedSlot == LUCKY_TICKET_SLOT) {
                EliteMenu.moveItemDown(event.getView().getTopInventory(), clickedSlot, event.getWhoClicked());
                event.getClickedInventory().clear(clickedSlot);
                if (clickedSlot == ITEM_SLOT && event.getView().getTopInventory().getItem(ENCHANTED_BOOK_SLOT) != null) {
                    EliteMenu.moveItemDown(event.getView().getTopInventory(), ENCHANTED_BOOK_SLOT, event.getWhoClicked());
                }
                ItemEnchantmentMenu.updateConfirmButton(event.getInventory());
            }
        }

        private void handleBottomInventory(InventoryClickEvent event) {
            if (EliteEnchantmentItems.isEliteEnchantmentBook(event.getCurrentItem())) {
                if (event.getInventory().getItem(ENCHANTED_BOOK_SLOT) == null) {
                    EliteMenu.moveOneItemUp(ENCHANTED_BOOK_SLOT, event);
                }
            } else if (EliteEnchantmentItems.isEliteLuckyTicket(event.getCurrentItem()) && event.getView().getTopInventory().getItem(LUCKY_TICKET_SLOT) == null) {
                EliteMenu.moveOneItemUp(LUCKY_TICKET_SLOT, event);
                ItemEnchantmentMenu.updateConfirmButton(event.getInventory());
            } else if (ItemTagger.isEliteItem(event.getCurrentItem()) && event.getInventory().getItem(ITEM_SLOT) == null) {
                EliteMenu.moveOneItemUp(ITEM_SLOT, event);
                ItemEnchantmentMenu.updateConfirmButton(event.getInventory());
            }
        }

        private void confirm(InventoryClickEvent event) {
            double price = ItemEnchantmentMenu.price(event.getView().getTopInventory());
            if (EconomyHandler.checkCurrency(event.getWhoClicked().getUniqueId()) < price) {
                event.getWhoClicked().sendMessage(SpecialItemSystemsConfig.getInsufficientFundsMessage().replace("$price", "" + Round.twoDecimalPlaces((double)price)).replace("$currencyName", EconomySettingsConfig.getCurrencyName()).replace("$currentAmount", "" + EconomyHandler.checkCurrency(event.getWhoClicked().getUniqueId())).replace("$itemName", event.getView().getTopInventory().getItem(ITEM_SLOT).getItemMeta().getDisplayName()));
                event.getWhoClicked().closeInventory();
                return;
            }
            if (event.getView().getTopInventory().getItem(ITEM_SLOT) == null || event.getView().getTopInventory().getItem(ENCHANTED_BOOK_SLOT) == null) {
                event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &cYou must add an elite item and an enchanted book to enchant an item!"));
                return;
            }
            EconomyHandler.subtractCurrency(event.getWhoClicked().getUniqueId(), price);
            event.getWhoClicked().sendMessage(SpecialItemSystemsConfig.getNewFundsMessage().replace("$price", "" + price).replace("$currencyName", EconomySettingsConfig.getCurrencyName()).replace("$currentAmount", "" + EconomyHandler.checkCurrency(event.getWhoClicked().getUniqueId())));
            EnumMap<Chance, Double> chance = ItemEnchantmentMenu.getChanceBreakdown(event.getView().getTopInventory());
            double rolledChance = ThreadLocalRandom.current().nextDouble();
            if (rolledChance < chance.get((Object)Chance.CRITICAL_FAILURE)) {
                this.criticalFailure(event);
            } else if (rolledChance < chance.get((Object)Chance.CHALLENGE)) {
                this.challenge(event);
            } else if (rolledChance < chance.get((Object)Chance.FAILURE)) {
                this.failure(event);
            } else {
                this.success(event);
            }
            event.getView().getTopInventory().clear();
            event.getWhoClicked().closeInventory();
        }

        private void failure(InventoryClickEvent event) {
            event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeFailureMessage()));
            EliteMenu.moveItemDown(event.getView().getTopInventory(), ITEM_SLOT, event.getWhoClicked());
        }

        private void challenge(InventoryClickEvent event) {
            ItemStack currentItem = event.getView().getTopInventory().getItem(ITEM_SLOT);
            if (!EnchantmentDungeonInstance.setupRandomEnchantedChallengeDungeon((Player)event.getWhoClicked(), UpgradeSystem.upgrade(currentItem.clone(), event.getView().getTopInventory().getItem(ENCHANTED_BOOK_SLOT)), currentItem.clone())) {
                this.success(event);
                return;
            }
            currentItem.setAmount(currentItem.getAmount() - 1);
            if (currentItem.getAmount() > 0 && EliteMenu.moveItemDown(event.getView().getTopInventory(), ITEM_SLOT, event.getWhoClicked(), false)) {
                event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeInventoryFullMessage()));
            }
            event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeStartMessage()));
            event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeConsequencesMessage()));
            ItemEnchantmentMenu.broadcastEnchantmentMessage(currentItem, (Player)event.getWhoClicked(), SpecialItemSystemsConfig.getChallengeAnnouncement());
        }

        private void criticalFailure(InventoryClickEvent event) {
            event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeCriticalFailureMessage()));
            ItemEnchantmentMenu.broadcastEnchantmentMessage(event.getView().getTopInventory().getItem(ITEM_SLOT), (Player)event.getWhoClicked(), SpecialItemSystemsConfig.getCriticalFailureAnnouncement());
        }

        private void success(InventoryClickEvent event) {
            ItemStack upgradedItem = UpgradeSystem.upgrade(event.getView().getTopInventory().getItem(ITEM_SLOT), event.getView().getTopInventory().getItem(ENCHANTED_BOOK_SLOT));
            Player player = (Player)event.getWhoClicked();
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{upgradedItem});
            if (!leftovers.isEmpty()) {
                event.getWhoClicked().getWorld().dropItem(event.getWhoClicked().getLocation(), upgradedItem);
            }
            event.getWhoClicked().sendMessage(ChatColorConverter.convert((String)DefaultConfig.getEnchantmentChallengeSuccessMessage()));
            ItemEnchantmentMenu.broadcastEnchantmentMessage(upgradedItem, (Player)event.getWhoClicked(), SpecialItemSystemsConfig.getSuccessAnnouncement());
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            if (menus.contains(event.getInventory())) {
                menus.remove(event.getInventory());
                EliteMenu.cancel(event.getPlayer(), event.getView().getTopInventory(), event.getView().getBottomInventory(), new ArrayList<Integer>(List.of(Integer.valueOf(ITEM_SLOT), Integer.valueOf(ENCHANTED_BOOK_SLOT), Integer.valueOf(LUCKY_TICKET_SLOT))));
            }
        }
    }

    private static enum Chance {
        SUCCESS,
        CHALLENGE,
        FAILURE,
        CRITICAL_FAILURE;

    }
}

