/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class PlasmaBootsEnchantment
extends CustomEnchantment {
    public static String key = "plasma_boots";

    public PlasmaBootsEnchantment() {
        super(key, false);
    }

    public static void doPlasmaBootsEnchantment(int level, Player player) {
        player.setVelocity(new Vector(0.0, 0.8, 0.0));
        Bukkit.getScheduler().runTaskTimer((Plugin)MetadataHandler.PLUGIN, task -> {
            if (!player.isValid() || !player.getLocation().clone().subtract(new Vector(0, 1, 0)).getBlock().isPassable() && player.getLocation().getY() - (double)player.getLocation().getBlock().getY() < 0.1 || !player.getLocation().clone().getBlock().isPassable()) {
                task.cancel();
                PlasmaBootsEnchantment.doLanding(level, player);
                return;
            }
            player.getWorld().spawnParticle(Particle.DUST, player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ(), 20, 0.1, 0.1, 0.1, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(0, 100), (int)ThreadLocalRandom.current().nextInt(122, 255), (int)ThreadLocalRandom.current().nextInt(0, 100)), 1.0f));
        }, 5L, 1L);
    }

    private static void doLanding(int level, Player player) {
        for (int i = 1; i < level + 1; ++i) {
            PlasmaBootsEnchantment.doProjectileArray(i, player);
        }
    }

    private static void doProjectileArray(int level, Player player) {
        double height = ((double)level + 0.2 - 1.0) / 2.0;
        Vector vector = new Vector(1.0, height, 0.0);
        for (int i = 0; i < 8; ++i) {
            Vector offsetVector = vector.rotateAroundY((double)i * Math.PI / 4.0);
            Location shotLocation = player.getLocation().clone().add(offsetVector);
            Vector shotVector = shotLocation.clone().subtract(player.getLocation()).toVector().normalize().multiply(0.2);
            PlasmaBootsEnchantment.createProjectile(shotVector, shotLocation, player);
        }
    }

    private static void createProjectile(final Vector shotVector, final Location sourceLocation, final Player player) {
        new BukkitRunnable(){
            final Location currentLocation;
            int counter;
            {
                this.currentLocation = sourceLocation.clone();
                this.counter = 0;
            }

            public void run() {
                if (this.counter > 60) {
                    this.cancel();
                    return;
                }
                ++this.counter;
                for (Entity entity : Objects.requireNonNull(this.currentLocation.getWorld()).getNearbyEntities(this.currentLocation, 0.1, 0.1, 0.1)) {
                    if (!(entity instanceof LivingEntity) || entity.getType().equals((Object)EntityType.PLAYER)) continue;
                    this.cancel();
                    PlasmaBootsEnchantment.doDamage(player, (LivingEntity)entity);
                    break;
                }
                PlasmaBootsEnchantment.doVisualEffect(this.currentLocation);
                this.currentLocation.add(shotVector);
                if (!this.currentLocation.getBlock().isPassable()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private static void doDamage(Player player, LivingEntity livingEntity) {
        livingEntity.damage(2.0, (Entity)player);
    }

    private static void doVisualEffect(Location currentLocation) {
        Objects.requireNonNull(currentLocation.getWorld()).spawnParticle(Particle.DUST, currentLocation.getX(), currentLocation.getY(), currentLocation.getZ(), 5, 0.1, 0.1, 0.1, 1.0, (Object)new Particle.DustOptions(Color.fromRGB((int)ThreadLocalRandom.current().nextInt(0, 100), (int)ThreadLocalRandom.current().nextInt(122, 255), (int)ThreadLocalRandom.current().nextInt(0, 100)), 1.0f));
    }

    public static class PlasmaBootsEnchantmentEvents
    implements Listener {
        private static final HashSet<UUID> players = new HashSet();
        private static final HashSet<UUID> cooldownPlayers = new HashSet();

        public static void shutdown() {
            players.clear();
            cooldownPlayers.clear();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
        public void onSneak(PlayerToggleSneakEvent event) {
            if (!event.isSneaking()) {
                return;
            }
            if (event.getPlayer().isFlying()) {
                return;
            }
            if (cooldownPlayers.contains(event.getPlayer().getUniqueId())) {
                return;
            }
            if (ElitePlayerInventory.playerInventories.get(event.getPlayer().getUniqueId()) == null) {
                return;
            }
            double plasmaBootLevel = ElitePlayerInventory.playerInventories.get(event.getPlayer().getUniqueId()).getPlasmaBootsLevel(true);
            if (plasmaBootLevel < 1.0) {
                return;
            }
            if (!players.contains(event.getPlayer().getUniqueId())) {
                players.add(event.getPlayer().getUniqueId());
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, task -> players.remove(event.getPlayer().getUniqueId()), 10L);
                return;
            }
            players.remove(event.getPlayer().getUniqueId());
            cooldownPlayers.add(event.getPlayer().getUniqueId());
            Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, task -> cooldownPlayers.remove(event.getPlayer().getUniqueId()), 2400L);
            PlasmaBootsEnchantment.doPlasmaBootsEnchantment((int)plasmaBootLevel, event.getPlayer());
        }
    }
}

