/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.items.itemconstructor.ItemConstructor;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ScalableItemConstructor {
    private ScalableItemConstructor() {
    }

    public static ItemStack randomizeScalableItem(int itemTier, Player player, EliteEntity eliteEntity) {
        CustomItem customItem = CustomItem.getScalableItems().get(ThreadLocalRandom.current().nextInt(CustomItem.getScalableItems().size()));
        return ScalableItemConstructor.constructScalableItem(itemTier, customItem, player, eliteEntity);
    }

    public static ItemStack constructScalableItem(int itemTier, CustomItem customItem, Player player, EliteEntity eliteEntity) {
        if (!customItem.getPermission().isEmpty() && !player.hasPermission(customItem.getPermission())) {
            return null;
        }
        HashMap<Enchantment, Integer> newEnchantmentList = ScalableItemConstructor.updateDynamicEnchantments(customItem.getEnchantments());
        return ItemConstructor.constructItem(itemTier, customItem.getCustomItemsConfigFields().getName(), customItem.getCustomItemsConfigFields().getMaterial(), newEnchantmentList, customItem.getCustomEnchantments(), customItem.getPotionEffects(), customItem.getCustomItemsConfigFields().getLore(), eliteEntity, player, false, customItem.getCustomItemsConfigFields().getCustomModelID(), customItem.getCustomItemsConfigFields().getEquipmentModelID(), customItem.getCustomItemsConfigFields().isSoulbound(), customItem.getCustomItemsConfigFields().getFilename());
    }

    private static HashMap<Enchantment, Integer> updateDynamicEnchantments(HashMap<Enchantment, Integer> enchantmentsList) {
        ArrayList<Enchantment> enchantmentsArray = new ArrayList<Enchantment>();
        for (Enchantment enchantment : enchantmentsList.keySet()) {
            for (int i = 0; i < enchantmentsList.get(enchantment); ++i) {
                enchantmentsArray.add(enchantment);
            }
        }
        HashMap<Enchantment, Integer> newEnchantmentList = new HashMap<Enchantment, Integer>();
        for (int i = 0; i < enchantmentsArray.size(); ++i) {
            int random = ThreadLocalRandom.current().nextInt(0, enchantmentsArray.size());
            if (!newEnchantmentList.containsKey(enchantmentsArray.get(random))) {
                newEnchantmentList.put((Enchantment)enchantmentsArray.get(random), 1);
            } else {
                int currentValue = newEnchantmentList.get(enchantmentsArray.get(random)) + 1;
                newEnchantmentList.put((Enchantment)enchantmentsArray.get(random), currentValue);
            }
            enchantmentsArray.remove(random);
        }
        return newEnchantmentList;
    }

    public static ItemStack randomizeLimitedItem(int itemTier, Player player, EliteEntity eliteEntity) {
        CustomItem customItem;
        ArrayList localLootList = new ArrayList();
        for (int i = 0; i < itemTier; ++i) {
            if (!CustomItem.getLimitedItems().containsKey(i)) continue;
            localLootList.addAll(CustomItem.getLimitedItems().get(i));
        }
        if (localLootList.size() == 0) {
            ItemStackGenerator.generateItemStack((Material)Material.AIR);
        }
        if (!(customItem = (CustomItem)localLootList.get(ThreadLocalRandom.current().nextInt(localLootList.size()))).getPermission().isEmpty() && !player.hasPermission(customItem.getPermission())) {
            return null;
        }
        return ScalableItemConstructor.constructLimitedItem(itemTier, customItem, player, eliteEntity);
    }

    public static ItemStack constructLimitedItem(int itemTier, CustomItem customItem, Player player, EliteEntity eliteEntity) {
        int adjustedItemLevel = Math.min(itemTier, customItem.getItemLevel());
        HashMap<Enchantment, Integer> newEnchantmentList = ScalableItemConstructor.updateDynamicEnchantments(customItem.getEnchantments());
        return ItemConstructor.constructItem(adjustedItemLevel, customItem.getCustomItemsConfigFields().getName(), customItem.getCustomItemsConfigFields().getMaterial(), newEnchantmentList, customItem.getCustomEnchantments(), customItem.getPotionEffects(), customItem.getCustomItemsConfigFields().getLore(), eliteEntity, player, false, customItem.getCustomItemsConfigFields().getCustomModelID(), customItem.getCustomItemsConfigFields().getEquipmentModelID(), customItem.getCustomItemsConfigFields().isSoulbound(), customItem.getCustomItemsConfigFields().getFilename());
    }
}

