/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.EconomySettingsConfig;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.Round;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ItemLootShower
implements Listener {
    private static final HashMap<UUID, Double> playerCurrencyPickup = new HashMap();
    public static HashMap<UUID, Coin> coinValues = new HashMap();
    private final Player player;

    public static void shutdown() {
        playerCurrencyPickup.clear();
        coinValues.clear();
    }

    public ItemLootShower(double itemLevel, final double mobLevel, Location location, final Player player) {
        this.player = player;
        if (ElitePlayerInventory.playerInventories.get(player.getUniqueId()) == null) {
            return;
        }
        if (!EconomySettingsConfig.isEnableCurrencyShower() || !SoulbindEnchantment.isEnabled) {
            return;
        }
        if (Math.abs(mobLevel - (double)ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(false)) > (double)ItemSettingsConfig.getLootLevelDifferenceLockout()) {
            new BukkitRunnable(this){
                int counter = 0;

                public void run() {
                    ++this.counter;
                    if (!player.isValid() || this.counter > 100) {
                        this.cancel();
                        return;
                    }
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)ItemSettingsConfig.getLevelRangeTooDifferent()).replace("$playerLevel", "" + ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getFullPlayerTier(false)).replace("$bossLevel", "" + (int)mobLevel)));
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
            return;
        }
        if (ItemSettingsConfig.isPutLootDirectlyIntoPlayerInventory()) {
            this.addDirectly(this.getCurrencyAmount(itemLevel));
        } else {
            this.addIndirectly(location, this.getCurrencyAmount(itemLevel));
        }
    }

    public ItemLootShower(Location location, Player player, int amount) {
        this.player = player;
        this.addIndirectly(location, amount);
    }

    private static void sendCurrencyNotification(final Player player) {
        final UUID playerUUID = player.getUniqueId();
        if (playerCurrencyPickup.containsKey(playerUUID)) {
            return;
        }
        new BukkitRunnable(){
            double oldAmount = 0.0;

            public void run() {
                if (!playerCurrencyPickup.containsKey(playerUUID)) {
                    playerCurrencyPickup.put(playerUUID, 0.0);
                    return;
                }
                if (this.oldAmount != playerCurrencyPickup.get(playerUUID)) {
                    this.oldAmount = playerCurrencyPickup.get(playerUUID);
                    return;
                }
                if (!player.isOnline()) {
                    playerCurrencyPickup.remove(playerUUID);
                    this.cancel();
                    return;
                }
                player.sendMessage(ChatColorConverter.convert((String)EconomySettingsConfig.getChatCurrencyShowerMessage().replace("$currency_name", EconomySettingsConfig.getCurrencyName()).replace("$amount", String.valueOf(playerCurrencyPickup.get(playerUUID)))));
                playerCurrencyPickup.remove(playerUUID);
                ItemLootShower.sendAdventurersGuildNotification(player);
                this.cancel();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 40L);
    }

    private static void sendAdventurersGuildNotification(Player player) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)EconomySettingsConfig.getAdventurersGuildNotificationMessage())));
    }

    private void addIndirectly(final Location location, final int currencyAmount2) {
        new BukkitRunnable(){
            int currencyAmount;
            {
                this.currencyAmount = currencyAmount2;
            }

            public void run() {
                if (this.currencyAmount <= 0) {
                    this.cancel();
                    return;
                }
                if (this.currencyAmount >= 1000 && ThreadLocalRandom.current().nextDouble() < 0.65) {
                    ItemLootShower.this.dropOneThousand(location);
                    this.currencyAmount -= 1000;
                    return;
                }
                if (this.currencyAmount >= 500 && ThreadLocalRandom.current().nextDouble() < 0.65) {
                    ItemLootShower.this.dropFiveHundred(location);
                    this.currencyAmount -= 500;
                    return;
                }
                if (this.currencyAmount >= 100) {
                    if (ThreadLocalRandom.current().nextDouble() < 0.65) {
                        ItemLootShower.this.dropOneHundred(location);
                        this.currencyAmount -= 100;
                    }
                } else if (this.currencyAmount >= 50) {
                    if (ThreadLocalRandom.current().nextDouble() < 0.65) {
                        ItemLootShower.this.dropFifty(location);
                        this.currencyAmount -= 50;
                    }
                } else if (this.currencyAmount >= 20) {
                    if (ThreadLocalRandom.current().nextDouble() < 0.65) {
                        ItemLootShower.this.dropTwenty(location);
                        this.currencyAmount -= 20;
                    }
                } else if (this.currencyAmount >= 10) {
                    if (ThreadLocalRandom.current().nextDouble() < 0.65) {
                        ItemLootShower.this.dropTen(location);
                        this.currencyAmount -= 10;
                    }
                } else if (this.currencyAmount >= 5) {
                    if (ThreadLocalRandom.current().nextDouble() < 0.65) {
                        ItemLootShower.this.dropFive(location);
                        this.currencyAmount -= 5;
                    }
                } else {
                    ItemLootShower.this.dropOne(location);
                    --this.currencyAmount;
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 2L, 2L);
    }

    private int getCurrencyAmount(double eliteMobTier) {
        return (int)(eliteMobTier / 2.0 * EconomySettingsConfig.getCurrencyShowerMultiplier());
    }

    private void addDirectly(double eliteMobTier) {
        EconomyHandler.addCurrency(this.player.getUniqueId(), this.getCurrencyAmount(eliteMobTier));
        this.player.sendMessage(ChatColorConverter.convert((String)EconomySettingsConfig.getChatCurrencyShowerMessage().replace("$currency_name", EconomySettingsConfig.getCurrencyName()).replace("$amount", "" + this.getCurrencyAmount(eliteMobTier))));
    }

    private Item generateCurrencyItem(Material material, Location location, double value) {
        ItemStack currencyItemStack = SoulbindEnchantment.addEnchantment(ItemStackGenerator.generateItemStack((Material)material, (String)"", new ArrayList<CallSite>(List.of("EliteMobsCurrencyItem", "" + value, "" + ThreadLocalRandom.current().nextDouble()))), this.player);
        String model = null;
        try {
            model = EconomySettingsConfig.getThisConfiguration().getString("lootShowerDataV2." + (int)value);
        }
        catch (Exception ex) {
            Logger.warn((String)("Failed to get coin model for value " + value + " !"));
            ex.printStackTrace();
        }
        if (model == null) {
            Logger.warn((String)("No model found for value " + value + " !"));
        } else {
            this.setCoinModel(currencyItemStack, model);
        }
        Item currencyItem = location.getWorld().dropItem(location.clone().add(new Vector(0, 1, 0)), currencyItemStack);
        EntityTracker.registerVisualEffects((Entity)currencyItem);
        currencyItem.setInvulnerable(true);
        currencyItem.setVelocity(new Vector((ThreadLocalRandom.current().nextDouble() - 0.5) / 2.0, 0.5, (ThreadLocalRandom.current().nextDouble() - 0.5) / 2.0));
        SoulbindEnchantment.addPhysicalDisplay(currencyItem, this.player);
        new Coin(this, value, this.player, currencyItem);
        return currencyItem;
    }

    private void dropOne(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial1()), location, 1.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 1 is invalid. Defaulting to gold nugget.");
            currencyItem = this.generateCurrencyItem(Material.GOLD_NUGGET, location, 1.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&71 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropFive(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial5()), location, 5.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 5 is invalid. Defaulting to gold ingot.");
            currencyItem = this.generateCurrencyItem(Material.GOLD_INGOT, location, 5.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&f5 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropTen(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial10()), location, 10.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 10 is invalid. Defaulting to Gold block.");
            currencyItem = this.generateCurrencyItem(Material.GOLD_BLOCK, location, 10.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&a10 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropTwenty(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial20()), location, 20.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 20 is invalid. Defaulting to emerald.");
            currencyItem = this.generateCurrencyItem(Material.EMERALD, location, 20.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&220 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropFifty(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial50()), location, 50.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 50 is invalid. Defaulting to emerald block.");
            currencyItem = this.generateCurrencyItem(Material.EMERALD_BLOCK, location, 50.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&250 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropOneHundred(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial100()), location, 100.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 100 is invalid. Defaulting to diamond.");
            currencyItem = this.generateCurrencyItem(Material.DIAMOND, location, 100.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&2100 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropFiveHundred(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial500()), location, 500.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 500 is invalid. Defaulting to diamond block.");
            currencyItem = this.generateCurrencyItem(Material.DIAMOND_BLOCK, location, 500.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&2500 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private void dropOneThousand(Location location) {
        Item currencyItem;
        try {
            currencyItem = this.generateCurrencyItem(Material.getMaterial((String)EconomySettingsConfig.getLootShowerMaterial1000()), location, 1000.0);
        }
        catch (Exception ex) {
            Logger.warn((String)"Material for EliteMob shower 1000 is invalid. Defaulting to nether star.");
            currencyItem = this.generateCurrencyItem(Material.NETHER_STAR, location, 1000.0);
        }
        currencyItem.setCustomName(ChatColorConverter.convert((String)("&21000 " + EconomySettingsConfig.getCurrencyName())));
        currencyItem.setCustomNameVisible(true);
    }

    private ItemStack setCoinModel(ItemStack itemStack, String data) {
        CustomModelAdder.addCustomModel(itemStack, data);
        return itemStack;
    }

    private class Coin {
        UUID player;
        UUID item;
        double value;
        boolean pickupable;

        public Coin(final ItemLootShower itemLootShower, final double value, final Player player, final Item item) {
            this.player = player.getUniqueId();
            this.value = value;
            this.item = item.getUniqueId();
            coinValues.put(item.getUniqueId(), this);
            this.pickupable = false;
            item.setGravity(false);
            new BukkitRunnable(this){

                public void run() {
                    if (coinValues.containsKey(item.getUniqueId())) {
                        if (Bukkit.getEntity((UUID)item.getUniqueId()) != null) {
                            Bukkit.getEntity((UUID)item.getUniqueId()).remove();
                        }
                        coinValues.remove(item.getUniqueId());
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 6000L);
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    if (!item.isValid() || !player.isValid() || !player.getWorld().equals((Object)item.getWorld()) || this.counter > 80 || item.getLocation().distanceSquared(player.getLocation()) > 900.0) {
                        this.cancel();
                        Coin.this.pickupable = true;
                        item.setGravity(true);
                        return;
                    }
                    item.setVelocity(player.getLocation().clone().subtract(item.getLocation()).toVector().normalize().multiply(0.2));
                    if (player.getLocation().distanceSquared(item.getLocation()) <= 1.0) {
                        item.remove();
                        EconomyHandler.addCurrency(player.getUniqueId(), value);
                        ItemLootShower.sendCurrencyNotification(player);
                        UUID coinPlayerUUID = player.getUniqueId();
                        if (playerCurrencyPickup.containsKey(coinPlayerUUID)) {
                            playerCurrencyPickup.put(coinPlayerUUID, playerCurrencyPickup.get(coinPlayerUUID) + value);
                        } else {
                            playerCurrencyPickup.put(coinPlayerUUID, value);
                        }
                        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)EconomySettingsConfig.getActionBarCurrencyShowerMessage().replace("$currency_name", EconomySettingsConfig.getCurrencyName()).replace("$amount", "" + Round.twoDecimalPlaces((double)playerCurrencyPickup.get(coinPlayerUUID))))));
                        coinValues.remove(item.getUniqueId());
                        this.cancel();
                        return;
                    }
                    ++this.counter;
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 1L);
        }
    }

    public static class ItemLootShowerEvents
    implements Listener {
        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public static void onItemPickup(EntityPickupItemEvent event) {
            if (!coinValues.containsKey(event.getItem().getUniqueId())) {
                return;
            }
            event.setCancelled(true);
            if (!event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
                return;
            }
            Coin coin = coinValues.get(event.getItem().getUniqueId());
            if (!coin.pickupable) {
                return;
            }
            coinValues.remove(event.getItem().getUniqueId());
            double amountIncremented = coin.value;
            Player player = (Player)event.getEntity();
            event.getItem().remove();
            EconomyHandler.addCurrency(player.getUniqueId(), amountIncremented);
            ItemLootShower.sendCurrencyNotification(player);
            UUID playerUUID = player.getUniqueId();
            if (playerCurrencyPickup.containsKey(playerUUID)) {
                playerCurrencyPickup.put(playerUUID, playerCurrencyPickup.get(playerUUID) + amountIncremented);
            } else {
                playerCurrencyPickup.put(playerUUID, amountIncremented);
            }
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColorConverter.convert((String)EconomySettingsConfig.getActionBarCurrencyShowerMessage().replace("$currency_name", EconomySettingsConfig.getCurrencyName()).replace("$amount", "" + Round.twoDecimalPlaces((double)playerCurrencyPickup.get(playerUUID))))));
        }

        @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
        public static void onItemPickup(InventoryPickupItemEvent event) {
            if (!coinValues.containsKey(event.getItem().getUniqueId())) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

