/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.dungeons;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.SpecialItemSystemsConfig;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.WorldDungeonPackage;
import com.magmaguy.elitemobs.instanced.WorldOperationQueue;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.menus.ItemEnchantmentMenu;
import com.magmaguy.elitemobs.utils.WorldInstantiator;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EnchantmentDungeonInstance
extends DungeonInstance {
    Player player;
    private ItemStack upgradedItem;
    private ItemStack currentItem;

    public EnchantmentDungeonInstance(ContentPackagesConfigFields contentPackagesConfigFields, Location lobbyLocation, Location startLocation, World world, Player player, String difficultyName) {
        super(contentPackagesConfigFields, lobbyLocation, startLocation, world, player, difficultyName);
        this.player = player;
    }

    public static boolean setupRandomEnchantedChallengeDungeon(Player player, ItemStack upgradedItem, ItemStack itemFromInventory) {
        String instancedWordName;
        ArrayList contentPackagesConfigFieldsList = new ArrayList();
        WorldDungeonPackage.getEmPackages().values().stream().forEach(emPackage -> {
            if (emPackage.isInstalled() && emPackage.getContentPackagesConfigFields().isEnchantmentChallenge()) {
                contentPackagesConfigFieldsList.add(emPackage.getContentPackagesConfigFields());
            }
        });
        if (contentPackagesConfigFieldsList.isEmpty()) {
            player.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &cYou rolled challenge but your server has not installed any challenge dungeons! &2This will count as an automatic enchantment success."));
            return false;
        }
        ContentPackagesConfigFields contentPackagesConfigFields = (ContentPackagesConfigFields)((Object)contentPackagesConfigFieldsList.get(ThreadLocalRandom.current().nextInt(0, contentPackagesConfigFieldsList.size())));
        if (!EnchantmentDungeonInstance.launchEvent(contentPackagesConfigFields, instancedWordName = WorldInstantiator.getNewWorldName(contentPackagesConfigFields.getWorldName()), player)) {
            return false;
        }
        ItemStack upgradedItemClone = upgradedItem.clone();
        ItemStack currentItemClone = itemFromInventory.clone();
        WorldOperationQueue.queueOperation(player, () -> EnchantmentDungeonInstance.cloneWorldFiles(contentPackagesConfigFields, instancedWordName, player) != null, () -> {
            DungeonInstance dungeonInstance = EnchantmentDungeonInstance.initializeInstancedWorld(contentPackagesConfigFields, instancedWordName, player, (String)contentPackagesConfigFields.getDifficulties().get(0).get("name"));
            if (dungeonInstance instanceof EnchantmentDungeonInstance) {
                EnchantmentDungeonInstance enchantmentDungeonInstance = (EnchantmentDungeonInstance)dungeonInstance;
                enchantmentDungeonInstance.setUpgradedItem(upgradedItemClone);
                enchantmentDungeonInstance.setCurrentItem(currentItemClone);
            }
        }, contentPackagesConfigFields.getName());
        return true;
    }

    @Override
    public void endMatch() {
        new BukkitRunnable(){

            public void run() {
                EnchantmentDungeonInstance.this.removeInstance();
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 200L);
    }

    @Override
    protected void victory() {
        super.victory();
        this.player.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &2Challenge complete! Instance will close in 10 seconds. &6You can leave earlier by doing &9/em quit&6!"));
        this.player.sendMessage(ChatColorConverter.convert((String)"&8[EliteMobs] &2You succeeded your item enchantment challenge! Your item has been successfully enchanted."));
        ItemEnchantmentMenu.broadcastEnchantmentMessage(this.upgradedItem, this.player, SpecialItemSystemsConfig.getSuccessAnnouncement());
        HashMap leftOvers = this.player.getInventory().addItem(new ItemStack[]{this.upgradedItem});
        if (!leftOvers.isEmpty()) {
            this.player.getWorld().dropItem(this.player.getLocation(), this.upgradedItem);
        }
    }

    @Override
    protected void defeat() {
        super.defeat();
        if (ThreadLocalRandom.current().nextDouble() < SpecialItemSystemsConfig.getCriticalFailureChanceDuringChallengeChance()) {
            this.player.sendMessage(ChatColorConverter.convert((String)("&8[EliteMobs] &4Critical enchantment failure! You have lost " + this.currentItem.getItemMeta().getDisplayName() + " &c!")));
            ItemEnchantmentMenu.broadcastEnchantmentMessage(this.upgradedItem, this.player, SpecialItemSystemsConfig.getCriticalFailureAnnouncement());
        } else {
            this.player.sendMessage(ChatColorConverter.convert((String)("&8[EliteMobs] &cYou have failed the enchantment challenge! Your item " + this.currentItem.getItemMeta().getDisplayName() + " &cwas not enchanted.")));
            HashMap leftOvers = this.player.getInventory().addItem(new ItemStack[]{this.currentItem});
            if (!leftOvers.isEmpty()) {
                this.player.getWorld().dropItem(this.player.getLocation(), this.currentItem);
            }
        }
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public void setPlayer(Player player) {
        this.player = player;
    }

    @Generated
    public ItemStack getUpgradedItem() {
        return this.upgradedItem;
    }

    @Generated
    public void setUpgradedItem(ItemStack upgradedItem) {
        this.upgradedItem = upgradedItem;
    }

    @Generated
    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    @Generated
    public void setCurrentItem(ItemStack currentItem) {
        this.currentItem = currentItem;
    }
}

