/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.dungeons;

import com.magmaguy.elitemobs.api.DungeonUninstallEvent;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.EMPackage;
import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.dungeons.utility.DungeonUtils;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomMusic;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldPackage
extends EMPackage {
    protected World world;

    public WorldPackage(ContentPackagesConfigFields contentPackagesConfigFields) {
        super(contentPackagesConfigFields);
    }

    @Override
    public void doInstall(Player player) {
        DungeonUtils.loadWorld(this);
        this.contentPackagesConfigFields.installWorld();
        player.teleport(this.contentPackagesConfigFields.getTeleportLocation());
        this.world = this.contentPackagesConfigFields.getTeleportLocation().getWorld();
        if (this.contentPackagesConfigFields.getSong() != null) {
            new CustomMusic(this.contentPackagesConfigFields.getSong(), this.contentPackagesConfigFields, this.world);
        }
        for (Wormhole wormhole : Wormhole.getWormholes()) {
            wormhole.onDungeonInstall(this.contentPackagesConfigFields.getFilename());
        }
        player.sendMessage(ChatColorConverter.convert((String)("[EliteMobs] Successfully installed " + this.contentPackagesConfigFields.getName() + "! To uninstall, do /em setup again and click on this content again.")));
    }

    @Override
    public void doUninstall(Player player) {
        DungeonUninstallEvent event = new DungeonUninstallEvent(this.contentPackagesConfigFields);
        new EventCaller(event);
        this.isInstalled = false;
        if (!DungeonUtils.unloadWorld(this)) {
            this.isInstalled = true;
            return;
        }
        for (Wormhole wormhole : Wormhole.getWormholes()) {
            wormhole.onDungeonUninstall(this.contentPackagesConfigFields.getFilename());
        }
        this.contentPackagesConfigFields.uninstallWorld();
        this.world = null;
    }

    @Override
    public void baseInitialization() {
        if (this.contentPackagesConfigFields.getWorldName() == null || this.contentPackagesConfigFields.getWorldName().isEmpty()) {
            this.isInstalled = false;
            this.isDownloaded = false;
            Logger.warn((String)("Packaged content " + this.contentPackagesConfigFields.getFilename() + " does not have a valid world name in the dungeon packager!"));
            return;
        }
        content.put(this.contentPackagesConfigFields.getWorldName(), this);
        if (this.contentPackagesConfigFields.getWormholeWorldName() != null && !this.contentPackagesConfigFields.getWormholeWorldName().isEmpty()) {
            content.put(this.contentPackagesConfigFields.getWormholeWorldName(), this);
        }
        if (Bukkit.getWorld((String)this.contentPackagesConfigFields.getWorldName()) != null) {
            this.isInstalled = true;
            this.isDownloaded = true;
            this.world = Bukkit.getWorld((String)this.contentPackagesConfigFields.getWorldName());
            EliteMobsWorld.create(this.world.getUID(), this.contentPackagesConfigFields);
            this.contentPackagesConfigFields.initializeWorld();
            return;
        }
        this.isInstalled = this.contentPackagesConfigFields.isEnabled();
        this.isDownloaded = Files.exists(Paths.get(String.valueOf(Bukkit.getWorldContainer()) + File.separator + this.contentPackagesConfigFields.getWorldName(), new String[0]), new LinkOption[0]);
        if (this.isDownloaded && this.isInstalled) {
            this.world = DungeonUtils.loadWorld(this);
            if (this.contentPackagesConfigFields.getSong() != null) {
                new CustomMusic(this.contentPackagesConfigFields.getSong(), this.contentPackagesConfigFields, this.world);
            }
            this.contentPackagesConfigFields.initializeWorld();
        } else {
            this.isInstalled = false;
        }
    }

    @Override
    public void initializeContent() {
    }

    @Generated
    public World getWorld() {
        return this.world;
    }
}

