/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.skillbonuses;

import com.magmaguy.elitemobs.config.skillbonuses.SkillBonusConfigFields;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.magmacore.config.CustomConfig;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;

public class SkillBonusesConfig
extends CustomConfig {
    private static HashMap<String, SkillBonusConfigFields> skillBonuses = new HashMap();

    public SkillBonusesConfig() {
        super("skillbonuses", "com.magmaguy.elitemobs.config.skillbonuses.premade", SkillBonusConfigFields.class);
        skillBonuses = new HashMap();
        for (String key : super.getCustomConfigFieldsHashMap().keySet()) {
            skillBonuses.put(key.toLowerCase(Locale.ROOT), (SkillBonusConfigFields)((Object)super.getCustomConfigFieldsHashMap().get(key)));
        }
        Logger.info((String)("Loaded " + skillBonuses.size() + " skill bonus configurations."));
    }

    public static SkillBonusConfigFields getSkillBonus(String filename) {
        Object key = filename.toLowerCase(Locale.ROOT);
        if (!((String)key).endsWith(".yml")) {
            key = (String)key + ".yml";
        }
        return skillBonuses.get(key);
    }

    public static SkillBonusConfigFields getBySkillId(String skillId) {
        return SkillBonusesConfig.getSkillBonus(skillId + ".yml");
    }

    public static List<SkillBonusConfigFields> getBySkillType(SkillType skillType) {
        ArrayList<SkillBonusConfigFields> result = new ArrayList<SkillBonusConfigFields>();
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (config.getSkillType() != skillType) continue;
            result.add(config);
        }
        return result;
    }

    public static List<SkillBonusConfigFields> getEnabledBySkillType(SkillType skillType) {
        ArrayList<SkillBonusConfigFields> result = new ArrayList<SkillBonusConfigFields>();
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (config.getSkillType() != skillType || !config.isEnabled()) continue;
            result.add(config);
        }
        return result;
    }

    public static List<SkillBonusConfigFields> getByBonusType(SkillBonusType bonusType) {
        ArrayList<SkillBonusConfigFields> result = new ArrayList<SkillBonusConfigFields>();
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (config.getBonusType() != bonusType) continue;
            result.add(config);
        }
        return result;
    }

    public static List<SkillBonusConfigFields> getByTier(SkillType skillType, int unlockTier) {
        ArrayList<SkillBonusConfigFields> result = new ArrayList<SkillBonusConfigFields>();
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (config.getSkillType() != skillType || config.getUnlockTier() != unlockTier) continue;
            result.add(config);
        }
        return result;
    }

    public static List<SkillBonusConfigFields> getAllEnabled() {
        ArrayList<SkillBonusConfigFields> result = new ArrayList<SkillBonusConfigFields>();
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (!config.isEnabled()) continue;
            result.add(config);
        }
        return result;
    }

    public static int getSkillCount() {
        return skillBonuses.size();
    }

    public static int getEnabledSkillCount() {
        int count = 0;
        for (SkillBonusConfigFields config : skillBonuses.values()) {
            if (!config.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public static void shutdown() {
        skillBonuses.clear();
    }

    @Generated
    public static HashMap<String, SkillBonusConfigFields> getSkillBonuses() {
        return skillBonuses;
    }
}

