/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.mobproperties;

import com.magmaguy.elitemobs.config.translations.TranslationsConfig;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;

public class MobPropertiesConfigFields {
    private final String fileName;
    private final EntityType entityType;
    private final boolean isEnabled;
    private final String name;
    private final List<String> deathMessages;
    private final double baseDamage;

    public MobPropertiesConfigFields(String fileName, EntityType entityType, boolean isEnabled, String name, List<String> deathMessages, double baseDamage) {
        this.fileName = fileName + ".yml";
        this.entityType = entityType;
        this.isEnabled = isEnabled;
        this.name = name;
        this.deathMessages = deathMessages;
        this.baseDamage = baseDamage;
    }

    public MobPropertiesConfigFields(FileConfiguration configuration, File file) {
        this.fileName = file.getName();
        this.entityType = EntityType.valueOf((String)configuration.getString("entityType"));
        this.isEnabled = configuration.getBoolean("isEnabled");
        this.name = TranslationsConfig.add(this.fileName, "name", configuration.getString("name"));
        this.deathMessages = TranslationsConfig.add(this.fileName, "deathMessages", configuration.getStringList("deathMessages"));
        this.baseDamage = configuration.getDouble("baseDamageV2");
    }

    public void generateConfigDefaults(FileConfiguration fileConfiguration) {
        fileConfiguration.addDefault("isEnabled", (Object)this.isEnabled);
        fileConfiguration.addDefault("entityType", (Object)this.entityType.toString());
        fileConfiguration.addDefault("name", (Object)this.name);
        fileConfiguration.addDefault("deathMessages", this.deathMessages);
        fileConfiguration.addDefault("baseDamageV2", (Object)this.baseDamage);
    }

    public String getFileName() {
        return this.fileName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String getName() {
        return ChatColorConverter.convert((String)this.name);
    }

    public List<String> getDeathMessages() {
        return this.deathMessages;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }
}

