/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.magmacore.config.ConfigurationFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;

public class MobCombatSettingsConfig
extends ConfigurationFile {
    private static boolean doNaturalMobSpawning;
    private static boolean doSpawnersSpawnEliteMobs;
    private static double aggressiveMobConversionPercentage;
    private static int superMobsStackRange;
    private static int naturalEliteMobLevelCap;
    private static boolean doEliteArmor;
    private static boolean doEliteHelmets;
    private static boolean enableVisualEffectsForNaturalMobs;
    private static boolean disableVisualEffectsForSpawnerMobs;
    private static boolean enableWarningVisualEffects;
    private static boolean enableDeathMessages;
    private static boolean displayHealthOnHit;
    private static boolean displayDamageOnHit;
    private static boolean increaseDifficultyWithSpawnDistance;
    private static double distanceToIncrement;
    private static double levelToIncrement;
    private static boolean obfuscateMobPowers;
    private static double damageToEliteMultiplier;
    private static double damageToPlayerMultiplier;
    private static boolean showCustomBossLocation;
    private static String bossLocationMessage;
    private static List<String> commandsOnDeath;
    private static String bossKillParticipationMessage;
    private static boolean regenerateCustomBossHealthOnCombatEnd;
    private static String defaultOtherWorldBossLocationMessage;
    private static String weakTextColor;
    private static String resistTextColor;
    private static String weakText;
    private static String resistText;
    private static boolean doWeakEffect;
    private static boolean doResistEffect;
    private static double normalizedBaselineDamage;
    private static double normalizedBaselineHealth;
    private static double normalizedDamageToEliteMultiplier;
    private static double normalizedDamageToPlayerMultiplier;
    private static boolean normalizeRegionalBosses;
    private static String fullHealMessage;
    private static double strengthAndWeaknessDamageMultipliers;
    private static double resistanceDamageMultiplier;
    private static double blockingDamageReduction;
    private static boolean silenceAllDeathMessages;
    private static boolean displayVisualHealthBars;
    private static boolean displayNumericHealth;
    private static boolean displayBossBarForHighMultiplier;
    private static double bossBarHealthMultiplierThreshold;
    private static double proximityBossBarHealthMultiplierThreshold;
    private static int combatDisplayTimeoutSeconds;
    private static boolean useFixedHealthBarSize;
    private static MobCombatSettingsConfig instance;

    public MobCombatSettingsConfig() {
        super("MobCombatSettings.yml");
    }

    public static void toggleNaturalMobSpawning(boolean enabled) {
        doNaturalMobSpawning = enabled;
        MobCombatSettingsConfig.instance.fileConfiguration.set("doNaturalEliteMobSpawning", (Object)enabled);
        ConfigurationEngine.fileSaverCustomValues((FileConfiguration)MobCombatSettingsConfig.instance.fileConfiguration, (File)MobCombatSettingsConfig.instance.file);
    }

    public void initializeValues() {
        instance = this;
        doNaturalMobSpawning = ConfigurationEngine.setBoolean(List.of("Sets if naturally spawned elites will spawn. Note: event mobs like the zombie king are not naturally spawned elites! You will have to disable events if you want to disable event bosses."), (FileConfiguration)this.fileConfiguration, (String)"doNaturalEliteMobSpawning", (boolean)true);
        doSpawnersSpawnEliteMobs = ConfigurationEngine.setBoolean(List.of("Sets if spawns spawned from mob spawners can be converted to elites. Not recommended!"), (FileConfiguration)this.fileConfiguration, (String)"doSpawnersSpawnEliteMobs", (boolean)false);
        aggressiveMobConversionPercentage = ConfigurationEngine.setDouble(List.of("Sets the percentage of naturally spawned mobs that get converted to elite mobs."), (FileConfiguration)this.fileConfiguration, (String)"eliteMobsSpawnPercentage", (double)0.05);
        superMobsStackRange = Math.max(ConfigurationEngine.setInt(List.of("Sets the super mob range to scan for super mob stacking"), (FileConfiguration)this.fileConfiguration, (String)"superMobStackRange", (int)15), 2);
        naturalEliteMobLevelCap = ConfigurationEngine.setInt(List.of("Sets the maximum level elites can spawn at.", "Note: elite mob level is based on player skill levels and gear. The skill system scales up to level 100."), (FileConfiguration)this.fileConfiguration, (String)"naturalEliteMobsLevelCap", (int)120);
        doEliteArmor = ConfigurationEngine.setBoolean(List.of("Sets if elites will wear armor based on their level. This is for visual purposes only and does not affect combat."), (FileConfiguration)this.fileConfiguration, (String)"doElitesWearArmor", (boolean)true);
        doEliteHelmets = ConfigurationEngine.setBoolean(List.of("Sets if elites will wear helmets based on their level. This will prevent them from easily burning away during the daytime."), (FileConfiguration)this.fileConfiguration, (String)"doElitesWearHelmets", (boolean)true);
        enableVisualEffectsForNaturalMobs = ConfigurationEngine.setBoolean(List.of("Sets if elites will have visual trails around them warning players about what players they have."), (FileConfiguration)this.fileConfiguration, (String)"doNaturalEliteMobVisualEffects", (boolean)true);
        disableVisualEffectsForSpawnerMobs = ConfigurationEngine.setBoolean(List.of("Sets if elites spawned from spawners will do visual effects."), (FileConfiguration)this.fileConfiguration, (String)"doSpawnerEliteMobVisualEffects", (boolean)false);
        enableWarningVisualEffects = ConfigurationEngine.setBoolean(List.of("Sets if some powers will do the warning phase of the power. This is very important as warning phases usually mean the power can be dodged, and the visual lets players know where to dodge to."), (FileConfiguration)this.fileConfiguration, (String)"doPowerBuildupVisualEffects", (boolean)true);
        enableDeathMessages = ConfigurationEngine.setBoolean(List.of("Sets if custom death messages will be used when players die from elites."), (FileConfiguration)this.fileConfiguration, (String)"doCustomEliteMobsDeathMessages", (boolean)true);
        displayHealthOnHit = ConfigurationEngine.setBoolean(List.of("Sets if EliteMobs will show health indicators for elites."), (FileConfiguration)this.fileConfiguration, (String)"doDisplayMobHealthOnHit", (boolean)true);
        displayDamageOnHit = ConfigurationEngine.setBoolean(List.of("Sets if EliteMobs will show damage indicators for damage done to elites."), (FileConfiguration)this.fileConfiguration, (String)"doDisplayMobDamageOnHit", (boolean)true);
        increaseDifficultyWithSpawnDistance = ConfigurationEngine.setBoolean(List.of("Sets if the level of elites will increased based on the distance from spawn.", "This is a value added on top of their normal level, meaning that if a player is wearing level 100 gear near spawn and the boss has +1 level due from the distanced from spawn, the boss will spawn at level 101.", "This option is generally not recommended, especially if you have a random tp system on your server."), (FileConfiguration)this.fileConfiguration, (String)"doIncreaseEliteMobLevelBasedOnSpawnDistance", (boolean)false);
        distanceToIncrement = ConfigurationEngine.setDouble(List.of("Sets the distance between level increments for distance-based level increases."), (FileConfiguration)this.fileConfiguration, (String)"distanceBetweenIncrements", (double)100.0);
        levelToIncrement = ConfigurationEngine.setDouble(List.of("Sets how many levels increase at each distance increment for distance-based level increases."), (FileConfiguration)this.fileConfiguration, (String)"levelIncreaseAtIncrements", (double)1.0);
        obfuscateMobPowers = ConfigurationEngine.setBoolean(List.of("Sets if the powers of elites will be hidden until they enter combat. This is recommended for performance reasons."), (FileConfiguration)this.fileConfiguration, (String)"hideEliteMobPowersUntilAggro", (boolean)true);
        damageToEliteMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier for the damage dealt to all bosses spawned by EliteMobs, except those using the normalized damage system (regional dungeon bosses). Higher values increase the damage dealt, making bosses easier to kill.", "2.0 = 200%, 0.5 = 50%"), (FileConfiguration)this.fileConfiguration, (String)"damageToEliteMobMultiplierV2", (double)1.0);
        damageToPlayerMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier for the damage dealt to players by elites. Higher values increase the amount of damage dealt by bosses, except those using the normalized damage system (regional dungeon bosses), making bosses hit harder.", "2.0 = 200%, 0.5 = 50%"), (FileConfiguration)this.fileConfiguration, (String)"damageToPlayerMultiplierV2", (double)1.0);
        showCustomBossLocation = ConfigurationEngine.setBoolean(List.of("Sets if special bosses can be tracked."), (FileConfiguration)this.fileConfiguration, (String)"showCustomBossLocation", (boolean)true);
        bossLocationMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players to track a boss location."), this.file, this.fileConfiguration, "bossLocationMessage", "&7[EM] &2[Click to track!]", true);
        commandsOnDeath = ConfigurationEngine.setList(List.of("Sets the commands that run when an elite dies. Valid placeholders are:", "$level for the level of the boss", "$name for the name of the boss", "$players will make the command run for each player that participated in the kill. As an example, if Bob and Steve killed a boss, 'broadcast $players killed the boss!' will run 'bob killed the boss' and 'steve killed the boss!'"), this.file, this.fileConfiguration, "commandsOnEliteMobDeath", Collections.emptyList(), false);
        bossKillParticipationMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players that participate in big boss kills."), this.file, this.fileConfiguration, "bossKillParticipationMessage", "&eYour damage: &2$playerDamage", true);
        regenerateCustomBossHealthOnCombatEnd = ConfigurationEngine.setBoolean(List.of("Sets if bosses regenerate health when they go out of combat. Strongly recommended."), (FileConfiguration)this.fileConfiguration, (String)"regenerateCustomBossHealthOnCombatEnd", (boolean)true);
        defaultOtherWorldBossLocationMessage = ConfigurationEngine.setString(List.of("Sets the message sent to players that are trying to track bosses currently in a different world."), this.file, this.fileConfiguration, "defaultOtherWorldBossLocationMessage", "$name: In different world!", true);
        weakTextColor = ConfigurationEngine.setString(List.of("Sets the prefix added to damage indicators when players hit a boss with something that boss is weak against."), this.file, this.fileConfiguration, "weakTextColor", "&9", false);
        resistTextColor = ConfigurationEngine.setString(List.of("Sets the prefix added to damage indicators when players hit a boss with something that boss is strong against."), this.file, this.fileConfiguration, "resistTextColor", "&c", false);
        weakText = ConfigurationEngine.setString(List.of("Sets the message that appears when players hit the boss with something that boss is weak against."), this.file, this.fileConfiguration, "weakText", "&9&lWeak!", true);
        resistText = ConfigurationEngine.setString(List.of("Sets the message that appears when players hit the boss with something that boss is strong against."), this.file, this.fileConfiguration, "resistText", "&c&lResist!", true);
        doWeakEffect = ConfigurationEngine.setBoolean(List.of("Sets if visuals will be used to show that a boss is weak against an attack."), (FileConfiguration)this.fileConfiguration, (String)"doWeakEffect", (boolean)true);
        doResistEffect = ConfigurationEngine.setBoolean(List.of("Sets if visuals will be used to show that a boss is strong against an attack."), (FileConfiguration)this.fileConfiguration, (String)"doResistEffect", (boolean)true);
        normalizedDamageToEliteMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier for the damage dealt to bosses using the normalized damage system (regional dungeon bosses). Higher values increase the damage dealt, making bosses easier to kill.", "2.0 = 200%, 0.5 = 50%"), (FileConfiguration)this.fileConfiguration, (String)"normalizedDamageToEliteMultiplier", (double)1.0);
        normalizedDamageToPlayerMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier for the damage dealt to players by bosses using the normalized damage system (regional dungeon bosses). Higher values increase the amount of damage dealt by bosses, making bosses hit harder.", "2.0 = 200%, 0.5 = 50%"), (FileConfiguration)this.fileConfiguration, (String)"normalizedDamageToPlayerMultiplier", (double)1.0);
        normalizedBaselineDamage = ConfigurationEngine.setDouble(List.of("Sets the baseline damage for custom bosses using the normalized damage (usually regional bosses)."), (FileConfiguration)this.fileConfiguration, (String)"normalizedBaselineDamageV3", (double)3.0);
        normalizedBaselineHealth = ConfigurationEngine.setDouble(List.of("Sets the baseline health for custom bosses using the normalized health (usually regional bosses)."), (FileConfiguration)this.fileConfiguration, (String)"normalizedRegionalBossBaselineHealthV3", (double)4.0);
        normalizeRegionalBosses = ConfigurationEngine.setBoolean(List.of("Sets if regional bosses will used the normalized combat system.", "This is very strongly recommended, and premade content will not be balanced properly if modified."), (FileConfiguration)this.fileConfiguration, (String)"normalizeRegionalBosses", (boolean)true);
        fullHealMessage = ConfigurationEngine.setString(List.of("Sets the message that appears when a boss heals from going out of combat."), this.file, this.fileConfiguration, "fullHealMessage", "&2FULL HEAL!", true);
        strengthAndWeaknessDamageMultipliers = ConfigurationEngine.setDouble(List.of("Sets the multipliers applied to attacks bosses are strong and weak against."), (FileConfiguration)this.fileConfiguration, (String)"strengthAndWeaknessDamageMultipliers", (double)2.0);
        resistanceDamageMultiplier = ConfigurationEngine.setDouble(List.of("Sets the multiplier applied to damage reduction from the resistance potion effect for players."), (FileConfiguration)this.fileConfiguration, (String)"resistanceDamageMultiplier", (double)1.0);
        blockingDamageReduction = ConfigurationEngine.setDouble(List.of("Sets the multiplier applied to damage reduction when a player is holding up a shield for melee attacks (powers excluded)."), (FileConfiguration)this.fileConfiguration, (String)"blockingDamageReduction", (double)0.8);
        silenceAllDeathMessages = ConfigurationEngine.setBoolean(List.of("Sets if all death messages will be silenced. This is not recommended, as it might hide some lore in dungeons."), (FileConfiguration)this.fileConfiguration, (String)"silenceAllDeathMessages", (boolean)false);
        displayVisualHealthBars = ConfigurationEngine.setBoolean(List.of("Sets if visual health bars (using bar characters) will be displayed above elite mobs during combat.", "The number of bars scales with the health multiplier of the boss."), (FileConfiguration)this.fileConfiguration, (String)"displayVisualHealthBars", (boolean)true);
        displayNumericHealth = ConfigurationEngine.setBoolean(List.of("Sets if numeric health values (current/max) will be displayed above the visual health bars."), (FileConfiguration)this.fileConfiguration, (String)"displayNumericHealth", (boolean)true);
        displayBossBarForHighMultiplier = ConfigurationEngine.setBoolean(List.of("Sets if boss bars (at the top of the screen) will be displayed for bosses with health multiplier above the threshold."), (FileConfiguration)this.fileConfiguration, (String)"displayBossBarForHighMultiplier", (boolean)true);
        bossBarHealthMultiplierThreshold = ConfigurationEngine.setDouble(List.of("Sets the health multiplier threshold above which boss bars will be displayed when entering combat.", "Bosses with a health multiplier greater than this value will show boss bars to players in combat."), (FileConfiguration)this.fileConfiguration, (String)"bossBarHealthMultiplierThreshold", (double)1.0);
        proximityBossBarHealthMultiplierThreshold = ConfigurationEngine.setDouble(List.of("Sets the health multiplier threshold above which boss bars will be displayed to nearby players (within 30 blocks).", "Bosses with a health multiplier of this value or greater will show boss bars even without combat engagement."), (FileConfiguration)this.fileConfiguration, (String)"proximityBossBarHealthMultiplierThreshold", (double)9.0);
        combatDisplayTimeoutSeconds = ConfigurationEngine.setInt(List.of("Sets how many seconds after the last combat action the health display will remain visible.", "After this time, the visual health bars and boss bars will disappear."), (FileConfiguration)this.fileConfiguration, (String)"combatDisplayTimeoutSeconds", (int)30);
        useFixedHealthBarSize = ConfigurationEngine.setBoolean(List.of("Sets if the health bar should always be a fixed size (10 bars) regardless of boss health multiplier.", "When false (default), the health bar scales with the boss health multiplier, adding more bars and rows for tankier bosses.", "When true, the health bar is always a single row of 10 bars."), (FileConfiguration)this.fileConfiguration, (String)"useFixedHealthBarSize", (boolean)false);
    }

    @Generated
    public static boolean isDoNaturalMobSpawning() {
        return doNaturalMobSpawning;
    }

    @Generated
    public static boolean isDoSpawnersSpawnEliteMobs() {
        return doSpawnersSpawnEliteMobs;
    }

    @Generated
    public static double getAggressiveMobConversionPercentage() {
        return aggressiveMobConversionPercentage;
    }

    @Generated
    public static int getSuperMobsStackRange() {
        return superMobsStackRange;
    }

    @Generated
    public static int getNaturalEliteMobLevelCap() {
        return naturalEliteMobLevelCap;
    }

    @Generated
    public static boolean isDoEliteArmor() {
        return doEliteArmor;
    }

    @Generated
    public static boolean isDoEliteHelmets() {
        return doEliteHelmets;
    }

    @Generated
    public static boolean isEnableVisualEffectsForNaturalMobs() {
        return enableVisualEffectsForNaturalMobs;
    }

    @Generated
    public static boolean isDisableVisualEffectsForSpawnerMobs() {
        return disableVisualEffectsForSpawnerMobs;
    }

    @Generated
    public static boolean isEnableWarningVisualEffects() {
        return enableWarningVisualEffects;
    }

    @Generated
    public static boolean isEnableDeathMessages() {
        return enableDeathMessages;
    }

    @Generated
    public static boolean isDisplayHealthOnHit() {
        return displayHealthOnHit;
    }

    @Generated
    public static boolean isDisplayDamageOnHit() {
        return displayDamageOnHit;
    }

    @Generated
    public static boolean isIncreaseDifficultyWithSpawnDistance() {
        return increaseDifficultyWithSpawnDistance;
    }

    @Generated
    public static double getDistanceToIncrement() {
        return distanceToIncrement;
    }

    @Generated
    public static double getLevelToIncrement() {
        return levelToIncrement;
    }

    @Generated
    public static boolean isObfuscateMobPowers() {
        return obfuscateMobPowers;
    }

    @Generated
    public static double getDamageToEliteMultiplier() {
        return damageToEliteMultiplier;
    }

    @Generated
    public static double getDamageToPlayerMultiplier() {
        return damageToPlayerMultiplier;
    }

    @Generated
    public static boolean isShowCustomBossLocation() {
        return showCustomBossLocation;
    }

    @Generated
    public static String getBossLocationMessage() {
        return bossLocationMessage;
    }

    @Generated
    public static List<String> getCommandsOnDeath() {
        return commandsOnDeath;
    }

    @Generated
    public static String getBossKillParticipationMessage() {
        return bossKillParticipationMessage;
    }

    @Generated
    public static boolean isRegenerateCustomBossHealthOnCombatEnd() {
        return regenerateCustomBossHealthOnCombatEnd;
    }

    @Generated
    public static String getDefaultOtherWorldBossLocationMessage() {
        return defaultOtherWorldBossLocationMessage;
    }

    @Generated
    public static String getWeakTextColor() {
        return weakTextColor;
    }

    @Generated
    public static String getResistTextColor() {
        return resistTextColor;
    }

    @Generated
    public static String getWeakText() {
        return weakText;
    }

    @Generated
    public static String getResistText() {
        return resistText;
    }

    @Generated
    public static boolean isDoWeakEffect() {
        return doWeakEffect;
    }

    @Generated
    public static boolean isDoResistEffect() {
        return doResistEffect;
    }

    @Generated
    public static double getNormalizedBaselineDamage() {
        return normalizedBaselineDamage;
    }

    @Generated
    public static double getNormalizedBaselineHealth() {
        return normalizedBaselineHealth;
    }

    @Generated
    public static double getNormalizedDamageToEliteMultiplier() {
        return normalizedDamageToEliteMultiplier;
    }

    @Generated
    public static double getNormalizedDamageToPlayerMultiplier() {
        return normalizedDamageToPlayerMultiplier;
    }

    @Generated
    public static boolean isNormalizeRegionalBosses() {
        return normalizeRegionalBosses;
    }

    @Generated
    public static String getFullHealMessage() {
        return fullHealMessage;
    }

    @Generated
    public static double getStrengthAndWeaknessDamageMultipliers() {
        return strengthAndWeaknessDamageMultipliers;
    }

    @Generated
    public static double getResistanceDamageMultiplier() {
        return resistanceDamageMultiplier;
    }

    @Generated
    public static double getBlockingDamageReduction() {
        return blockingDamageReduction;
    }

    @Generated
    public static boolean isSilenceAllDeathMessages() {
        return silenceAllDeathMessages;
    }

    @Generated
    public static boolean isDisplayVisualHealthBars() {
        return displayVisualHealthBars;
    }

    @Generated
    public static boolean isDisplayNumericHealth() {
        return displayNumericHealth;
    }

    @Generated
    public static boolean isDisplayBossBarForHighMultiplier() {
        return displayBossBarForHighMultiplier;
    }

    @Generated
    public static double getBossBarHealthMultiplierThreshold() {
        return bossBarHealthMultiplierThreshold;
    }

    @Generated
    public static double getProximityBossBarHealthMultiplierThreshold() {
        return proximityBossBarHealthMultiplierThreshold;
    }

    @Generated
    public static int getCombatDisplayTimeoutSeconds() {
        return combatDisplayTimeoutSeconds;
    }

    @Generated
    public static boolean isUseFixedHealthBarSize() {
        return useFixedHealthBarSize;
    }
}

