/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.IntegerCommandArgument;
import com.magmaguy.magmacore.command.arguments.PlayerCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillSetAllCommand
extends AdvancedCommand {
    public SkillSetAllCommand() {
        super(List.of("skill"));
        this.addLiteral("setAll");
        this.addArgument("player", (ICommandArgument)new PlayerCommandArgument());
        this.addArgument("level", (ICommandArgument)new IntegerCommandArgument("<level>"));
        this.setUsage("/em skill setAll <player> <level>");
        this.setPermission("elitemobs.skill.admin");
        this.setDescription("Sets all of a player's skills to the specified level.");
    }

    public void execute(CommandData commandData) {
        String playerName = commandData.getStringArgument("player");
        int level = commandData.getIntegerArgument("level");
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&cPlayer not found: " + playerName));
            return;
        }
        if (level < 1) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)"&cLevel must be at least 1!");
            return;
        }
        if (level > 100) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&eWarning: Level " + level + " is above the soft cap of 100."));
        }
        long targetXP = SkillXPCalculator.totalXPForLevel(level);
        for (SkillType skillType : SkillType.values()) {
            PlayerData.setSkillXP(targetPlayer.getUniqueId(), skillType, targetXP);
        }
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&aSet all of " + targetPlayer.getName() + "'s skills to level " + level));
    }
}

