/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.magmacore.command.AdvancedCommand;
import com.magmaguy.magmacore.command.CommandData;
import com.magmaguy.magmacore.command.arguments.ICommandArgument;
import com.magmaguy.magmacore.command.arguments.PlayerCommandArgument;
import com.magmaguy.magmacore.util.Logger;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkillCheckCommand
extends AdvancedCommand {
    public SkillCheckCommand() {
        super(List.of("skill"));
        this.addLiteral("check");
        this.addArgument("player", (ICommandArgument)new PlayerCommandArgument());
        this.setUsage("/em skill check <player>");
        this.setPermission("elitemobs.skill.check");
        this.setDescription("Displays a player's skill levels.");
    }

    public void execute(CommandData commandData) {
        String playerName = commandData.getStringArgument("player");
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&cPlayer not found: " + playerName));
            return;
        }
        Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)("&6=== " + targetPlayer.getName() + "'s Skills ==="));
        for (SkillType skillType : SkillType.values()) {
            long xp = PlayerData.getSkillXP(targetPlayer.getUniqueId(), skillType);
            int level = SkillXPCalculator.levelFromTotalXP(xp);
            long xpProgress = SkillXPCalculator.xpProgressInCurrentLevel(xp);
            long xpNeeded = SkillXPCalculator.xpToNextLevel(level);
            double progress = SkillXPCalculator.levelProgress(xp) * 100.0;
            Logger.sendMessage((CommandSender)commandData.getCommandSender(), (String)String.format("&7%s: &aLevel %d &7(%s/%s XP, %.1f%%)", skillType.getDisplayName(), level, this.formatNumber(xpProgress), this.formatNumber(xpNeeded), progress));
        }
    }

    private String formatNumber(long number) {
        if (number >= 1000000L) {
            return String.format("%.1fM", (double)number / 1000000.0);
        }
        if (number >= 1000L) {
            return String.format("%.1fK", (double)number / 1000.0);
        }
        return String.valueOf(number);
    }
}

