/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.collateralminecraftchanges;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.AttributeManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class KeepNeutralsAngry {
    private static final Map<UUID, BukkitTask> angryMobTasks = new HashMap<UUID, BukkitTask>();

    private KeepNeutralsAngry() {
    }

    public static void shutdown() {
        for (BukkitTask task : angryMobTasks.values()) {
            if (task == null || task.isCancelled()) continue;
            task.cancel();
        }
        angryMobTasks.clear();
    }

    public static void showMeYouWarFace(final EliteEntity eliteEntity) {
        final EntityType entityType = eliteEntity.getLivingEntity().getType();
        final UUID entityUUID = eliteEntity.getLivingEntity().getUniqueId();
        if (angryMobTasks.containsKey(entityUUID)) {
            return;
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                CustomBossEntity customBossEntity;
                if (eliteEntity instanceof CustomBossEntity && (customBossEntity = (CustomBossEntity)eliteEntity).getCustomBossesConfigFields().isNeutral()) {
                    return;
                }
                if (!eliteEntity.isValid() || !entityType.equals((Object)eliteEntity.getLivingEntity().getType()) || entityType.equals((Object)EntityType.WOLF) && ((Wolf)eliteEntity.getLivingEntity()).isTamed()) {
                    this.cancel();
                    angryMobTasks.remove(entityUUID);
                    return;
                }
                if (!eliteEntity.getLivingEntity().getType().equals((Object)EntityType.LLAMA) && !eliteEntity.getLivingEntity().getType().equals((Object)EntityType.RABBIT) && ((Mob)eliteEntity.getLivingEntity()).getTarget() != null) {
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getGameMode().equals((Object)GameMode.SPECTATOR) || player.getGameMode().equals((Object)GameMode.CREATIVE) || !Objects.equals(player.getLocation().getWorld(), eliteEntity.getLocation().getWorld()) || !(player.getLocation().distanceSquared(eliteEntity.getLocation()) < Math.pow(AttributeManager.getAttributeBaseValue((LivingEntity)eliteEntity.getLivingEntity(), (String)"generic_follow_range"), 2.0))) continue;
                    ((Mob)eliteEntity.getLivingEntity()).setTarget((LivingEntity)player);
                    return;
                }
                ((Mob)eliteEntity.getLivingEntity()).setTarget(null);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 20L);
        angryMobTasks.put(entityUUID, task);
    }
}

