/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.wormhole.WormholeManager;
import com.magmaguy.magmacore.util.Logger;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class PlayerTeleportEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Location destination;
    private final Location originalLocation;
    private final Player player;
    private boolean isCancelled = false;

    public PlayerTeleportEvent(Player player, Location destination) {
        this.player = player;
        this.destination = destination;
        this.originalLocation = player.getLocation().clone();
    }

    public static void teleportPlayer(Player player, Location destination) {
        PlayerTeleportEvent playerTeleportEvent = new PlayerTeleportEvent(player, destination);
        new EventCaller(playerTeleportEvent);
        if (!playerTeleportEvent.isCancelled()) {
            player.teleport(destination);
        }
        Logger.debug((String)("[PlayerTeleportEvent] teleportPlayer() called for " + player.getName() + ", cancelled=" + playerTeleportEvent.isCancelled()));
        player.teleport(destination);
        Logger.debug((String)"Forced tp");
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean b) {
        this.isCancelled = b;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public void executeTeleport() {
        Logger.debug((String)("[PlayerTeleportEvent] executeTeleport() called for " + this.player.getName()));
        if (this.destination == null) {
            Logger.debug((String)"[PlayerTeleportEvent] Teleport failed: destination is null");
            return;
        }
        if (this.destination.getWorld() == null) {
            Logger.debug((String)"[PlayerTeleportEvent] Teleport failed: destination world is null. Is the AG world loaded?");
            return;
        }
        if (this.player.getLocation().getWorld() != null && !EliteMobsWorld.isEliteMobsWorld(this.player.getLocation().getWorld().getUID())) {
            PlayerData.setBackTeleportLocation(this.player, this.originalLocation);
        }
        WormholeManager.getInstance(false).addPlayerToCooldown(this.player, this.destination);
        Logger.debug((String)("[PlayerTeleportEvent] On main thread: " + Bukkit.isPrimaryThread()));
        Logger.debug((String)("[PlayerTeleportEvent] Player state - valid: " + this.player.isValid() + ", dead: " + this.player.isDead() + ", online: " + this.player.isOnline() + ", vehicle: " + (this.player.getVehicle() != null)));
        Logger.debug((String)("[PlayerTeleportEvent] About to call player.teleport() to: " + this.destination.getWorld().getName() + " " + this.destination.getBlockX() + "," + this.destination.getBlockY() + "," + this.destination.getBlockZ()));
        this.destination.getWorld().getChunkAt(this.destination).load();
        boolean success = this.player.teleport(this.destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
        Logger.debug((String)("[PlayerTeleportEvent] player.teleport() returned: " + success));
        if (!success) {
            Logger.debug((String)"[PlayerTeleportEvent] Teleport failed, attempting fallback with setVelocity reset");
            this.player.setVelocity(new Vector(0, 0, 0));
            success = this.player.teleport(this.destination, PlayerTeleportEvent.TeleportCause.PLUGIN);
            Logger.debug((String)("[PlayerTeleportEvent] Fallback teleport returned: " + success));
        }
    }

    @Generated
    public Location getDestination() {
        return this.destination;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    public static class BukkitTeleportDebugListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onBukkitTeleport(org.bukkit.event.player.PlayerTeleportEvent event) {
            if (event.isCancelled()) {
                Logger.debug((String)("[BukkitTeleportDebug] Bukkit PlayerTeleportEvent was CANCELLED for " + event.getPlayer().getName() + " | Cause: " + String.valueOf(event.getCause()) + " | From: " + (event.getFrom() != null ? event.getFrom().getWorld().getName() : "null") + " | To: " + (event.getTo() != null && event.getTo().getWorld() != null ? event.getTo().getWorld().getName() : "null")));
            }
        }
    }

    public static class PlayerTeleportEventExecutor
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            Logger.debug((String)("[PlayerTeleportEvent] PlayerTeleportEventExecutor received event for " + event.getPlayer().getName() + ", isCancelled=" + event.isCancelled()));
            event.executeTeleport();
        }
    }
}

