/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api;

import com.magmaguy.elitemobs.EliteMobs;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteDamageEvent;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerAntiExploitEvent;
import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.entitytracker.CustomProjectileData;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.elitemobs.skills.SkillType;
import com.magmaguy.elitemobs.skills.SkillXPCalculator;
import com.magmaguy.elitemobs.skills.bonuses.PlayerSkillSelection;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonus;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusRegistry;
import com.magmaguy.elitemobs.skills.bonuses.SkillBonusType;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ConditionalSkill;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.CooldownSkill;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ProcSkill;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.StackingSkill;
import com.magmaguy.elitemobs.skills.bonuses.interfaces.ToggleSkill;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardCompatibility;
import com.magmaguy.elitemobs.thirdparty.worldguard.WorldGuardFlagChecker;
import com.magmaguy.elitemobs.utils.EntityFinder;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.magmacore.util.Round;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class EliteMobDamagedByPlayerEvent
extends EliteDamageEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Entity entity;
    private final EliteEntity eliteMobEntity;
    private final Player player;
    private final EntityDamageByEntityEvent entityDamageByEntityEvent;
    private final boolean criticalStrike;
    private final boolean isCustomDamage;
    private final double damageModifier;
    public boolean rangedAttack;

    public EliteMobDamagedByPlayerEvent(EliteEntity eliteEntity, Player player, EntityDamageByEntityEvent event, double damage, boolean criticalStrike, boolean isCustomDamage, double damageModifier) {
        super(damage, (Event)event);
        this.entity = eliteEntity.getLivingEntity();
        this.eliteMobEntity = eliteEntity;
        this.player = player;
        this.entityDamageByEntityEvent = event;
        this.rangedAttack = event != null && event.getDamager() instanceof Projectile;
        this.criticalStrike = criticalStrike;
        this.isCustomDamage = isCustomDamage;
        this.damageModifier = damageModifier;
    }

    public EliteMobDamagedByPlayerEvent(EliteEntity eliteEntity, Player player, double damage, boolean isRangedAttack) {
        super(damage, null);
        this.entity = eliteEntity.getLivingEntity();
        this.eliteMobEntity = eliteEntity;
        this.player = player;
        this.entityDamageByEntityEvent = null;
        this.rangedAttack = isRangedAttack;
        this.criticalStrike = false;
        this.isCustomDamage = false;
        this.damageModifier = 1.0;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    public void applySkillBonuses() {
        if (this.player == null || this.player.hasMetadata("NPC")) {
            return;
        }
        if (!ElitePlayerInventory.playerInventories.containsKey(this.player.getUniqueId())) {
            return;
        }
        SkillType weaponSkillType = EliteMobDamagedByPlayerEvent.getWeaponSkillType(this.player);
        if (weaponSkillType == null) {
            return;
        }
        int skillLevel = SkillBonusRegistry.getPlayerSkillLevel(this.player, weaponSkillType);
        List<String> activeSkillIds = PlayerSkillSelection.getActiveSkills(this.player.getUniqueId(), weaponSkillType);
        double damageMultiplier = 1.0;
        for (String skillId : activeSkillIds) {
            SkillBonus skill = SkillBonusRegistry.getSkillById(skillId);
            if (skill == null || !skill.isEnabled() || !skill.meetsLevelRequirement(skillLevel)) continue;
            damageMultiplier *= this.processOffensiveSkill(skill, skillLevel);
        }
        if (damageMultiplier != 1.0) {
            this.setDamage(this.getDamage() * damageMultiplier);
        }
    }

    private double processOffensiveSkill(SkillBonus skill, int skillLevel) {
        return switch (skill.getBonusType()) {
            default -> throw new MatchException(null, null);
            case SkillBonusType.PASSIVE -> {
                skill.incrementProcCount(this.player);
                yield 1.0 + skill.getBonusValue(skillLevel);
            }
            case SkillBonusType.CONDITIONAL -> {
                ConditionalSkill conditionalSkill;
                if (skill instanceof ConditionalSkill && (conditionalSkill = (ConditionalSkill)((Object)skill)).conditionMet(this.player, (Object)this)) {
                    skill.incrementProcCount(this.player);
                    yield 1.0 + conditionalSkill.getConditionalBonus(skillLevel);
                }
                yield 1.0;
            }
            case SkillBonusType.STACKING -> {
                if (skill instanceof StackingSkill) {
                    StackingSkill stackingSkill = (StackingSkill)((Object)skill);
                    int stacks = stackingSkill.getCurrentStacks(this.player);
                    stackingSkill.addStack(this.player);
                    skill.incrementProcCount(this.player);
                    yield 1.0 + (double)stacks * stackingSkill.getBonusPerStack(skillLevel);
                }
                yield 1.0;
            }
            case SkillBonusType.PROC -> {
                if (skill instanceof ProcSkill) {
                    ProcSkill procSkill = (ProcSkill)((Object)skill);
                    double procChance = procSkill.getProcChance(skillLevel);
                    if (ThreadLocalRandom.current().nextDouble() < procChance) {
                        procSkill.onProc(this.player, (Object)this);
                        skill.incrementProcCount(this.player);
                        yield 1.0 + skill.getBonusValue(skillLevel);
                    }
                }
                yield 1.0;
            }
            case SkillBonusType.COOLDOWN -> {
                CooldownSkill cooldownSkill;
                if (skill instanceof CooldownSkill && !(cooldownSkill = (CooldownSkill)((Object)skill)).isOnCooldown(this.player)) {
                    cooldownSkill.onActivate(this.player, (Object)this);
                    cooldownSkill.startCooldown(this.player, skillLevel);
                    skill.incrementProcCount(this.player);
                    yield 1.0 + skill.getBonusValue(skillLevel);
                }
                yield 1.0;
            }
            case SkillBonusType.TOGGLE -> {
                ToggleSkill toggleSkill;
                if (skill instanceof ToggleSkill && (toggleSkill = (ToggleSkill)((Object)skill)).isToggled(this.player)) {
                    skill.incrementProcCount(this.player);
                    yield 1.0 + toggleSkill.getPositiveBonus(skillLevel);
                }
                yield 1.0;
            }
        };
    }

    private static SkillType getWeaponSkillType(Player player) {
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (mainHand == null || mainHand.getType() == Material.AIR) {
            return null;
        }
        Material type = mainHand.getType();
        String typeName = type.name();
        if (typeName.endsWith("_SWORD")) {
            return SkillType.SWORDS;
        }
        if (typeName.endsWith("_AXE")) {
            return SkillType.AXES;
        }
        if (type == Material.BOW) {
            return SkillType.BOWS;
        }
        if (type == Material.CROSSBOW) {
            return SkillType.CROSSBOWS;
        }
        if (type == Material.TRIDENT) {
            return SkillType.TRIDENTS;
        }
        if (typeName.endsWith("_HOE")) {
            return SkillType.HOES;
        }
        return null;
    }

    @Generated
    public Entity getEntity() {
        return this.entity;
    }

    @Generated
    public EliteEntity getEliteMobEntity() {
        return this.eliteMobEntity;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public EntityDamageByEntityEvent getEntityDamageByEntityEvent() {
        return this.entityDamageByEntityEvent;
    }

    @Generated
    public boolean isCriticalStrike() {
        return this.criticalStrike;
    }

    @Generated
    public boolean isCustomDamage() {
        return this.isCustomDamage;
    }

    @Generated
    public double getDamageModifier() {
        return this.damageModifier;
    }

    @Generated
    public boolean isRangedAttack() {
        return this.rangedAttack;
    }

    public static class EliteMobDamagedByPlayerEventFilter
    implements Listener {
        public static boolean bypass = false;

        private static double getThornsDamage(Player player) {
            if (!ItemSettingsConfig.isUseEliteEnchantments()) {
                return 0.0;
            }
            ElitePlayerInventory elitePlayerInventory = ElitePlayerInventory.getPlayer(player);
            int thornsLevel = 0;
            if (elitePlayerInventory.helmet.thornsLevel > Enchantment.THORNS.getMaxLevel()) {
                thornsLevel += elitePlayerInventory.helmet.thornsLevel - Enchantment.THORNS.getMaxLevel();
            }
            if (elitePlayerInventory.chestplate.thornsLevel > Enchantment.THORNS.getMaxLevel()) {
                thornsLevel += elitePlayerInventory.chestplate.thornsLevel - Enchantment.THORNS.getMaxLevel();
            }
            if (elitePlayerInventory.leggings.thornsLevel > Enchantment.THORNS.getMaxLevel()) {
                thornsLevel += elitePlayerInventory.helmet.thornsLevel - Enchantment.THORNS.getMaxLevel();
            }
            if (elitePlayerInventory.boots.thornsLevel > Enchantment.THORNS.getMaxLevel()) {
                thornsLevel += elitePlayerInventory.boots.thornsLevel - Enchantment.THORNS.getMaxLevel();
            }
            return (double)thornsLevel * 2.5;
        }

        private static double getEliteMeleeDamage(Player player, LivingEntity livingEntity) {
            if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.BOW) || player.getInventory().getItemInMainHand().getType().equals((Object)Material.CROSSBOW)) {
                return 0.0;
            }
            double itemEliteDamage = ElitePlayerInventory.getPlayer(player).getEliteDamage(true);
            SkillType weaponSkillType = EliteMobDamagedByPlayerEvent.getWeaponSkillType(player);
            int playerSkillLevel = 1;
            if (weaponSkillType != null) {
                long skillXP = PlayerData.getSkillXP(player.getUniqueId(), weaponSkillType);
                playerSkillLevel = SkillXPCalculator.levelFromTotalXP(skillXP);
            }
            double attackSpeed = EliteItemManager.getAttackSpeed(player.getInventory().getItemInMainHand());
            double skillDamage = (double)playerSkillLevel * 1.6 / attackSpeed;
            double effectiveEliteDamage = skillDamage * 0.5 + itemEliteDamage * 0.5;
            double bonusEliteDamage = EliteMobDamagedByPlayerEventFilter.secondaryEnchantmentDamageIncrease(player, livingEntity);
            return (effectiveEliteDamage + bonusEliteDamage) * (double)player.getAttackCooldown();
        }

        private static double getEliteRangedDamage(Projectile arrow) {
            Player player;
            double arrowSpeedMultiplier = Math.sqrt(Math.pow(arrow.getVelocity().getX(), 2.0) + Math.pow(arrow.getVelocity().getY(), 2.0) + Math.pow(arrow.getVelocity().getZ(), 2.0));
            arrowSpeedMultiplier /= 4.0;
            double itemArrowDamage = EliteItemManager.getArrowEliteDamage(arrow);
            ProjectileSource projectileSource = arrow.getShooter();
            if (projectileSource instanceof Player && !(player = (Player)projectileSource).hasMetadata("NPC")) {
                SkillType skillType;
                Material weaponType = player.getInventory().getItemInMainHand().getType();
                SkillType skillType2 = weaponType == Material.BOW ? SkillType.BOWS : (skillType = weaponType == Material.CROSSBOW ? SkillType.CROSSBOWS : null);
                if (skillType != null) {
                    long skillXP = PlayerData.getSkillXP(player.getUniqueId(), skillType);
                    int playerSkillLevel = SkillXPCalculator.levelFromTotalXP(skillXP);
                    double skillDamage = (double)playerSkillLevel * 1.6;
                    double effectiveDamage = skillDamage * 0.5 + itemArrowDamage * 0.5;
                    return arrowSpeedMultiplier * effectiveDamage;
                }
            }
            return arrowSpeedMultiplier * itemArrowDamage;
        }

        private static double getCustomDamageModifier(EliteEntity eliteEntity, Material itemStackType) {
            if (!(eliteEntity instanceof CustomBossEntity)) {
                return 1.0;
            }
            return ((CustomBossEntity)eliteEntity).getDamageModifier(itemStackType);
        }

        private static double secondaryEnchantmentDamageIncrease(Player player, LivingEntity livingEntity) {
            if (ItemSettingsConfig.isUseEliteEnchantments()) {
                return 0.0;
            }
            if (livingEntity instanceof Spider || livingEntity instanceof Silverfish) {
                int level = ElitePlayerInventory.playerInventories.get((Object)player.getUniqueId()).mainhand.getDamageArthropodsLevel(player.getInventory().getItemInMainHand(), false);
                if ((level -= Enchantment.BANE_OF_ARTHROPODS.getMaxLevel()) < 1) {
                    return 0.0;
                }
                return (double)level * 2.5;
            }
            if (livingEntity instanceof Zombie || livingEntity instanceof Skeleton || livingEntity instanceof Wither || livingEntity instanceof SkeletonHorse || livingEntity instanceof ZombieHorse || livingEntity.getType().equals((Object)EntityType.ZOMBIFIED_PIGLIN)) {
                int level = ElitePlayerInventory.playerInventories.get((Object)player.getUniqueId()).mainhand.getDamageUndeadLevel(player.getInventory().getItemInMainHand(), false);
                if ((level -= Enchantment.SMITE.getMaxLevel()) < 1) {
                    return 0.0;
                }
                return (double)level * 2.5;
            }
            return 0.0;
        }

        private static boolean isCriticalHit(Player player) {
            double criticalStrike = ElitePlayerInventory.playerInventories.get(player.getUniqueId()).getCritChance(false);
            return ThreadLocalRandom.current().nextDouble() < criticalStrike;
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerShootArrow(ProjectileLaunchEvent event) {
            if (!(event.getEntity().getShooter() instanceof Player)) {
                return;
            }
            EliteItemManager.tagArrow(event.getEntity());
        }

        @EventHandler(ignoreCancelled=true)
        public void onEliteMobAttacked(EntityDamageByEntityEvent event) {
            CustomBossEntity customBossEntity;
            boolean validPlayer;
            if (event.getEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && ((EnderDragon)event.getEntity()).getPhase().equals((Object)EnderDragon.Phase.DYING)) {
                return;
            }
            LivingEntity livingEntity = EntityFinder.filterRangedDamagers(event.getDamager());
            if (livingEntity == null) {
                return;
            }
            if (!livingEntity.getType().equals((Object)EntityType.PLAYER)) {
                return;
            }
            Player player = (Player)livingEntity;
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(event.getEntity());
            if (eliteEntity == null || !eliteEntity.isValid()) {
                return;
            }
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.PROJECTILE) && !(event.getDamager() instanceof Projectile)) {
                return;
            }
            for (EntityDamageEvent.DamageModifier modifier : EntityDamageEvent.DamageModifier.values()) {
                if (!event.isApplicable(modifier) || modifier == EntityDamageEvent.DamageModifier.BASE) continue;
                event.setDamage(modifier, 0.0);
            }
            double damage = event.getDamage();
            double eliteDamage = 0.0;
            boolean bl = validPlayer = !player.hasMetadata("NPC") && ElitePlayerInventory.getPlayer(player) != null;
            if (validPlayer && event.getCause().equals((Object)EntityDamageEvent.DamageCause.THORNS)) {
                eliteDamage = EliteMobDamagedByPlayerEventFilter.getThornsDamage(player);
            } else if (validPlayer && (event.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_ATTACK) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) && EliteItemManager.isEliteMobsItem(player.getInventory().getItemInMainHand()))) {
                eliteDamage = EliteMobDamagedByPlayerEventFilter.getEliteMeleeDamage(player, livingEntity);
            } else if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.PROJECTILE)) {
                eliteDamage = EliteMobDamagedByPlayerEventFilter.getEliteRangedDamage((Projectile)event.getDamager());
            }
            double damageModifier = 1.0;
            if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.PROJECTILE)) {
                damageModifier = CustomProjectileData.getCustomProjectileDataHashMap().get((Projectile)event.getDamager()) == null ? EliteMobDamagedByPlayerEventFilter.getCustomDamageModifier(eliteEntity, null) : EliteMobDamagedByPlayerEventFilter.getCustomDamageModifier(eliteEntity, CustomProjectileData.getCustomProjectileDataHashMap().get(event.getDamager()).getProjectileShooterMaterial());
            } else {
                EliteMobDamagedByPlayerEventFilter.getCustomDamageModifier(eliteEntity, player.getInventory().getItemInMainHand().getType());
            }
            damage = eliteEntity instanceof CustomBossEntity && (customBossEntity = (CustomBossEntity)eliteEntity).isNormalizedCombat() ? Round.twoDecimalPlaces((double)((damage + eliteDamage) * damageModifier * MobCombatSettingsConfig.getNormalizedDamageToEliteMultiplier())) : Round.twoDecimalPlaces((double)((damage + eliteDamage) * damageModifier * MobCombatSettingsConfig.getDamageToEliteMultiplier()));
            boolean criticalHit = false;
            if (validPlayer && (criticalHit = EliteMobDamagedByPlayerEventFilter.isCriticalHit(player))) {
                damage *= 1.5;
            }
            EliteMobDamagedByPlayerEvent eliteMobDamagedByPlayerEvent = new EliteMobDamagedByPlayerEvent(eliteEntity, player, event, damage, criticalHit, bypass, damageModifier);
            new EventCaller(eliteMobDamagedByPlayerEvent);
            if (eliteMobDamagedByPlayerEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            damage = eliteMobDamagedByPlayerEvent.getDamage();
            if (validPlayer) {
                eliteEntity.addDamager(player, damage);
            }
            if (eliteEntity.getLivingEntity() != null && eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && eliteEntity.getLivingEntity().getHealth() - damage < 1.0) {
                if (eliteEntity.isDying()) {
                    return;
                }
                damage = 0.0;
                event.setCancelled(true);
                ((EnderDragon)eliteEntity.getLivingEntity()).setPhase(EnderDragon.Phase.DYING);
                eliteEntity.setDying(true);
                Bukkit.getScheduler().runTaskLater((Plugin)MetadataHandler.PLUGIN, () -> new EventCaller(new EliteMobDeathEvent(eliteEntity)), 200L);
            }
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, damage);
            eliteEntity.syncPluginHealth(((LivingEntity)event.getEntity()).getHealth());
            this.runAntiexploit(eliteEntity, event, eliteMobDamagedByPlayerEvent);
        }

        private void runAntiexploit(EliteEntity eliteEntity, EntityDamageByEntityEvent event, EliteMobDamagedByPlayerEvent eliteMobDamagedByPlayerEvent) {
            Boolean regionQuery;
            if (EliteMobsWorld.isEliteMobsWorld(event.getDamager().getWorld().getUID())) {
                return;
            }
            if (EliteMobs.worldGuardIsEnabled && (regionQuery = WorldGuardFlagChecker.checkNullableFlag(eliteEntity.getLocation(), WorldGuardCompatibility.getELITEMOBS_ANTIEXPLOIT())) != null && !regionQuery.booleanValue()) {
                return;
            }
            if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK && event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
                return;
            }
            if (eliteEntity.isInAntiExploitCooldown() || eliteEntity.getLivingEntity() == null) {
                return;
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)new EliteMobDamagedByPlayerAntiExploitEvent(eliteEntity, eliteMobDamagedByPlayerEvent));
        }
    }
}

