/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.antiexploit;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.skills.CombatLevelCalculator;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class FarmingProtection {
    private static final int MAX_KILLS_PER_HOUR = 30;
    private static final int EARLY_CAP_KILLS = 10;
    private static final long EARLY_CAP_WINDOW_MS = 600000L;
    private static final long HOUR_MS = 3600000L;
    private static final int MAX_LEVEL_DIFFERENCE = 5;
    private static final Map<UUID, List<Long>> killTimestamps = new HashMap<UUID, List<Long>>();
    private static final Set<UUID> cappedPlayers = new HashSet<UUID>();
    private static final Map<UUID, Long> capExpiry = new HashMap<UUID, Long>();

    public static void shutdown() {
        killTimestamps.clear();
        cappedPlayers.clear();
        capExpiry.clear();
    }

    public static boolean recordNaturalEliteKill(Player player, EliteEntity eliteEntity) {
        if (eliteEntity instanceof CustomBossEntity) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (cappedPlayers.contains(uuid)) {
            Long expiry = capExpiry.get(uuid);
            if (expiry != null && now < expiry) {
                FarmingProtection.sendCapMessage(player, expiry - now);
                return false;
            }
            cappedPlayers.remove(uuid);
            capExpiry.remove(uuid);
            killTimestamps.remove(uuid);
        }
        List kills = killTimestamps.computeIfAbsent(uuid, k -> new ArrayList());
        kills.removeIf(timestamp -> now - timestamp > 3600000L);
        kills.add(now);
        long tenMinutesAgo = now - 600000L;
        long recentKills = kills.stream().filter(t -> t > tenMinutesAgo).count();
        if (recentKills >= 10L) {
            FarmingProtection.applyCap(player, now + 3600000L);
            return false;
        }
        if (kills.size() >= 30) {
            FarmingProtection.applyCap(player, now + 3600000L);
            return false;
        }
        return true;
    }

    private static void applyCap(final Player player, long expiryTime) {
        final UUID uuid = player.getUniqueId();
        cappedPlayers.add(uuid);
        capExpiry.put(uuid, expiryTime);
        player.sendMessage(ChatColorConverter.convert((String)("&c[EliteMobs] &7You've been farming natural elites too quickly! &7Take a break - rewards will resume in &f" + FarmingProtection.formatTime(expiryTime - System.currentTimeMillis()) + "&7.")));
        new BukkitRunnable(){

            public void run() {
                cappedPlayers.remove(uuid);
                capExpiry.remove(uuid);
                killTimestamps.remove(uuid);
                if (player.isOnline()) {
                    player.sendMessage(ChatColorConverter.convert((String)"&a[EliteMobs] &7Your natural elite kill limit has been reset!"));
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (expiryTime - System.currentTimeMillis()) / 50L);
    }

    private static void sendCapMessage(Player player, long remainingMs) {
        player.sendMessage(ChatColorConverter.convert((String)("&c[EliteMobs] &7You're temporarily capped from earning rewards from natural elites. &7Rewards resume in &f" + FarmingProtection.formatTime(remainingMs) + "&7.")));
    }

    private static String formatTime(long ms) {
        long minutes = ms / 1000L / 60L;
        long seconds = ms / 1000L % 60L;
        if (minutes > 0L) {
            return minutes + "m " + seconds + "s";
        }
        return seconds + "s";
    }

    public static boolean isPlayerCapped(Player player) {
        UUID uuid = player.getUniqueId();
        if (!cappedPlayers.contains(uuid)) {
            return false;
        }
        Long expiry = capExpiry.get(uuid);
        if (expiry == null || System.currentTimeMillis() >= expiry) {
            cappedPlayers.remove(uuid);
            capExpiry.remove(uuid);
            killTimestamps.remove(uuid);
            return false;
        }
        return true;
    }

    public static double getXPMultiplier(Player player, int mobLevel) {
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(player.getUniqueId());
        int levelDiff = mobLevel - combatLevel;
        if (levelDiff < -5) {
            return 0.0;
        }
        if (levelDiff <= 5) {
            return 1.0;
        }
        int cappedMobLevel = combatLevel + 5;
        return (double)cappedMobLevel / (double)mobLevel;
    }

    public static int getEffectiveMobLevelForXP(Player player, int mobLevel) {
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(player.getUniqueId());
        int maxLevel = combatLevel + 5;
        if (mobLevel > maxLevel) {
            return maxLevel;
        }
        return mobLevel;
    }

    public static boolean shouldDropLoot(Player player, int mobLevel) {
        int combatLevel = CombatLevelCalculator.calculateCombatLevel(player.getUniqueId());
        int levelDiff = mobLevel - combatLevel;
        return levelDiff >= -5;
    }

    public static int getCurrentHourlyKills(Player player) {
        List<Long> kills = killTimestamps.get(player.getUniqueId());
        if (kills == null) {
            return 0;
        }
        long now = System.currentTimeMillis();
        kills.removeIf(timestamp -> now - timestamp > 3600000L);
        return kills.size();
    }
}

