/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7_spigot.packets;

import com.google.common.collect.Sets;
import com.magmaguy.easyminecraftgoals.internal.PacketEntityInterface;
import com.magmaguy.easyminecraftgoals.v1_21_R7_spigot.CraftBukkitBridge;
import com.magmaguy.easyminecraftgoals.v1_21_R7_spigot.packets.PacketBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractPacketEntity<T extends cgk>
implements PacketEntityInterface {
    protected final T entity;
    private final Set<UUID> viewers = Sets.newConcurrentHashSet();
    private final List<Runnable> removeCallbacks = new LinkedList<Runnable>();
    protected boolean visible = true;
    private final int EntityID;

    protected AbstractPacketEntity(Location location) {
        this.entity = this.createEntity(location);
        this.EntityID = this.entity.aA();
    }

    public List<Player> getViewersAsPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected abstract T createEntity(Location var1);

    public void addViewer(UUID player) {
        this.viewers.add(player);
    }

    public void removeViewer(UUID player) {
        this.viewers.remove(player);
    }

    public void addRemoveCallback(Runnable callback) {
        this.removeCallbacks.add(callback);
    }

    protected dwo getNMSLevel(Location location) {
        return CraftBukkitBridge.getServerLevel(location);
    }

    public T getNMSEntity() {
        return this.entity;
    }

    public <B extends Entity> B getBukkitEntity() {
        return (B)CraftBukkitBridge.getBukkitEntity(this.entity);
    }

    public Location getLocation() {
        return new Location(CraftBukkitBridge.getBukkitWorld(this.entity.ao()), this.entity.dP(), this.entity.dR(), this.entity.dV(), this.entity.ec(), this.entity.ee());
    }

    public UUID getUniqueId() {
        return this.entity.cY();
    }

    protected aay<?> createEntityDataPacket() {
        List dataValues = this.entity.aD().c();
        if (dataValues == null) {
            return null;
        }
        return new agp(this.EntityID, dataValues);
    }

    public aay<?> generateRemovePacket() {
        return new afv(new int[]{this.EntityID});
    }

    public void remove() {
        this.sendPacketToAll(this.generateRemovePacket());
        this.removeCallbacks.forEach(Runnable::run);
    }

    public aay<?> generateSetVisiblePacket(boolean visible) {
        this.visible = visible;
        if (visible) {
            return this.createEntityDataPacket();
        }
        return new afv(new int[]{this.EntityID});
    }

    public void setVisible(boolean visible) {
        this.sendPacketToAll(this.generateSetVisiblePacket(visible));
    }

    public void hideFrom(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            this.removeViewer(uuid);
            return;
        }
        this.sendPacketToPlayer(player, new aay[]{new afv(new int[]{this.EntityID})});
        this.removeViewer(uuid);
    }

    public void displayTo(Player player) {
        if (this.viewers.contains(player.getUniqueId())) {
            return;
        }
        this.addViewer(player.getUniqueId());
        this.sendPacketToPlayer(player, new aay[]{new adc(this.EntityID, this.entity.cY(), this.entity.dP(), this.entity.dR(), this.entity.dV(), this.entity.ee(), this.entity.ec(), this.entity.ay(), 0, new ftm(0.0, 0.0, 0.0), 0.0), this.createEntityDataPacket()});
    }

    public void teleport(Location location) {
        this.entity.b(location.getX(), location.getY(), location.getZ());
        this.sendTeleportPacket();
    }

    protected void sendTeleportPacket() {
        this.sendPacketToAll(this.generateTeleportPacket());
    }

    protected aay<?> generateTeleportPacket() {
        return new aho(this.EntityID, new chy(this.entity.dI(), new ftm(0.0, 0.0, 0.0), this.entity.ec(), this.entity.ee()), new HashSet(), true);
    }

    public aay<?> generateMovePacket(Location location) {
        if (this.viewers.isEmpty()) {
            return null;
        }
        this.entity.a_(location.getX(), location.getY(), location.getZ());
        this.entity.v(location.getYaw());
        this.entity.w(location.getPitch());
        return this.generateTeleportPacket();
    }

    public void move(Location location) {
        this.sendPacketToAll(this.generateMovePacket(location));
    }

    protected void sendPacketToPlayer(Player player, aay<?> ... nmsPackets) {
        axg nmsPlayer = CraftBukkitBridge.getServerPlayer(player);
        for (aay<?> nmsPacket : nmsPackets) {
            if (nmsPacket == null) continue;
            nmsPlayer.g.b(nmsPacket);
        }
    }

    protected void sendPacketToAll(aay<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) {
                this.viewers.remove(viewer);
                continue;
            }
            this.sendPacketToPlayer(player, nmsPacket);
        }
    }

    @Deprecated
    protected void sendPacket(Player player, aay<?> ... nmsPackets) {
        this.sendPacketToPlayer(player, nmsPackets);
    }

    @Deprecated
    protected void sendPacket(aay<?> nmsPacket) {
        this.sendPacketToAll(nmsPacket);
    }

    public PacketBundle createPacketBundle() {
        return new PacketBundle();
    }

    protected axg getNMSPlayer(Player bukkitPlayer) {
        return CraftBukkitBridge.getServerPlayer(bukkitPlayer);
    }
}

