/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7_paper.wanderbacktopoint;

import com.magmaguy.easyminecraftgoals.events.WanderBackToPointEndEvent;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointStartEvent;
import com.magmaguy.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.easyminecraftgoals.utils.Utils;
import java.util.EnumSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class WanderBackToPointGoal
extends Goal
implements AbstractWanderBackToPoint {
    private final double maximumDistanceFromPoint;
    private final LivingEntity livingEntity;
    private final PathfinderMob pathfinderMob;
    private final Mob mob;
    Location returnLocation;
    private int priority;
    private Path path = null;
    private long lastTime;
    private float speed;
    private int stopReturnDistance = 0;
    private int goalRefreshCooldownTicks = 60;
    private int maxDurationTicks = 100;
    private boolean hardObjective = false;
    private boolean teleportOnFail = false;
    private boolean startWithCooldown = false;

    public WanderBackToPointGoal(Mob mob, LivingEntity livingEntity, PathfinderMob pathfinderMob, Location location, double maximumDistanceFromPoint, int priority, int maxDurationTicks) {
        this.mob = mob;
        this.livingEntity = livingEntity;
        this.pathfinderMob = pathfinderMob;
        this.returnLocation = location;
        this.priority = priority;
        this.maxDurationTicks = maxDurationTicks;
        this.speed = (float)livingEntity.getAttribute(Attribute.MOVEMENT_SPEED).getValue();
        this.maximumDistanceFromPoint = maximumDistanceFromPoint;
        this.lastTime = 0L;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public void start() {
        this.pathfinderMob.getNavigation().moveTo(this.path, (double)this.speed);
    }

    public void tick() {
    }

    public void stop() {
        if (this.pathfinderMob != null) {
            this.pathfinderMob.getNavigation().stop();
            this.path = null;
        }
        if (this.hardObjective && (this.pathfinderMob == null || this.pathfinderMob.isPathFinding())) {
            this.livingEntity.teleport(this.returnLocation);
        }
        WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
        this.updateCooldown();
    }

    public boolean canUse() {
        if (!this.hardObjective && this.mob.getTarget() instanceof Player) {
            this.updateCooldown();
            return false;
        }
        if (this.lastTime + 50L * (long)this.goalRefreshCooldownTicks - System.currentTimeMillis() > 0L) {
            return false;
        }
        this.updateCooldown();
        if (Utils.distanceShorterThan((Vector)this.returnLocation.toVector(), (Vector)this.livingEntity.getLocation().toVector(), (double)this.maximumDistanceFromPoint)) {
            return false;
        }
        if (this.pathfinderMob != null) {
            this.path = this.pathfinderMob.getNavigation().createPath(this.returnLocation.getX(), this.returnLocation.getY(), this.returnLocation.getZ(), this.stopReturnDistance);
            if (this.path == null) {
                return false;
            }
        }
        WanderBackToPointStartEvent wanderBackToPointStartEvent = new WanderBackToPointStartEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointStartEvent);
        if (wanderBackToPointStartEvent.isCancelled()) {
            return false;
        }
        if (this.teleportOnFail && (this.pathfinderMob == null || !this.path.canReach())) {
            this.earlyPathfindingTermination();
            return false;
        }
        return true;
    }

    private void earlyPathfindingTermination() {
        this.livingEntity.teleport(this.returnLocation);
        WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
    }

    public boolean canContinueToUse() {
        if (this.lastTime + 50L * (long)this.maxDurationTicks - System.currentTimeMillis() < 0L) {
            return false;
        }
        if (!this.hardObjective && this.mob.getTarget() instanceof Player) {
            return false;
        }
        return !this.pathfinderMob.getNavigation().isDone();
    }

    public boolean isInterruptable() {
        return !this.hardObjective;
    }

    public double getMaximumDistanceFromPoint() {
        return this.maximumDistanceFromPoint;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMaxDurationTicks() {
        return this.maxDurationTicks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public AbstractWanderBackToPoint setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public Location getReturnLocation() {
        return this.returnLocation;
    }

    public int getStopReturnDistance() {
        return this.stopReturnDistance;
    }

    public AbstractWanderBackToPoint setStopReturnDistance(int distance) {
        this.stopReturnDistance = distance;
        return this;
    }

    public int getGoalRefreshCooldownTicks() {
        return this.goalRefreshCooldownTicks;
    }

    public AbstractWanderBackToPoint setGoalRefreshCooldownTicks(int ticks) {
        this.goalRefreshCooldownTicks = ticks;
        return this;
    }

    public boolean isHardObjective() {
        return this.hardObjective;
    }

    public AbstractWanderBackToPoint setHardObjective(boolean hardObjective) {
        this.priority = -1;
        this.hardObjective = hardObjective;
        return this;
    }

    public boolean isTeleportOnFail() {
        return this.teleportOnFail;
    }

    public AbstractWanderBackToPoint setTeleportOnFail(boolean teleportOnFail) {
        this.teleportOnFail = teleportOnFail;
        return this;
    }

    public boolean isStartWithCooldown() {
        return this.startWithCooldown;
    }

    public AbstractWanderBackToPoint setStartWithCooldown(boolean startWithCooldown) {
        this.startWithCooldown = startWithCooldown;
        return this;
    }

    public void updateCooldown() {
        this.lastTime = System.currentTimeMillis();
    }

    public void register() {
        if (this.startWithCooldown) {
            this.updateCooldown();
        }
        this.mob.goalSelector.addGoal(this.priority, (Goal)this);
    }

    public void unregister() {
        this.mob.goalSelector.removeGoal((Goal)this);
    }
}

