/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7_common.packets;

import com.google.common.collect.Sets;
import com.magmaguy.easyminecraftgoals.internal.PacketEntityInterface;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.CraftBukkitBridge;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.packets.PacketBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractPacketEntity<T extends net.minecraft.world.entity.Entity>
implements PacketEntityInterface {
    protected final T entity;
    private final Set<UUID> viewers = Sets.newConcurrentHashSet();
    private final List<Runnable> removeCallbacks = new LinkedList<Runnable>();
    protected boolean visible = true;
    private final int EntityID;

    protected AbstractPacketEntity(Location location) {
        this.entity = this.createEntity(location);
        this.EntityID = this.entity.getId();
    }

    public List<Player> getViewersAsPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected abstract T createEntity(Location var1);

    public void addViewer(UUID player) {
        this.viewers.add(player);
    }

    public void removeViewer(UUID player) {
        this.viewers.remove(player);
    }

    public void addRemoveCallback(Runnable callback) {
        this.removeCallbacks.add(callback);
    }

    protected Level getNMSLevel(Location location) {
        return CraftBukkitBridge.getServerLevel(location);
    }

    public T getNMSEntity() {
        return this.entity;
    }

    public <B extends Entity> B getBukkitEntity() {
        return (B)CraftBukkitBridge.getBukkitEntity(this.entity);
    }

    public Location getLocation() {
        return new Location(CraftBukkitBridge.getBukkitWorld(this.entity.level()), this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getYRot(), this.entity.getXRot());
    }

    public UUID getUniqueId() {
        return this.entity.getUUID();
    }

    protected Packet<?> createEntityDataPacket() {
        List dataValues = this.entity.getEntityData().getNonDefaultValues();
        if (dataValues == null) {
            return null;
        }
        return new ClientboundSetEntityDataPacket(this.EntityID, dataValues);
    }

    public Packet<?> generateRemovePacket() {
        return new ClientboundRemoveEntitiesPacket(new int[]{this.EntityID});
    }

    public void remove() {
        this.sendPacketToAll(this.generateRemovePacket());
        this.removeCallbacks.forEach(Runnable::run);
    }

    public Packet<?> generateSetVisiblePacket(boolean visible) {
        this.visible = visible;
        if (visible) {
            return this.createEntityDataPacket();
        }
        return new ClientboundRemoveEntitiesPacket(new int[]{this.EntityID});
    }

    public void setVisible(boolean visible) {
        this.sendPacketToAll(this.generateSetVisiblePacket(visible));
    }

    public void hideFrom(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            this.removeViewer(uuid);
            return;
        }
        this.sendPacketToPlayer(player, new Packet[]{new ClientboundRemoveEntitiesPacket(new int[]{this.EntityID})});
        this.removeViewer(uuid);
    }

    public void displayTo(Player player) {
        if (this.viewers.contains(player.getUniqueId())) {
            return;
        }
        this.addViewer(player.getUniqueId());
        this.sendPacketToPlayer(player, new Packet[]{new ClientboundAddEntityPacket(this.EntityID, this.entity.getUUID(), this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getXRot(), this.entity.getYRot(), this.entity.getType(), 0, new Vec3(0.0, 0.0, 0.0), 0.0), this.createEntityDataPacket()});
    }

    public void teleport(Location location) {
        this.entity.teleportTo(location.getX(), location.getY(), location.getZ());
        this.sendTeleportPacket();
    }

    protected void sendTeleportPacket() {
        this.sendPacketToAll(this.generateTeleportPacket());
    }

    protected Packet<?> generateTeleportPacket() {
        return new ClientboundTeleportEntityPacket(this.EntityID, new PositionMoveRotation(this.entity.position(), new Vec3(0.0, 0.0, 0.0), this.entity.getYRot(), this.entity.getXRot()), new HashSet(), true);
    }

    public Packet<?> generateMovePacket(Location location) {
        if (this.viewers.isEmpty()) {
            return null;
        }
        this.entity.setPos(location.getX(), location.getY(), location.getZ());
        this.entity.setYRot(location.getYaw());
        this.entity.setXRot(location.getPitch());
        return this.generateTeleportPacket();
    }

    public void move(Location location) {
        this.sendPacketToAll(this.generateMovePacket(location));
    }

    protected void sendPacketToPlayer(Player player, Packet<?> ... nmsPackets) {
        ServerPlayer nmsPlayer = CraftBukkitBridge.getServerPlayer(player);
        for (Packet<?> nmsPacket : nmsPackets) {
            if (nmsPacket == null) continue;
            nmsPlayer.connection.send(nmsPacket);
        }
    }

    protected void sendPacketToAll(Packet<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) {
                this.viewers.remove(viewer);
                continue;
            }
            this.sendPacketToPlayer(player, nmsPacket);
        }
    }

    @Deprecated
    protected void sendPacket(Player player, Packet<?> ... nmsPackets) {
        this.sendPacketToPlayer(player, nmsPackets);
    }

    @Deprecated
    protected void sendPacket(Packet<?> nmsPacket) {
        this.sendPacketToAll(nmsPacket);
    }

    public PacketBundle createPacketBundle() {
        return new PacketBundle();
    }

    protected ServerPlayer getNMSPlayer(Player bukkitPlayer) {
        return CraftBukkitBridge.getServerPlayer(bukkitPlayer);
    }
}

