/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7_common;

import com.magmaguy.easyminecraftgoals.constants.OverridableWanderPriority;
import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.easyminecraftgoals.internal.PacketModelEntity;
import com.magmaguy.easyminecraftgoals.internal.PacketTextEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.CraftBukkitBridge;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.entitydata.BodyRotation;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.hitbox.Hitbox;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.massblockedit.MassEditBlocks;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.move.Move;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.packets.PacketArmorStandEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.packets.PacketBundle;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.packets.PacketDisplayEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.wanderbacktopoint.WanderBackToPointBehavior;
import com.magmaguy.easyminecraftgoals.v1_21_R7_common.wanderbacktopoint.WanderBackToPointGoal;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class NMSAdapter
extends com.magmaguy.easyminecraftgoals.NMSAdapter {
    private PathfinderMob getPathfinderMob(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = CraftBukkitBridge.getNMSEntity(entity);
        if (nmsEntity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)nmsEntity;
            return pathfinderMob;
        }
        return null;
    }

    public PacketModelEntity createPacketArmorStandEntity(Location location) {
        return new PacketArmorStandEntity(location);
    }

    public PacketModelEntity createPacketDisplayEntity(Location location) {
        return new PacketDisplayEntity(location);
    }

    public PacketTextEntity createPacketTextArmorStandEntity(Location location) {
        return new PacketArmorStandEntity(location);
    }

    public boolean canReach(LivingEntity livingEntity, Location destination) {
        PathfinderMob pathfinderMob = this.getPathfinderMob((Entity)livingEntity);
        if (pathfinderMob == null) {
            return false;
        }
        return Move.canReach(pathfinderMob, destination);
    }

    public boolean setCustomHitbox(Entity entity, float width, float height, boolean fixed) {
        if (entity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsEntity = CraftBukkitBridge.getNMSEntity(entity);
        return Hitbox.setCustomHitbox(nmsEntity, width, height, fixed);
    }

    public float getBodyRotation(Entity entity) {
        net.minecraft.world.entity.Entity nmsEntity = CraftBukkitBridge.getNMSEntity(entity);
        return BodyRotation.getBodyRotation(nmsEntity);
    }

    public boolean move(LivingEntity livingEntity, double speedModifier, Location location) {
        PathfinderMob pm;
        net.minecraft.world.entity.LivingEntity nmsLivingEntity = CraftBukkitBridge.getNMSLivingEntity(livingEntity);
        PathfinderMob pathfinderMob = nmsLivingEntity instanceof PathfinderMob ? (pm = (PathfinderMob)nmsLivingEntity) : null;
        if (!(nmsLivingEntity instanceof Mob)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return false;
        }
        return Move.simpleMove(pathfinderMob, speedModifier, location);
    }

    public void doNotMove(LivingEntity livingEntity) {
        PathfinderMob pathfinderMob = this.getPathfinderMob((Entity)livingEntity);
        if (pathfinderMob == null) {
            return;
        }
        Move.doNotMove(pathfinderMob);
    }

    public boolean forcedMove(LivingEntity livingEntity, double speedModifier, Location location) {
        net.minecraft.world.entity.LivingEntity nmsLivingEntity = CraftBukkitBridge.getNMSLivingEntity(livingEntity);
        if (!(nmsLivingEntity instanceof Mob)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return false;
        }
        Mob mob = (Mob)nmsLivingEntity;
        return Move.forcedMove(mob, speedModifier, location);
    }

    public void universalMove(LivingEntity livingEntity, double speedModifier, Location location) {
        net.minecraft.world.entity.LivingEntity nmsLivingEntity = CraftBukkitBridge.getNMSLivingEntity(livingEntity);
        if (!(nmsLivingEntity instanceof Mob)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return;
        }
        Mob mob = (Mob)nmsLivingEntity;
        Move.universalMove(mob, speedModifier, location);
    }

    public AbstractWanderBackToPoint wanderBackToPoint(LivingEntity livingEntity, Location blockLocation, double maximumDistanceFromPoint, int maxDurationTicks, OverridableWanderPriority overridableWanderPriority) {
        PathfinderMob pm;
        net.minecraft.world.entity.LivingEntity nmsLivingEntity = CraftBukkitBridge.getNMSLivingEntity(livingEntity);
        PathfinderMob pathfinderMob = nmsLivingEntity instanceof PathfinderMob ? (pm = (PathfinderMob)nmsLivingEntity) : null;
        if (!(nmsLivingEntity instanceof Mob)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return null;
        }
        Mob mob = (Mob)nmsLivingEntity;
        if (overridableWanderPriority.brain) {
            return new WanderBackToPointBehavior(livingEntity, mob, blockLocation, maximumDistanceFromPoint, overridableWanderPriority.priority, maxDurationTicks);
        }
        return new WanderBackToPointGoal(mob, livingEntity, pathfinderMob, blockLocation, maximumDistanceFromPoint, overridableWanderPriority.priority, maxDurationTicks);
    }

    public void setBlockInNativeDataPalette(World world, int x, int y, int z, BlockData blockData, boolean applyPhysics) {
        MassEditBlocks.setBlockInNativeDataPalette(world, x, y, z, blockData, applyPhysics);
    }

    public AbstractPacketBundle createPacketBundle() {
        return new PacketBundle();
    }
}

