/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7;

import java.lang.reflect.Method;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CraftBukkitBridge {
    private static final boolean IS_PAPER = CraftBukkitBridge.detectPaper();
    private static final String CB_PACKAGE = IS_PAPER ? "org.bukkit.craftbukkit" : "org.bukkit.craftbukkit.v1_21_R7";
    private static Class<?> craftWorldClass;
    private static Class<?> craftPlayerClass;
    private static Class<?> craftEntityClass;
    private static Class<?> craftLivingEntityClass;
    private static Class<?> craftItemStackClass;
    private static Class<?> craftBlockDataClass;
    private static Method craftWorldGetHandle;
    private static Method craftPlayerGetHandle;
    private static Method craftEntityGetHandle;
    private static Method craftLivingEntityGetHandle;
    private static Method craftItemStackAsNMSCopy;
    private static Method craftBlockDataGetState;
    private static Method displayTeleportDurationMethod;

    private static boolean detectPaper() {
        try {
            Class.forName("io.papermc.paper.configuration.GlobalConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void initializeClasses() {
        try {
            craftWorldClass = Class.forName(CB_PACKAGE + ".CraftWorld");
            craftPlayerClass = Class.forName(CB_PACKAGE + ".entity.CraftPlayer");
            craftEntityClass = Class.forName(CB_PACKAGE + ".entity.CraftEntity");
            craftLivingEntityClass = Class.forName(CB_PACKAGE + ".entity.CraftLivingEntity");
            craftItemStackClass = Class.forName(CB_PACKAGE + ".inventory.CraftItemStack");
            craftBlockDataClass = Class.forName(CB_PACKAGE + ".block.data.CraftBlockData");
            craftWorldGetHandle = craftWorldClass.getMethod("getHandle", new Class[0]);
            craftPlayerGetHandle = craftPlayerClass.getMethod("getHandle", new Class[0]);
            craftEntityGetHandle = craftEntityClass.getMethod("getHandle", new Class[0]);
            craftLivingEntityGetHandle = craftLivingEntityClass.getMethod("getHandle", new Class[0]);
            craftItemStackAsNMSCopy = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            craftBlockDataGetState = craftBlockDataClass.getMethod("getState", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize CraftBukkit bridge for " + (IS_PAPER ? "Paper" : "Spigot"), e);
        }
    }

    public static boolean isPaper() {
        return IS_PAPER;
    }

    public static WorldServer getServerLevel(org.bukkit.World world) {
        try {
            return (WorldServer)craftWorldGetHandle.invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerLevel from World", e);
        }
    }

    public static WorldServer getServerLevel(Location location) {
        return CraftBukkitBridge.getServerLevel(location.getWorld());
    }

    public static EntityPlayer getServerPlayer(Player player) {
        try {
            return (EntityPlayer)craftPlayerGetHandle.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get ServerPlayer from Player", e);
        }
    }

    public static net.minecraft.world.entity.Entity getNMSEntity(Entity entity) {
        try {
            return (net.minecraft.world.entity.Entity)craftEntityGetHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get NMS Entity from Bukkit Entity", e);
        }
    }

    public static EntityLiving getNMSLivingEntity(LivingEntity entity) {
        try {
            return (EntityLiving)craftLivingEntityGetHandle.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get NMS LivingEntity from Bukkit LivingEntity", e);
        }
    }

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack itemStack) {
        try {
            return (net.minecraft.world.item.ItemStack)craftItemStackAsNMSCopy.invoke(null, itemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert ItemStack to NMS", e);
        }
    }

    public static IBlockData getBlockState(BlockData blockData) {
        try {
            return (IBlockData)craftBlockDataGetState.invoke((Object)blockData, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get BlockState from BlockData", e);
        }
    }

    public static org.bukkit.World getBukkitWorld(World level) {
        try {
            Method getWorld = level.getClass().getMethod("getWorld", new Class[0]);
            return (org.bukkit.World)getWorld.invoke((Object)level, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Bukkit World from Level", e);
        }
    }

    public static Entity getBukkitEntity(net.minecraft.world.entity.Entity nmsEntity) {
        try {
            Method getBukkitEntity = nmsEntity.getClass().getMethod("getBukkitEntity", new Class[0]);
            return (Entity)getBukkitEntity.invoke((Object)nmsEntity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Bukkit Entity from NMS Entity", e);
        }
    }

    public static void setDisplayTeleportDuration(Display display, int duration) {
        try {
            if (displayTeleportDurationMethod == null) {
                displayTeleportDurationMethod = CraftBukkitBridge.findDisplayTeleportDurationMethod();
            }
            displayTeleportDurationMethod.invoke((Object)display, duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Method findDisplayTeleportDurationMethod() throws NoSuchMethodException {
        String[] possibleNames;
        Class<Display> displayClass = Display.class;
        for (String name : possibleNames = new String[]{"setPosRotInterpolationDuration", "d", "e", "f", "g"}) {
            try {
                Method method = displayClass.getDeclaredMethod(name, Integer.TYPE);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new NoSuchMethodException("Could not find teleport duration method on Display class");
    }

    public static String getEntityDimensionsFieldName() {
        return "dimensions";
    }

    static {
        CraftBukkitBridge.initializeClasses();
        displayTeleportDurationMethod = null;
    }
}

