/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.v1_21_R7.CraftBukkitBridge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.entity.Player;

public class PacketBundle
implements AbstractPacketBundle {
    private final List<PacketBundleEntry> entries = new ArrayList<PacketBundleEntry>();
    private static final int MAX_PACKETS_PER_BUNDLE = 3000;

    public void addPacket(Object packet, List<Player> viewers) {
        this.entries.add(new PacketBundleEntry((aay)packet, viewers));
    }

    public void send() {
        HashMap<Player, List> playerPackets = new HashMap<Player, List>();
        for (PacketBundleEntry entry : this.entries) {
            if (entry.viewers().isEmpty() || !this.isClientGamePacket(entry.packet())) continue;
            aay<?> clientPacket = entry.packet();
            for (Player viewer : entry.viewers()) {
                playerPackets.computeIfAbsent(viewer, k -> new ArrayList()).add(clientPacket);
            }
        }
        playerPackets.forEach((player, packets) -> {
            if (packets.isEmpty() || player == null || !player.isOnline()) {
                return;
            }
            for (int i2 = 0; i2 < packets.size(); i2 += 3000) {
                int end = Math.min(i2 + 3000, packets.size());
                List chunk = packets.subList(i2, end);
                adm bundle = new adm(new HashSet(chunk));
                this.sendPacketBundle((Player)player, (aay<?>)bundle);
            }
        });
        int bundleCount = playerPackets.values().stream().mapToInt(packets -> (packets.size() + 3000 - 1) / 3000).sum();
    }

    private boolean isClientGamePacket(aay<?> packet) {
        return packet != null;
    }

    private void sendPacketBundle(Player player, aay<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        axg nmsPlayer = CraftBukkitBridge.getServerPlayer(player);
        nmsPlayer.g.b(nmsPacket);
    }

    private record PacketBundleEntry(aay<?> packet, List<Player> viewers) {
    }
}

