/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7;

import java.lang.reflect.Method;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CraftBukkitAdapter {
    private static final String CRAFTBUKKIT_PACKAGE;
    private static final boolean IS_PAPER;
    private static Method getHandleEntityMethod;
    private static Method getHandleLivingEntityMethod;
    private static Method getHandlePlayerMethod;
    private static Method getHandleWorldMethod;
    private static Method getStateMethod;
    private static Method asNMSCopyMethod;
    private static Method getWorldFromLevelMethod;

    private static void initializeMethods() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> craftEntityClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftEntity");
        Class<?> craftLivingEntityClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftLivingEntity");
        Class<?> craftPlayerClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftPlayer");
        Class<?> craftWorldClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".CraftWorld");
        Class<?> craftBlockDataClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".block.data.CraftBlockData");
        Class<?> craftItemStackClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".inventory.CraftItemStack");
        getHandleEntityMethod = craftEntityClass.getMethod("getHandle", new Class[0]);
        getHandleLivingEntityMethod = craftLivingEntityClass.getMethod("getHandle", new Class[0]);
        getHandlePlayerMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
        getHandleWorldMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
        getStateMethod = craftBlockDataClass.getMethod("getState", new Class[0]);
        asNMSCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
        getWorldFromLevelMethod = Level.class.getMethod("getWorld", new Class[0]);
    }

    public static net.minecraft.world.entity.Entity getHandle(Entity entity) {
        try {
            return (net.minecraft.world.entity.Entity)getHandleEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get entity handle", e);
        }
    }

    public static LivingEntity getHandle(org.bukkit.entity.LivingEntity entity) {
        try {
            return (LivingEntity)getHandleLivingEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get living entity handle", e);
        }
    }

    public static ServerPlayer getHandle(Player player) {
        try {
            return (ServerPlayer)getHandlePlayerMethod.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get player handle", e);
        }
    }

    public static ServerLevel getHandle(World world) {
        try {
            return (ServerLevel)getHandleWorldMethod.invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get world handle", e);
        }
    }

    public static World getWorld(Level level) {
        try {
            return (World)getWorldFromLevelMethod.invoke((Object)level, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get world from level", e);
        }
    }

    public static BlockState getState(BlockData blockData) {
        try {
            return (BlockState)getStateMethod.invoke((Object)blockData, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get block state", e);
        }
    }

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack itemStack) {
        try {
            return (net.minecraft.world.item.ItemStack)asNMSCopyMethod.invoke(null, itemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert ItemStack to NMS", e);
        }
    }

    public static String getCraftBukkitPackage() {
        return CRAFTBUKKIT_PACKAGE;
    }

    public static boolean isPaper() {
        return IS_PAPER;
    }

    static {
        Object cbPackage;
        boolean isPaper = false;
        try {
            Class.forName("org.bukkit.craftbukkit.entity.CraftEntity");
            cbPackage = "org.bukkit.craftbukkit";
            isPaper = true;
        }
        catch (ClassNotFoundException e) {
            String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            cbPackage = "org.bukkit.craftbukkit." + version;
        }
        CRAFTBUKKIT_PACKAGE = cbPackage;
        IS_PAPER = isPaper;
        try {
            CraftBukkitAdapter.initializeMethods();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize CraftBukkit adapter", e);
        }
    }
}

