/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R7;

import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CraftBukkitAdapter {
    private static final String CRAFTBUKKIT_PACKAGE;
    private static final boolean IS_PAPER;
    private static Class<?> craftEntityClass;
    private static Class<?> craftLivingEntityClass;
    private static Class<?> craftPlayerClass;
    private static Class<?> craftWorldClass;
    private static Class<?> craftBlockDataClass;
    private static Class<?> craftItemStackClass;
    private static Method getHandleEntityMethod;
    private static Method getHandleLivingEntityMethod;
    private static Method getHandlePlayerMethod;
    private static Method getHandleWorldMethod;
    private static Method getStateMethod;
    private static Method asNMSCopyMethod;

    private static void initializeClasses() throws ClassNotFoundException {
        craftEntityClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftEntity");
        craftLivingEntityClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftLivingEntity");
        craftPlayerClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".entity.CraftPlayer");
        craftWorldClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".CraftWorld");
        craftBlockDataClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".block.data.CraftBlockData");
        craftItemStackClass = Class.forName(CRAFTBUKKIT_PACKAGE + ".inventory.CraftItemStack");
    }

    private static void initializeMethods() throws NoSuchMethodException {
        getHandleEntityMethod = craftEntityClass.getMethod("getHandle", new Class[0]);
        getHandleLivingEntityMethod = craftLivingEntityClass.getMethod("getHandle", new Class[0]);
        getHandlePlayerMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
        getHandleWorldMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
        getStateMethod = craftBlockDataClass.getMethod("getState", new Class[0]);
        asNMSCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
    }

    public static cgk getHandle(Entity entity) {
        try {
            return (cgk)getHandleEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get entity handle", e);
        }
    }

    public static chl getHandle(LivingEntity entity) {
        try {
            return (chl)getHandleLivingEntityMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get living entity handle", e);
        }
    }

    public static axg getHandle(Player player) {
        try {
            return (axg)getHandlePlayerMethod.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get player handle", e);
        }
    }

    public static axf getHandle(World world) {
        try {
            return (axf)getHandleWorldMethod.invoke((Object)world, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get world handle", e);
        }
    }

    public static eoh getState(BlockData blockData) {
        try {
            return (eoh)getStateMethod.invoke((Object)blockData, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get block state", e);
        }
    }

    public static dlt asNMSCopy(ItemStack itemStack) {
        try {
            return (dlt)asNMSCopyMethod.invoke(null, itemStack);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert ItemStack to NMS", e);
        }
    }

    public static String getCraftBukkitPackage() {
        return CRAFTBUKKIT_PACKAGE;
    }

    public static boolean isPaper() {
        return IS_PAPER;
    }

    static {
        Object cbPackage;
        boolean isPaper = false;
        try {
            Class.forName("org.bukkit.craftbukkit.entity.CraftEntity");
            cbPackage = "org.bukkit.craftbukkit";
            isPaper = true;
        }
        catch (ClassNotFoundException e) {
            String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
            cbPackage = "org.bukkit.craftbukkit." + version;
        }
        CRAFTBUKKIT_PACKAGE = cbPackage;
        IS_PAPER = isPaper;
        try {
            CraftBukkitAdapter.initializeClasses();
            CraftBukkitAdapter.initializeMethods();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize CraftBukkit adapter", e);
        }
    }
}

