/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R5.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.internal.PacketModelEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R5.packets.AbstractPacketEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R5.packets.PacketBundle;
import com.mojang.math.Transformation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityType;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.util.EulerAngle;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDisplayEntity
extends AbstractPacketEntity<Display.ItemDisplay>
implements PacketModelEntity {
    private ItemStack carrierItem;
    private net.minecraft.world.item.ItemStack nmsCarrierItem;
    private Display.ItemDisplay itemDisplay;

    public PacketDisplayEntity(Location location) {
        super(location);
    }

    private static Quaternionf eulerToQuaternion(double originalX, double originalY, double originalZ) {
        double yaw = Math.toRadians(originalZ);
        double pitch = Math.toRadians(originalY);
        double roll = Math.toRadians(originalX);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        double w = cr * cp * cy + sr * sp * sy;
        double x = sr * cp * cy - cr * sp * sy;
        double y = cr * sp * cy + sr * cp * sy;
        double z = cr * cp * sy - sr * sp * cy;
        return new Quaternionf(x, y, z, w);
    }

    @Override
    protected Display.ItemDisplay createEntity(Location location) {
        return new Display.ItemDisplay(EntityType.ITEM_DISPLAY, this.getNMSLevel(location));
    }

    public void initializeModel(Location location, String modelID) {
        this.itemDisplay = (Display.ItemDisplay)this.entity;
        this.itemDisplay.setTransformationInterpolationDelay(-1);
        this.itemDisplay.setTransformationInterpolationDuration(0);
        try {
            Method setPosRotInterpolationDuration = Display.class.getDeclaredMethod("setPosRotInterpolationDuration", Integer.TYPE);
            setPosRotInterpolationDuration.setAccessible(true);
            setPosRotInterpolationDuration.invoke((Object)this.itemDisplay, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.carrierItem = new ItemStack(Material.LEATHER_HORSE_ARMOR);
        ItemMeta meta = this.carrierItem.getItemMeta();
        meta.setItemModel(NamespacedKey.fromString((String)modelID));
        CustomModelDataComponent cmd = meta.getCustomModelDataComponent();
        cmd.setColors(List.of(Color.WHITE));
        meta.setCustomModelDataComponent(cmd);
        this.carrierItem.setItemMeta(meta);
        this.nmsCarrierItem = CraftItemStack.asNMSCopy((ItemStack)this.carrierItem);
        this.itemDisplay.setItemStack(this.nmsCarrierItem);
        this.itemDisplay.setWidth(0.0f);
        this.itemDisplay.setHeight(0.0f);
        this.itemDisplay.setViewRange(30.0f);
    }

    public void setHorseLeatherArmorColor(Color color) {
        if (this.carrierItem == null) {
            return;
        }
        ItemMeta meta = this.carrierItem.getItemMeta();
        CustomModelDataComponent cmd = meta.getCustomModelDataComponent();
        cmd.setColors(List.of(color));
        meta.setCustomModelDataComponent(cmd);
        this.carrierItem.setItemMeta(meta);
        this.nmsCarrierItem = CraftItemStack.asNMSCopy((ItemStack)this.carrierItem);
        this.itemDisplay.setItemStack(this.nmsCarrierItem);
    }

    public void sendLocationAndRotationPacket(Location location, EulerAngle eulerAngle) {
        this.move(location);
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        this.rotate(quaternionf);
        this.sendPacketToAll(this.createEntityDataPacket());
    }

    public void sendLocationAndRotationAndScalePacket(Location location, EulerAngle eulerAngle, float scale) {
        this.generateLocationAndRotationAndScalePackets(new PacketBundle(), location, eulerAngle, scale).send();
    }

    public void sendLocationAndRotationAndScalePacket(Location location, EulerAngle eulerAngle, float scaleX, float scaleY, float scaleZ) {
        this.generateLocationAndRotationAndScalePackets(new PacketBundle(), location, eulerAngle, scaleX, scaleY, scaleZ).send();
    }

    public AbstractPacketBundle generateLocationAndRotationAndScalePackets(AbstractPacketBundle packetBundle, Location location, EulerAngle eulerAngle, float scale) {
        return this.generateLocationAndRotationAndScalePackets(packetBundle, location, eulerAngle, scale, scale, scale);
    }

    public AbstractPacketBundle generateLocationAndRotationAndScalePackets(AbstractPacketBundle packetBundle, Location location, EulerAngle eulerAngle, float scaleX, float scaleY, float scaleZ) {
        if (!this.getLocation().getWorld().equals((Object)location.getWorld())) {
            packetBundle.addPacket(this.generateMovePacket(location), this.getViewersAsPlayers());
        } else {
            packetBundle.addPacket(this.generateMovePacket(location), this.getViewersAsPlayers());
        }
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        Transformation transformation = this.getTransformation();
        transformation = new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), quaternionf, new Vector3f(scaleX, scaleY, scaleZ), transformation.getRightRotation());
        ((Display.ItemDisplay)this.entity).setTransformation(transformation);
        packetBundle.addPacket(this.createEntityDataPacket(), this.getViewersAsPlayers());
        return packetBundle;
    }

    @Override
    public void displayTo(Player player) {
        super.displayTo(player);
    }

    public void displayTo(UUID player) {
        this.displayTo(Bukkit.getPlayer((UUID)player));
    }

    @Override
    public void addViewer(UUID player) {
        super.addViewer(player);
        this.displayTo(player);
    }

    public Vector3f getScale() {
        return this.getTransformation().getScale();
    }

    public void setScale(float scale) {
        this.setScale(new Vector3f(scale, scale, scale));
    }

    public void setScale(Vector3f scale) {
        Transformation transformation = this.getTransformation();
        Transformation newTransformation = new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), scale, transformation.getRightRotation());
        this.setTransformation(newTransformation);
    }

    public Vector3f getTranslation() {
        return this.getTransformation().getTranslation();
    }

    public void setTranslation(Vector3f translation) {
        Transformation transformation = this.getTransformation();
        Transformation newTransformation = new Transformation(translation, transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getLeftRotation() {
        return this.getTransformation().getLeftRotation();
    }

    public void setLeftRotation(Quaternionf rotation) {
        Transformation transformation = this.getTransformation();
        Transformation newTransformation = new Transformation(transformation.getTranslation(), rotation, transformation.getScale(), transformation.getRightRotation());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getRightRotation() {
        return this.getTransformation().getRightRotation();
    }

    public void setRightRotation(Quaternionf rotation) {
        Transformation transformation = this.getTransformation();
        Transformation newTransformation = new Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), rotation);
        this.setTransformation(newTransformation);
    }

    public Transformation getTransformation() {
        Transformation nms = Display.createTransformation((SynchedEntityData)((Display.ItemDisplay)this.entity).getEntityData());
        return new Transformation(nms.getTranslation(), nms.getLeftRotation(), nms.getScale(), nms.getRightRotation());
    }

    private void setTransformation(Transformation transformation) {
        ((Display.ItemDisplay)this.entity).setTransformation(transformation);
    }

    private void rotate(Quaternionf rotation) {
        if (rotation == null) {
            return;
        }
        this.setLeftRotation(rotation);
    }
}

