/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R5.packets;

import com.google.common.collect.Sets;
import com.magmaguy.easyminecraftgoals.internal.PacketEntityInterface;
import com.magmaguy.easyminecraftgoals.v1_21_R5.packets.PacketBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractPacketEntity<T extends bzm>
implements PacketEntityInterface {
    protected final T entity;
    private final Set<UUID> viewers = Sets.newConcurrentHashSet();
    private final List<Runnable> removeCallbacks = new LinkedList<Runnable>();
    protected boolean visible = true;
    private final int EntityID;

    protected AbstractPacketEntity(Location location) {
        this.entity = this.createEntity(location);
        this.EntityID = this.entity.ar();
    }

    public List<Player> getViewersAsPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected abstract T createEntity(Location var1);

    public void addViewer(UUID player) {
        this.viewers.add(player);
    }

    public void removeViewer(UUID player) {
        this.viewers.remove(player);
    }

    public void addRemoveCallback(Runnable callback) {
        this.removeCallbacks.add(callback);
    }

    protected dmu getNMSLevel(Location location) {
        return ((CraftWorld)location.getWorld()).getHandle();
    }

    public T getNMSEntity() {
        return this.entity;
    }

    public <B extends Entity> B getBukkitEntity() {
        return (B)this.entity.getBukkitEntity();
    }

    public Location getLocation() {
        return new Location((World)this.entity.ai().getWorld(), this.entity.dC(), this.entity.dE(), this.entity.dI(), this.entity.dP(), this.entity.dR());
    }

    public UUID getUniqueId() {
        return this.entity.cK();
    }

    protected zw<?> createEntityDataPacket() {
        List dataValues = this.entity.au().c();
        if (dataValues == null) {
            return null;
        }
        return new afz(this.EntityID, dataValues);
    }

    public zw<?> generateRemovePacket() {
        return new aff(new int[]{this.EntityID});
    }

    public void remove() {
        this.sendPacketToAll(this.generateRemovePacket());
        this.removeCallbacks.forEach(Runnable::run);
    }

    public zw<?> generateSetVisiblePacket(boolean visible) {
        this.visible = visible;
        if (visible) {
            return this.createEntityDataPacket();
        }
        return new aff(new int[]{this.EntityID});
    }

    public void setVisible(boolean visible) {
        this.sendPacketToAll(this.generateSetVisiblePacket(visible));
    }

    public void hideFrom(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            this.removeViewer(uuid);
            return;
        }
        this.sendPacketToPlayer(player, new zw[]{new aff(new int[]{this.EntityID})});
        this.removeViewer(uuid);
    }

    public void displayTo(Player player) {
        if (this.viewers.contains(player.getUniqueId())) {
            return;
        }
        this.addViewer(player.getUniqueId());
        this.sendPacketToPlayer(player, new zw[]{new acr(this.EntityID, this.entity.cK(), this.entity.dC(), this.entity.dE(), this.entity.dI(), this.entity.dR(), this.entity.dP(), this.entity.ap(), 0, new fis(0.0, 0.0, 0.0), 0.0), this.createEntityDataPacket()});
    }

    public void teleport(Location location) {
        this.entity.b(location.getX(), location.getY(), location.getZ());
        this.sendTeleportPacket();
    }

    protected void sendTeleportPacket() {
        this.sendPacketToAll(this.generateTeleportPacket());
    }

    protected zw<?> generateTeleportPacket() {
        return new agy(this.EntityID, new caz(this.entity.dv(), new fis(0.0, 0.0, 0.0), this.entity.dP(), this.entity.dR()), new HashSet(), true);
    }

    public zw<?> generateMovePacket(Location location) {
        if (this.viewers.isEmpty()) {
            return null;
        }
        this.entity.a_(location.getX(), location.getY(), location.getZ());
        this.entity.v(location.getYaw());
        this.entity.w(location.getPitch());
        return this.generateTeleportPacket();
    }

    public void move(Location location) {
        this.sendPacketToAll(this.generateMovePacket(location));
    }

    protected void sendPacketToPlayer(Player player, zw<?> ... nmsPackets) {
        auc nmsPlayer = this.getNMSPlayer(player);
        for (zw<?> nmsPacket : nmsPackets) {
            if (nmsPacket == null) continue;
            nmsPlayer.g.b(nmsPacket);
        }
    }

    protected void sendPacketToAll(zw<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) {
                this.viewers.remove(viewer);
                continue;
            }
            this.sendPacketToPlayer(player, nmsPacket);
        }
    }

    @Deprecated
    protected void sendPacket(Player player, zw<?> ... nmsPackets) {
        this.sendPacketToPlayer(player, nmsPackets);
    }

    @Deprecated
    protected void sendPacket(zw<?> nmsPacket) {
        this.sendPacketToAll(nmsPacket);
    }

    public PacketBundle createPacketBundle() {
        return new PacketBundle();
    }

    protected auc getNMSPlayer(Player bukkitPlayer) {
        return ((CraftPlayer)bukkitPlayer).getHandle();
    }
}

