/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_21_R4.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.internal.PacketModelEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R4.packets.AbstractPacketEntity;
import com.magmaguy.easyminecraftgoals.v1_21_R4.packets.PacketBundle;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.util.EulerAngle;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDisplayEntity
extends AbstractPacketEntity<bxb.g>
implements PacketModelEntity {
    private ItemStack leatherHorseArmor;
    private dak nmsLeatherHorseArmor;
    private bxb.g itemDisplay;

    public PacketDisplayEntity(Location location) {
        super(location);
    }

    private static Quaternionf eulerToQuaternion(double originalX, double originalY, double originalZ) {
        double yaw = Math.toRadians(originalZ);
        double pitch = Math.toRadians(originalY);
        double roll = Math.toRadians(originalX);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        double w = cr * cp * cy + sr * sp * sy;
        double x = sr * cp * cy - cr * sp * sy;
        double y = cr * sp * cy + sr * cp * sy;
        double z = cr * cp * sy - sr * sp * cy;
        return new Quaternionf(x, y, z, w);
    }

    @Override
    protected bxb.g createEntity(Location location) {
        return new bxb.g(bxn.as, this.getNMSLevel(location));
    }

    public void initializeModel(Location location, String modelID) {
        this.itemDisplay = (bxb.g)this.entity;
        this.itemDisplay.c(-1);
        this.itemDisplay.b(0);
        try {
            bxb.g display = this.itemDisplay;
            Method setPosRotInterpolationDuration = bxb.class.getDeclaredMethod("d", Integer.TYPE);
            setPosRotInterpolationDuration.setAccessible(true);
            setPosRotInterpolationDuration.invoke((Object)display, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.leatherHorseArmor = new ItemStack(Material.LEATHER_HORSE_ARMOR);
        LeatherArmorMeta itemMeta = (LeatherArmorMeta)this.leatherHorseArmor.getItemMeta();
        itemMeta.setItemModel(NamespacedKey.fromString((String)modelID));
        itemMeta.setColor(Color.WHITE);
        this.leatherHorseArmor.setItemMeta((ItemMeta)itemMeta);
        this.nmsLeatherHorseArmor = CraftItemStack.asNMSCopy((ItemStack)this.leatherHorseArmor);
        this.itemDisplay.a(this.nmsLeatherHorseArmor);
        this.itemDisplay.y(0.0f);
        this.itemDisplay.z(0.0f);
        this.itemDisplay.b(30.0f);
    }

    public void setHorseLeatherArmorColor(Color color) {
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.leatherHorseArmor.getItemMeta();
        leatherArmorMeta.setColor(color);
        this.leatherHorseArmor.setItemMeta((ItemMeta)leatherArmorMeta);
        this.nmsLeatherHorseArmor = CraftItemStack.asNMSCopy((ItemStack)this.leatherHorseArmor);
        this.itemDisplay.a(this.nmsLeatherHorseArmor);
    }

    public void sendLocationAndRotationPacket(Location location, EulerAngle eulerAngle) {
        this.move(location);
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        this.rotate(quaternionf);
        this.sendPacketToAll(this.createEntityDataPacket());
    }

    public void sendLocationAndRotationAndScalePacket(Location location, EulerAngle eulerAngle, float scale) {
        this.generateLocationAndRotationAndScalePackets(new PacketBundle(), location, eulerAngle, scale).send();
    }

    public AbstractPacketBundle generateLocationAndRotationAndScalePackets(AbstractPacketBundle packetBundle, Location location, EulerAngle eulerAngle, float scale) {
        if (!this.getLocation().getWorld().equals((Object)location.getWorld())) {
            packetBundle.addPacket(this.generateMovePacket(location), this.getViewersAsPlayers());
        } else {
            Location currentLoc = this.getLocation();
            double distSq = currentLoc.distanceSquared(location);
            if (distSq > 0.01) {
                packetBundle.addPacket(this.generateMovePacket(location), this.getViewersAsPlayers());
            }
        }
        Quaternionf quaternionf = PacketDisplayEntity.eulerToQuaternion(Math.toDegrees(eulerAngle.getX()), Math.toDegrees(eulerAngle.getY()), Math.toDegrees(eulerAngle.getZ()));
        k transformation = this.getTransformation();
        transformation = new k(new Vector3f(0.0f, 0.0f, 0.0f), quaternionf, new Vector3f(scale, scale, scale), transformation.h());
        ((bxb.g)this.entity).a(transformation);
        packetBundle.addPacket(this.createEntityDataPacket(), this.getViewersAsPlayers());
        return packetBundle;
    }

    @Override
    public void displayTo(Player player) {
        super.displayTo(player);
    }

    public void displayTo(UUID player) {
        this.displayTo(Bukkit.getPlayer((UUID)player));
    }

    @Override
    public void addViewer(UUID player) {
        super.addViewer(player);
        this.displayTo(player);
    }

    public Vector3f getScale() {
        return this.getTransformation().g();
    }

    public void setScale(float scale) {
        this.setScale(new Vector3f(scale, scale, scale));
    }

    public void setScale(Vector3f scale) {
        k transformation = this.getTransformation();
        k newTransformation = new k(transformation.e(), transformation.f(), scale, transformation.h());
        this.setTransformation(newTransformation);
    }

    public Vector3f getTranslation() {
        return this.getTransformation().e();
    }

    public void setTranslation(Vector3f translation) {
        k transformation = this.getTransformation();
        k newTransformation = new k(translation, transformation.f(), transformation.g(), transformation.h());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getLeftRotation() {
        return this.getTransformation().f();
    }

    public void setLeftRotation(Quaternionf rotation) {
        k transformation = this.getTransformation();
        k newTransformation = new k(transformation.e(), rotation, transformation.g(), transformation.h());
        this.setTransformation(newTransformation);
    }

    public Quaternionf getRightRotation() {
        return this.getTransformation().h();
    }

    public void setRightRotation(Quaternionf rotation) {
        k transformation = this.getTransformation();
        k newTransformation = new k(transformation.e(), transformation.f(), transformation.g(), rotation);
        this.setTransformation(newTransformation);
    }

    public k getTransformation() {
        k nms = bxb.a((aky)((bxb.g)this.entity).ar());
        return new k(nms.e(), nms.f(), nms.g(), nms.h());
    }

    private void setTransformation(k transformation) {
        ((bxb.g)this.entity).a(transformation);
    }

    private void rotate(Quaternionf rotation) {
        if (rotation == null) {
            return;
        }
        this.setLeftRotation(rotation);
    }
}

