/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_20_R4;

import com.magmaguy.easyminecraftgoals.constants.OverridableWanderPriority;
import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import com.magmaguy.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.easyminecraftgoals.internal.PacketTextEntity;
import com.magmaguy.easyminecraftgoals.v1_20_R4.entitydata.BodyRotation;
import com.magmaguy.easyminecraftgoals.v1_20_R4.hitbox.Hitbox;
import com.magmaguy.easyminecraftgoals.v1_20_R4.massblockedit.MassEditBlocks;
import com.magmaguy.easyminecraftgoals.v1_20_R4.move.Move;
import com.magmaguy.easyminecraftgoals.v1_20_R4.packets.PacketArmorStandEntity;
import com.magmaguy.easyminecraftgoals.v1_20_R4.packets.PacketBundle;
import com.magmaguy.easyminecraftgoals.v1_20_R4.packets.PacketDisplayEntity;
import com.magmaguy.easyminecraftgoals.v1_20_R4.wanderbacktopoint.WanderBackToPointBehavior;
import com.magmaguy.easyminecraftgoals.v1_20_R4.wanderbacktopoint.WanderBackToPointGoal;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftLivingEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class NMSAdapter
extends com.magmaguy.easyminecraftgoals.NMSAdapter {
    private EntityCreature getPathfinderMob(Entity entity) {
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        if (entity2 instanceof EntityCreature) {
            EntityCreature pathfinderMob1 = (EntityCreature)entity2;
            return pathfinderMob1;
        }
        return null;
    }

    public PacketArmorStandEntity createPacketArmorStandEntity(Location location) {
        return new PacketArmorStandEntity(location);
    }

    public PacketDisplayEntity createPacketDisplayEntity(Location location) {
        return new PacketDisplayEntity(location);
    }

    public PacketTextEntity createPacketTextArmorStandEntity(Location location) {
        return new PacketArmorStandEntity(location);
    }

    public boolean canReach(LivingEntity livingEntity, Location destination) {
        EntityCreature pathfinderMob = this.getPathfinderMob((Entity)livingEntity);
        if (pathfinderMob == null) {
            return false;
        }
        return Move.canReach(pathfinderMob, destination);
    }

    public boolean setCustomHitbox(Entity entity, float width, float height, boolean fixed) {
        if (entity == null) {
            return false;
        }
        return Hitbox.setCustomHitbox(((CraftEntity)entity).getHandle(), width, height, fixed);
    }

    public float getBodyRotation(Entity entity) {
        return BodyRotation.getBodyRotation(((CraftEntity)entity).getHandle());
    }

    public boolean move(LivingEntity livingEntity, double speedModifier, Location location) {
        EntityCreature pathfinderMob1;
        EntityLiving entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        EntityCreature pathfinderMob = entityLiving instanceof EntityCreature ? (pathfinderMob1 = (EntityCreature)entityLiving) : null;
        entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(entityLiving instanceof EntityInsentient)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return false;
        }
        EntityInsentient mob = (EntityInsentient)entityLiving;
        return Move.simpleMove(pathfinderMob, speedModifier, location);
    }

    public void doNotMove(LivingEntity livingEntity) {
        EntityCreature pathfinderMob = this.getPathfinderMob((Entity)livingEntity);
        if (pathfinderMob == null) {
            return;
        }
        Move.doNotMove(pathfinderMob);
    }

    public boolean forcedMove(LivingEntity livingEntity, double speedModifier, Location location) {
        EntityLiving entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(entityLiving instanceof EntityInsentient)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return false;
        }
        EntityInsentient mob = (EntityInsentient)entityLiving;
        return Move.forcedMove(mob, speedModifier, location);
    }

    public void universalMove(LivingEntity livingEntity, double speedModifier, Location location) {
        EntityLiving entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(entityLiving instanceof EntityInsentient)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return;
        }
        EntityInsentient mob = (EntityInsentient)entityLiving;
        Move.universalMove(mob, speedModifier, location);
    }

    public AbstractWanderBackToPoint wanderBackToPoint(LivingEntity livingEntity, Location blockLocation, double maximumDistanceFromPoint, int maxDurationTicks, OverridableWanderPriority overridableWanderPriority) {
        EntityCreature pathfinderMob1;
        EntityLiving entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        EntityCreature pathfinderMob = entityLiving instanceof EntityCreature ? (pathfinderMob1 = (EntityCreature)entityLiving) : null;
        entityLiving = ((CraftLivingEntity)livingEntity).getHandle();
        if (!(entityLiving instanceof EntityInsentient)) {
            Bukkit.getLogger().info("[EasyMinecraftPathfinding] Entity type " + String.valueOf(livingEntity.getType()) + " does not extend Mob and is therefore unable to have goals! It will not be able to pathfind.");
            return null;
        }
        EntityInsentient mob = (EntityInsentient)entityLiving;
        if (overridableWanderPriority.brain) {
            return new WanderBackToPointBehavior(livingEntity, mob, blockLocation, maximumDistanceFromPoint, overridableWanderPriority.priority, maxDurationTicks);
        }
        return new WanderBackToPointGoal(mob, livingEntity, pathfinderMob, blockLocation, maximumDistanceFromPoint, overridableWanderPriority.priority, maxDurationTicks);
    }

    public void setBlockInNativeDataPalette(World world, int x, int y, int z, BlockData blockData, boolean applyPhysics) {
        MassEditBlocks.setBlockInNativeDataPalette(world, x, y, z, blockData, applyPhysics);
    }

    public AbstractPacketBundle createPacketBundle() {
        return new PacketBundle();
    }
}

