/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_20_R3.packets;

import com.google.common.collect.Sets;
import com.magmaguy.easyminecraftgoals.internal.PacketEntityInterface;
import com.magmaguy.easyminecraftgoals.v1_20_R3.packets.PacketBundle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractPacketEntity<T extends net.minecraft.world.entity.Entity>
implements PacketEntityInterface {
    private static final Method GET_WORLD_METHOD;
    protected final T entity;
    private final Set<UUID> viewers = Sets.newConcurrentHashSet();
    private final List<Runnable> removeCallbacks = new LinkedList<Runnable>();
    protected boolean visible = true;

    private static World getWorldFromLevel(Level level) {
        try {
            return (World)GET_WORLD_METHOD.invoke((Object)level, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get world from level", e);
        }
    }

    public List<Player> getViewersAsPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    protected AbstractPacketEntity(Location location) {
        this.entity = this.createEntity(location);
    }

    protected abstract T createEntity(Location var1);

    public void addViewer(UUID player) {
        this.viewers.add(player);
    }

    public void removeViewer(UUID player) {
        this.viewers.remove(player);
    }

    public void addRemoveCallback(Runnable callback) {
        this.removeCallbacks.add(callback);
    }

    protected Level getNMSLevel(Location location) {
        return ((CraftWorld)location.getWorld()).getHandle();
    }

    public T getNMSEntity() {
        return this.entity;
    }

    public <B extends Entity> B getBukkitEntity() {
        return (B)this.entity.getBukkitEntity();
    }

    public Location getLocation() {
        return new Location(AbstractPacketEntity.getWorldFromLevel(this.entity.level()), this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getYRot(), this.entity.getXRot());
    }

    public UUID getUniqueId() {
        return this.entity.getUUID();
    }

    protected Packet<?> createEntityDataPacket() {
        List dataValues = this.entity.getEntityData().getNonDefaultValues();
        if (dataValues == null) {
            return null;
        }
        return new ClientboundSetEntityDataPacket(this.entity.getId(), dataValues);
    }

    public Packet<?> generateRemovePacket() {
        return new ClientboundRemoveEntitiesPacket(new int[]{this.entity.getId()});
    }

    public void remove() {
        this.sendPacket(this.generateRemovePacket());
        this.removeCallbacks.forEach(Runnable::run);
    }

    public Packet<?> generateSetVisiblePacket(boolean visible) {
        this.visible = visible;
        if (visible) {
            return this.createEntityDataPacket();
        }
        return new ClientboundRemoveEntitiesPacket(new int[]{this.entity.getId()});
    }

    public void setVisible(boolean visible) {
        this.sendPacket(this.generateSetVisiblePacket(visible));
    }

    public Packet<?> generateHideFromPacket(UUID uuid) {
        if (!this.viewers.contains(uuid)) {
            return null;
        }
        this.removeViewer(uuid);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return new ClientboundRemoveEntitiesPacket(new int[]{this.entity.getId()});
    }

    public void hideFrom(UUID uuid) {
        this.sendPacket(this.generateHideFromPacket(uuid));
    }

    public List<Packet<?>> generateDisplayToPackets(Player player) {
        ArrayList packets = new ArrayList();
        if (this.viewers.contains(player.getUniqueId())) {
            return packets;
        }
        this.addViewer(player.getUniqueId());
        packets.add((Packet<?>)new ClientboundAddEntityPacket(this.entity.getId(), this.entity.getUUID(), this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getXRot(), this.entity.getYRot(), this.entity.getType(), 0, new Vec3(0.0, 0.0, 0.0), 0.0));
        packets.add(this.createEntityDataPacket());
        return packets;
    }

    public void displayTo(Player player) {
        this.generateDisplayToPackets(player).forEach(packet -> this.sendPacket(player, (Packet<?>)packet));
    }

    public void teleport(Location location) {
        this.entity.teleportTo(location.getX(), location.getY(), location.getZ());
        this.sendTeleportPacket();
    }

    protected void sendTeleportPacket() {
        this.sendPacket(this.generateTeleportPacket());
    }

    protected Packet<?> generateTeleportPacket() {
        return new ClientboundTeleportEntityPacket(this.entity);
    }

    public Packet generateMovePacket(Location location) {
        double deltaZ;
        double deltaY;
        Location oldPos = this.getLocation();
        this.entity.setPos(location.getX(), location.getY(), location.getZ());
        this.entity.setYRot(location.getYaw());
        this.entity.setXRot(location.getPitch());
        Packet movePacket = null;
        if (this.viewers.isEmpty()) {
            return movePacket;
        }
        Location newPos = this.getLocation();
        if (oldPos.getWorld() != newPos.getWorld()) {
            return this.generateTeleportPacket();
        }
        double deltaX = newPos.getX() - oldPos.getX();
        if (deltaX * deltaX + (deltaY = newPos.getY() - oldPos.getY()) * deltaY + (deltaZ = newPos.getZ() - oldPos.getZ()) * deltaZ > 256.0) {
            return this.generateTeleportPacket();
        }
        return new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), (short)(deltaX * 4096.0), (short)(deltaY * 4096.0), (short)(deltaZ * 4096.0), (byte)(newPos.getYaw() * 256.0f / 360.0f), (byte)(newPos.getPitch() * 256.0f / 360.0f), true);
    }

    public void move(Location location) {
        this.sendPacket(this.generateMovePacket(location));
    }

    protected void sendPacket(Player player, Packet<?> ... nmsPackets) {
        ServerPlayer nmsPlayer = this.getNMSPlayer(player);
        for (Packet<?> nmsPacket : nmsPackets) {
            if (nmsPacket == null) continue;
            nmsPlayer.connection.send(nmsPacket);
        }
    }

    protected void sendPacket(Packet<?> nmsPacket) {
        for (UUID viewer : this.viewers) {
            Player player = Bukkit.getPlayer((UUID)viewer);
            if (player == null) {
                this.viewers.remove(viewer);
                continue;
            }
            this.sendPacket(player, nmsPacket);
        }
    }

    public PacketBundle createPacketBundle() {
        return new PacketBundle();
    }

    protected ServerPlayer getNMSPlayer(Player bukkitPlayer) {
        return ((CraftPlayer)bukkitPlayer).getHandle();
    }

    static {
        try {
            GET_WORLD_METHOD = Level.class.getMethod("getWorld", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find getWorld method", e);
        }
    }
}

