/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_20_R2.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PacketBundle
implements AbstractPacketBundle {
    private final List<PacketBundleEntry> entries = new ArrayList<PacketBundleEntry>();

    public void addPacket(Object packet, List<Player> viewers) {
        this.entries.add(new PacketBundleEntry((Packet)packet, viewers));
    }

    public void send() {
        HashMap<Player, List> playerPackets = new HashMap<Player, List>();
        for (PacketBundleEntry entry : this.entries) {
            if (entry.viewers().isEmpty() || !this.isClientGamePacket(entry.packet())) continue;
            Packet<?> clientPacket = entry.packet();
            for (Player viewer : entry.viewers()) {
                playerPackets.computeIfAbsent(viewer, k -> new ArrayList()).add(clientPacket);
            }
        }
        playerPackets.forEach((player, packets) -> {
            if (!packets.isEmpty() && player != null && player.isOnline()) {
                ClientboundBundlePacket bundle = new ClientboundBundlePacket(new HashSet(packets));
                this.sendPacketBundle((Player)player, (Packet<?>)bundle);
            }
        });
    }

    private boolean isClientGamePacket(Packet<?> packet) {
        return packet != null;
    }

    private void sendPacketBundle(Player player, Packet<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.c.b(nmsPacket);
    }

    private record PacketBundleEntry(Packet<?> packet, List<Player> viewers) {
    }
}

