/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_20_R1.wanderbacktopoint;

import com.google.common.collect.ImmutableList;
import com.magmaguy.easyminecraftgoals.NMSManager;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointEndEvent;
import com.magmaguy.easyminecraftgoals.events.WanderBackToPointStartEvent;
import com.magmaguy.easyminecraftgoals.internal.AbstractWanderBackToPoint;
import com.magmaguy.easyminecraftgoals.utils.Utils;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WanderBackToPointBehavior
extends bhr<bfz>
implements AbstractWanderBackToPoint {
    private final Location returnLocation;
    private final double maximumDistanceFromPoint;
    private final LivingEntity livingEntity;
    private final bgb mob;
    private final int maxDurationTicks;
    private long lastTime;
    private int priority;
    private float speed;
    private int stopReturnDistance = 0;
    private int goalRefreshCooldownTicks = 60;
    private boolean hardObjective = false;
    private boolean teleportOnFail = false;
    private boolean startWithCooldown = false;
    private dxt path = null;

    public WanderBackToPointBehavior(LivingEntity livingEntity, bgb mob, Location location, double maximumDistanceFromPoint, int priority, int maxDurationTicks) {
        super(Map.of(bpb.m, bpc.c), 0, maxDurationTicks);
        this.livingEntity = livingEntity;
        this.mob = mob;
        this.returnLocation = location;
        this.maximumDistanceFromPoint = maximumDistanceFromPoint;
        this.maxDurationTicks = maxDurationTicks;
        this.priority = priority;
        this.lastTime = 0L;
    }

    protected boolean a(aif var0, bfz nmsLivingEntity) {
        if (!this.hardObjective && this.mob.j() instanceof byo) {
            this.updateCooldown();
            return false;
        }
        if (this.lastTime + 50L * (long)this.goalRefreshCooldownTicks - System.currentTimeMillis() > 0L) {
            return false;
        }
        this.updateCooldown();
        if (Utils.distanceShorterThan((Vector)this.returnLocation.toVector(), (Vector)this.livingEntity.getLocation().toVector(), (double)this.maximumDistanceFromPoint)) {
            return false;
        }
        WanderBackToPointStartEvent wanderBackToPointStartEvent = new WanderBackToPointStartEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointStartEvent);
        if (wanderBackToPointStartEvent.isCancelled()) {
            return false;
        }
        this.path = ((bgi)nmsLivingEntity).J().a(this.returnLocation.getX(), this.returnLocation.getY(), this.returnLocation.getZ(), this.stopReturnDistance);
        if (this.teleportOnFail && (this.path == null || !this.path.j())) {
            this.path = null;
            this.livingEntity.teleport(this.returnLocation);
            WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
            Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
            return false;
        }
        return true;
    }

    protected void d(aif var0, bfz var1, long var2) {
        this.mob.J().n();
        this.mob.J().a(this.path, (double)this.speed);
        this.mob.dK().a(bzz.a);
        if (this.hardObjective) {
            new BukkitRunnable(){

                public void run() {
                    if (!WanderBackToPointBehavior.this.livingEntity.isValid() || WanderBackToPointBehavior.this.mob.J().l() || WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.j()) {
                        this.cancel();
                        if (WanderBackToPointBehavior.this.livingEntity.isValid() && (WanderBackToPointBehavior.this.path == null || !WanderBackToPointBehavior.this.path.j()) && WanderBackToPointBehavior.this.teleportOnFail) {
                            WanderBackToPointBehavior.this.livingEntity.teleport(WanderBackToPointBehavior.this.returnLocation);
                        }
                        return;
                    }
                    WanderBackToPointBehavior.this.mob.J().a(WanderBackToPointBehavior.this.path, (double)WanderBackToPointBehavior.this.speed);
                }
            }.runTaskTimer(NMSManager.pluginProvider, 0L, 1L);
        }
    }

    protected void b(aif var0, bfz var1, long var2) {
        this.path = null;
        if (this.teleportOnFail && this.a(this.maxDurationTicks)) {
            this.livingEntity.teleport(this.returnLocation);
        }
        WanderBackToPointEndEvent wanderBackToPointEndEvent = new WanderBackToPointEndEvent(this.hardObjective, this.livingEntity, (AbstractWanderBackToPoint)this);
        Bukkit.getPluginManager().callEvent((Event)wanderBackToPointEndEvent);
        this.updateCooldown();
        this.mob.v(true);
    }

    protected boolean a(aif var0, bfz var1, long var2) {
        this.mob.h(null);
        if (this.path == null) {
            return false;
        }
        if (!this.hardObjective && this.mob.j() instanceof byo) {
            return false;
        }
        return !this.path.c();
    }

    public double getMaximumDistanceFromPoint() {
        return this.maximumDistanceFromPoint;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getMaxDurationTicks() {
        return this.maxDurationTicks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public AbstractWanderBackToPoint setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public Location getReturnLocation() {
        return this.returnLocation;
    }

    public int getStopReturnDistance() {
        return this.stopReturnDistance;
    }

    public AbstractWanderBackToPoint setStopReturnDistance(int distance) {
        this.stopReturnDistance = distance;
        return this;
    }

    public int getGoalRefreshCooldownTicks() {
        return this.goalRefreshCooldownTicks;
    }

    public AbstractWanderBackToPoint setGoalRefreshCooldownTicks(int ticks) {
        this.goalRefreshCooldownTicks = ticks;
        return this;
    }

    public boolean isHardObjective() {
        return this.hardObjective;
    }

    public AbstractWanderBackToPoint setHardObjective(boolean hardObjective) {
        this.priority = -1;
        this.hardObjective = hardObjective;
        return this;
    }

    public boolean isTeleportOnFail() {
        return this.teleportOnFail;
    }

    public AbstractWanderBackToPoint setTeleportOnFail(boolean teleportOnFail) {
        this.teleportOnFail = teleportOnFail;
        return this;
    }

    public boolean isStartWithCooldown() {
        return this.startWithCooldown;
    }

    public AbstractWanderBackToPoint setStartWithCooldown(boolean startWithCooldown) {
        this.startWithCooldown = startWithCooldown;
        return this;
    }

    public void updateCooldown() {
        this.lastTime = System.currentTimeMillis();
    }

    public void register() {
        if (this.startWithCooldown) {
            this.updateCooldown();
        }
        this.mob.dK().a(bzz.a, this.priority, ImmutableList.of((Object)((Object)this)));
    }

    public void unregister() {
    }
}

