/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.easyminecraftgoals.v1_19_R3.packets;

import com.magmaguy.easyminecraftgoals.internal.AbstractPacketBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PacketBundle
implements AbstractPacketBundle {
    private final List<PacketBundleEntry> entries = new ArrayList<PacketBundleEntry>();
    private static final int MAX_PACKETS_PER_BUNDLE = 3000;

    public void addPacket(Object packet, List<Player> viewers) {
        this.entries.add(new PacketBundleEntry((vb)packet, viewers));
    }

    public void send() {
        HashMap<Player, List> playerPackets = new HashMap<Player, List>();
        for (PacketBundleEntry entry : this.entries) {
            if (entry.viewers().isEmpty() || !this.isClientGamePacket(entry.packet())) continue;
            vb<?> clientPacket = entry.packet();
            for (Player viewer : entry.viewers()) {
                playerPackets.computeIfAbsent(viewer, k -> new ArrayList()).add(clientPacket);
            }
        }
        playerPackets.forEach((player, packets) -> {
            if (packets.isEmpty() || player == null || !player.isOnline()) {
                return;
            }
            for (int i = 0; i < packets.size(); i += 3000) {
                int end = Math.min(i + 3000, packets.size());
                List chunk = packets.subList(i, end);
                vq bundle = new vq(new HashSet(chunk));
                this.sendPacketBundle((Player)player, (vb<?>)bundle);
            }
        });
        int bundleCount = playerPackets.values().stream().mapToInt(packets -> (packets.size() + 3000 - 1) / 3000).sum();
    }

    private boolean isClientGamePacket(vb<?> packet) {
        return packet != null;
    }

    private void sendPacketBundle(Player player, vb<?> nmsPacket) {
        if (nmsPacket == null) {
            return;
        }
        aiq nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsPlayer.b.a(nmsPacket);
    }

    private record PacketBundleEntry(vb<?> packet, List<Player> viewers) {
    }
}

